







                           X    X  XXXXXX  XXXXX 
                           X    X  X       X    X
                           X    X  XXXXX   X    X
                           X    X  X       X    X
                           X    X  X       X    X
                            XXXX   XXXXXX  XXXXX 


                              Reference Manual





                           somteimes known as the

                            Universal Editor for

                        Documentation and other stuff









































      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED





      1.  Orientation

           UED is based on the famoues qed [1] editor.  It  treats  the
      file as a sequence of arbitrary length lines, and most operations
      are performed on groups of one or more lines.   A  discussion  of
      the philosophy can be found in [2].  This document is intended as
      the UED reference manual; for an introduction to  the  basics  of
      editing read [3] thoroughly.  Make sure you have the JPL version.
      This manual assumes you have read [3].

           UED actually operates on a copy of the file it  is  editing;
      thus changes made in the copy have no effect on the file until it
      is written to disk.  The copy of the text being edited resides in
      a temporary file called the buffer.  There is only one buffer.

           The buffering of changes has advantages  and  disadvantages.
      One major advantage is that if you decide you don't like what you
      have been doing, you can exit the editor (without writing out the
      buffer)  and  the  file you were editing will be unaffected.  The
      disadvantage is that if you accidentally exit the editor  without
      writing  out the buffer, you will lose your work.  As long as you
      exit from the editor normally, this will never happen, and an ab-
      normal  exit  will  result in complaints followed by eventual ac-
      quiescence.

           Commands to UED have a simple and regular structure: zero or
      more addresses followed by a command, possibly followed by param-
      eters to the command. These addresses specify one or  more  lines
      in  the buffer. Every command that requires addresses has default
      addresses, so that the addresses can often be omitted.   In  gen-
      eral, only one command may appear on a line.

           Certain commands allow the input  of  text.   This  text  is
      placed  in the appropriate place in the buffer.  While UED is ac-
      cepting text, it is said to be in input mode.  In this  mode,  no
      commands  are  recognized;  all input is merely collected.  Input
      mode is terminated by typing a period "." alone at the  beginning
      of a line.

           Large files can sometimes cause a problem in that the  temp-
      file  handling  gets  overloaded.  If this happens, UED complains
      until the user fixes the situation; no commands will be  allowed.
      The solution to this problem is simple; it is known as the "stan-
      dard tricky sequence" and consists of a `w' command  followed  by
      an `e' command.  Both of these commands are discussed later.

           The RSX implementation of UED maintains  some  online  help.
      To use, just do the command:

                                   h ued*

      where * is a number.  Every once in a while a new help segment is
      added.  This document covers up to and including help number 17.

                                    - 1 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


           There are a few auxiliary versions of UED running around:

                bed - for very big files
                ev  - for VT100 terminals
                ged - can execute indirect command files




      2.  Regular Expressions

           UED supports a "regular expression" notation.  A regular ex-
      pression  specifies  a set of strings of characters, and a member
      of this set of strings is said to be "matched" by the regular ex-
      pression.  The regular expressions allowed by UED are constructed
      as follows:


      1.   An ordinary character (but not one of the special characters
           discussed below) matches itself only.

      2.   A circumflex "^" at the beginning of  a  regular  expression
           matches the null character at the beginning of a line.

      3.   A dollar sign "$" at the end of a regular expression matches
           the null character at the end of a line.

      4.   A period "." matches any character except a newline  charac-
           ter (i.e.  it will not cross line boundaries).

      5.   A string of characters enclosed in  square  brackets  ("[]")
           matches  any character in the string but no others. This no-
           tation is called a  "character  class".   If,  however,  the
           first  character of the string is a circumflex "^" the regu-
           lar expression matches any character except newline and  the
           characters in the string (called a negated character class).
           For example:  "[abc]"  matches  an  a,  b,  or  a  c.   "^A"
           (control-A)   matches  nonprinting  characters.   Continuous
           ranges may be specified by giving the endpoints separated by
           a  hyphen.   For  example:  "[0-9]"  matches  any digit, and
           "[0-9A-Za-z]" matches any alphameric.

      6.   An asterisk following a character or a character class or  a
           special  character causes a match of 0 or more occurances of
           the preceding regular expression.  When more than one string
           on  the  line would match, the longest one starting from the
           beginning of the substring preceding the `*' is used.
           For example: ".*" matches the entire line; "a*" matches  any
           length  string  of a's, including zero; "[abc]*" matches any
           number of characters all of which are either  a,  b,  or  c.
           (again,  the  expression  also matches zero occurences). The
           regular expression "^[0-9][0-9]*" matches any line beginning
           with  a number; "^$" matches null lines; "^ *$" matches null
           lines or those with only blanks.

      7.   Regular expressions can be concatenated.  The net effect  is

                                    - 2 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


           that  each  component  of  the new regular expression has to
           match in order for the whole expression to match.

      8.   A null regular expression is equivalent to the last  regular
           expression  encountered.   A regular expression is specified
           as a string of characters delimited by a pair of characters,
           so  a  null  regular  expression is simply the two delimiter
           characters.

      Regular expressions are used in addresses to specify lines and in
      one command (substitute) to specify a portion of a line to be re-
      placed.  To use regular expression metacharacters (such as $ [  ]
      etc.) as an ordinary character, that character may be preceded by
      "\". This also applies to the character  delimiting  the  regular
      expression and to "\" itself.



      3.  Addresses

           To understand addressing in UED it is necessary to know that
      at  any  time there is a current line, called `.' or `dot'.  Gen-
      erally speaking, the current line is the last line affected by  a
      command;  however,  the  exact effect on the current line is dis-
      cussed under the description of the command. Addresses  are  con-
      structed as follows:


      1.   The character `.' addresses the current line.

      2.   The character `$' addresses the last line of the buffer.

      3.   A decimal number N addresses the N-th line  of  the  buffer.
           Note that line numbers are relative  to the beginning of the
           the buffer and that they change  when  lines  are  added  or
           deleted.

      4.   A line number of 0 indicates that the new text is to  become
           the top line(s) of the buffer.

      5.   A regular expression enclosed in slashes `/'  addresses  the
           first  line  found by searching toward the end of the buffer
           and stopping at the first line containing a string  matching
           the  regular  expression.   If  necessary  the  search wraps
           around to the beginning of the buffer.

      6.   A regular expression enclosed  in  question  marks  `?'  ad-
           dresses  the first line found by searching toward the begin-
           ning of the buffer and stopping at the first line containing
           a  string matching the regular expression. If necessary, the
           search wraps around to the end of the buffer.

      7.   An address followed by a plus sign `+' (minus sign `-') fol-
           lowed  by a decimal number specifies the stated address plus
           (minus) the indicated number of lines.


                                    - 3 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


      8.   If an address begins with `+' or `-' the  addition  or  sub-
           traction  is  taken  with  respect to the current line; e.g.
           `-5' is understood to mean `.-5'.

      9.   If an address ends with `+' or `-', then 1  is  added  (sub-
           tracted).  As a consequence of this rule and rule 8, the ad-
           dress `-' refers to the line before the  current  line,  and
           `+' refers to the next line.  Moreover, trailing `+' and `-'
           characters have cumulative effect, so  `--'  refers  to  dot
           less  2. Also, the escape key is equivalent to `.-1' and the
           carriage return alone refers to `.+1'.

      10.  The space bar when used as an address stands  for  the  last
           address  pair specified (if one exists). This is very useful
           when working on a set of lines where one wants to modify all
           the  lines  in  the  same way  without retyping the range of
           lines each time.  The "last" range is  saved  until  another
           address  pair is input (i.e. single address commands and the
           "z" command don't change them).  This is also the recomended
           way  of  deleting  multiple  lines; first print the range of
           lines to be deleted, then issue the delete using  the  space
           bar abbreviation to insure which lines will be deleted.

      Commands may require zero, one, or two addresses. Commands  which
      require  no addresses regard the presence of an address as an er-
      ror. Commands that accept one or two address assume  default  ad-
      dresses  when insufficient addresses are given. If more addresses
      are given than such a command  requires,  the  last  one  or  two
      (depending on what is accepted) are used.

           Addresses are separated from each other typically by a comma
      `,'. They may also be separated by a semicolon `;', in which case
      the current line is set to the first address before the next  ad-
      dress  is  interpreted. This feature can be used to determine the
      starting line for forward and backward searches (`/',  `?').  The
      second  address  of any two-address sequence must correspond to a
      line after the line corresponding to the first address.

           In the discussion of UED commands, the default addresses are
      shown  in  parentheses.  The  parentheses are not part of the ad-
      dress, but are used to show what addresses are the default.

           As mentioned, it is generally illegal for more than one com-
      mand  to  appear on a line.  However, any command may be suffixed
      by `p', in which case the current line is printed.



      4.  File Operations

           This section deals with getting or  putting  text  files  to
      mass  storage.  Filenames must conform to whatever operating sys-
      tem UED is running on.  All of the  commands  discussed  in  this
      section  require  a  blank  between the command character and the
      file name.


                                    - 4 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED




      4.1  Edit file
                                 e filename

      Clears the entire contents of the buffer and reads in  the  named
      file.  Dot is set to the first line of the buffer.  The number of
      lines read is typed.  `filename' is remembered for a possible use
      as  a  default file name in a subsequent e, r, w, x, or control-z
      command.  If the file does not exist, but is an  otherwise  valid
      filename, (UED will tell you it can't open the file) it is remem-
      bered for a later w, x, or control-z.



      4.2  Join to another file
                               (.,$)j filename

      Appends the addressed lines to the specified file.  If  the  file
      does  not  exist,  it is created.  The last of the appended lines
      becomes the current line.



      4.3  Read in file
                                ($)r filename

      Reads in the given file after the addressed  line.   If  no  file
      name  is  given, the remembered file name, if any, is used (see e
      and f commands). The remembered file name is not  changed  unless
      `filename' is the very first file name mentioned.  If the read is
      successful, the number of lines is typed. `.' is left at the last
      line read in from the file.



      4.4  Write out file
                               (1,$)w filename

      Writes the addressed lines ONTO (updating) the given file; if  it
      does not exist it is created.  This command destroys the contents
      of the file if it exists; therefore, the X command is  recomended
      to write out the buffer.  Only when the user is sure that the old
      file is of no use should the WRITE command be given.



      4.5  neXt version
                               (1,$)x filename

      This command is similar to the W command,  but  in  RSX  it  will
      write the file to the next higher version number (of filename) if
      a file with the name `filename' allready exists. If none  exists,
      then  it is created with a version number of 1.  This command may
      be combined with an exit by using the  control-Z  command.   This
      command along with the w command should be used periodically dur-

                                    - 5 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


      ing a long input session to safeguard against system crashes.



      4.6  Update file
                                  control-Z

      This command is executed by pressing the control and  Z  keys  at
      the same time.  It is a macro which is translated into an X, then
      an F, and then a Q command.  It has the effect of writing out the
      remembered file (the one named in the E command or on the initial
      command line to UED) as a new version, then it echoes the name of
      the  file  just written and exits. This is the prefered method of
      exiting an edit session, because a) it writes a  new  version  of
      the  file, thus performing an editing backup, and b) it preserves
      the file protection status,  so  the  user  doesn't  have  to  go
      through the file system to reset it.



      5.  Position



      5.1  print line
                               (.+1)<newline>

      An address alone on a line causes the addressed line to be print-
      ed.  A blank line alone is equivalent to `.+1p'; it is useful for
      stepping through text.



      5.2  print line
                                  <ESCAPE>

      The escape key (no need for a carriage return  after  the  escape
      key) is equivalent to `.-1p'; along with the above <newline> com-
      mand is useful for stepping forward and backward through text.



      5.3  search forwards
                            /regular expression/

      Starting from line dot plus one, searches the text buffer for the
      given regular expression.  If found, dot will be set to the first
      occurrence of the regular expression and the line will be  print-
      ed.  This command may be compounded, e.g. four slashes alone as a
      command means search for the last named regular expression,  then
      search  for  it again.  The search will wrap around to the begin-
      ning of the buffer if necessary.  If the  regular  expression  is
      not found, dot will be unchanged.




                                    - 6 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


      5.4  search backwards
                            ?regular expression?

      Same as search forwards except that the search starts at line dot
      minus one, proceeds backwards, and wraps around to the end of the
      text buffer.



      6.  Text Alteration



      6.1  Append
                                   (.)a  
                                   <text>
                                   .

      Appends the given text after the addressed line. `.' is  left  at
      the last line input; if there were none, at the addressed line.



      6.2  line append
                                (.,.)a<text>

      This version of the append command appends text to the end of the
      addressed lines.

                                  NOTE WELL
           This command is implemented as a macro equivalent to
                                 s!$!<text>.
           The `!' is for visibility and is actually a  control-A.
           But since this command is  a macro, appending text that
           contains `\' or the `&' needs to be  escaped  with  the
           `\' to nullify their special meaning.  If it is desired
           not to print the new line a control-A may  be  appended
           to  the  command  (also useful for a multi-command glo-
           bal).




      6.3  Change
                                   (.,.)c
                                   <text>
                                   .

      Deletes the addressed lines, then accepts  input  text  that  re-
      places  these lines. `.' is left at the last line input; if there
      was none, it is left at the first line not deleted.



      6.4  Delete
                                   (.,.)d

                                    - 7 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED



      Deletes the addressed lines from the buffer.  The line originally
      after  the  last  line  deleted  becomes the current line; if the
      lines deleted were originally at the end, the new last  line  be-
      comes the current line.



      6.5  Insert
                                   (.)i  
                                   <text>
                                   .

      Inserts the given text before the addressed line.  Dot is left at
      the  last line input; if there were none, then at the line BEFORE
      the addressed line.  This is equivalent to `.-1a'



      6.6  line insert
                                (.,.)i<text>

      This version of the INSERT command inserts text in the  front  of
      the  current  line.   The same restrictions hold as in the append
      command described above.



      6.7  Kopy
                                   (.,.)ka

      Makes a copy of the addressed lines and places them in the buffer
      after  the  addressed  line `a'. The last of the copied lines be-
      comes the current line.



      6.8  Move
                                   (.,.)ma

      Repositions the addressed lines after the line  addressed  by  a.
      The last of the moved lines becomes the current line.



      6.9  Tag lines
                                   (.,.)t

      Tags the addressed lines as  boundaries.   These  boundaries  are
      used as the previous address range when a space is used as an ad-
      dress.  A `t' by itself marks the addressed line  as  both  upper
      and  lower  limits  of  the  range.  A `tu' marks it as being the
      upper limit, whereas a `tl' marks it as being the lower.   Alter-
      natively,  a  `tt'  will  mark it as being either upper or lower,
      whichever would be closest (this is determined by arithmetic com-
      parison of the line numbers).  The range can be explicitly speci-

                                    - 8 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


      fied by "i,jt", which would set line -i- as the  upper  and  line
      -j- as the lower.

      Note that a tag marks the specified lines of text, not their  ad-
      dresses.   If  text  is  added inside or outside the tagged range
      then UED adjusts its internal pointers to  remain  fixed  on  the
      original  tagged lines.  If either tagged line is deleted the tag
      will be adjusted: if the top is deleted it moves down one, and if
      the bottom is deleted it moves up one.



      6.10  Concatenate
                                      "

      Concatenates line dot plus one to line dot and deletes  line  dot
      plus one (i.e. merges line dot with line dot+1).



      7.  String Substitution



      7.1  Substitute
                   (.,.)s#/regular expression/replacement/

      Searches each addressed line for an occurrence of  the  specified
      regular  expression.   Any  character other than space or newline
      may be used instead of `/' to delimit the regular expression  and
      the replacement. `.' is left at the last line substituted.

      An ampersand `&' appearing in the replacement is replaced by  the
      string  matching  the  regular expression. The special meaning of
      the `&' in this context may be suppressed by preceding it by `\'.
      This  may be used more than once on the line; useful for creating
      pip command files since g/.*/s//&=&  will take  all  lines  in  a
      file  containing  a  list  of  file  names  and  turn  them  into
      "file=file".

      The ampersand has three special cases you should know about.   If
      it  is followed by '\u' it will convert all alphabetic characters
      from the matched string into upper case.  Conversely, if the  am-
      persand  is  followed  by  '\l', the characters go to lower case.
      Lastly, the characters in the  matched  string  will  be  flipped
      (e.g.  "abcd"  goes  to  "dcba")  if the ampersand is followed by
      '\r'.  This is useful, for example, in untangling the speech of a
      wizard.

      Lines may be split by substituting newline characters into  them.
      The  newline  (line-feed) must be escaped by preceding it by `\'.
      Note that the line is not treated as  two  separate  lines  until
      written  out and read back in, rather it is simply a line with an
      imbedded newline.

      The trailing delimiter (`/') is optional. If it is not given, UED

                                    - 9 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


      will assume its presence along with a training `p' command.

      The # that follows the `s' is optional and means  substitute  the
      #-th  occurance  of the regular expression. Also, if # is 0, then
      it means do the substitution to all occurances of the regular ex-
      pression  on  the current line. The default value for # is 1.  To
      change all occurances of the string "old" to "new"  can  be  done
      via: g/old/s0//new or as 1,$s0/old/new.

      This feature can be used to substitute the n-m'th characters in a
      line.   s10/..../   will  match  columns  10-13,  s20/.*/ matches
      columns 20-end of the line.

      It is true that:		s/from/to/gp
      is exactly the same as:	s0/from/to



      7.2  Undo
                                      u

      This command will undo the last substitution ('s'  command).   It
      may  be  issUED on a line by itself or with any other command ap-
      pended to it.  A common editing error is to change the wrong pat-
      tern  on the line (usually because of an earlier match). The fol-
      lowing example illustrates a common use of `u'.

              line:  This is thi kind of common error.
           command:  s/thi/the
            result:  Thes is thi kind of common error.

      To correct this by restoring the original line and  changing  the
      second (desired) occurance of `thi' to `the':

                                  us2//the

      This takes advantage of the fact that the  previous  pattern  was
      valid  (and  remembered  by UED) but the default is to select the
      1st occurance of the pattern. The final result is:

                  final: This is the kind of common error.

      Note: You must issue the 'u' command  immediatly  after  the  bad
      substitution.   You  can't  move the pointer around first.  Since
      the `i' and `a' commands have versions which are actually substi-
      tute  commands  (hidden  with a macro), the `u' command will undo
      those as well.



      8.  Information



      8.1  File information
                                 f filename

                                   - 10 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED



      Prints the currently remembered file  name.   If  a  filename  is
      given,  the  currently  remembered  file  name is changed to that
      name.  In screen mode, also prints the values of ., $, the  temp-
      file pointer, and the margin settings.

      On Telerays, if the `f' is  preceded  by  a  blank  (to  indicate
      tagged  range),  UED will dim the text not in the tagged range in
      addition to displaying the file information.  Type a carriage re-
      turn to get back to the command interpreter.



      8.2  Print
                                   (.,.)p

      Prints the addressed lines. `.' is left at the last line printed.
      The `p' may be omitted if the command is not in a global command.
      That is to say, addr1,addr2 will print  from  addr1  thru  addr2.
      Control  characters (except tab, bell, newline, and vertical tab)
      will print as a `?'.



      8.3  show surrounding text
                                 (.)z[+-][n]

      This command lists n lines either just before (-n),  around  (n),
      or  after  (+n) the specified line.  Dot is not changed.  The de-
      fault value for `n' is 21 lines. If `n' is specified as a `z' (as
      in  `zz')  this  will print the entire buffer without moving dot.
      If the line number print option (see `o' command option  `n')  is
      selected,  the  z command will mark the current line with `--' to
      the right of the line number.



      8.4  print address
                                    (.)=

      Displays the line number of the addressed line.  Useful for find-
      ing  the  line  number of the next occurrence of some regular ex-
      pression.



      8.5  next page
                                    (.)&

      Fetches the next page of text.  In line mode, this means that UED
      prints the addressed line and the (up to) 21 following lines.  In
      screen mode,  it  gets  the  next  page  of  text,  and  is  thus
      equivalent to "+22".  Dot is left at the last line printed.




                                   - 11 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


      9.  Special Commands



      9.1  Global
                      g/regular expression/command list

      In the GLOBAL command, the first step is to mark every line  that
      matches  the  given regular expression. Then for every such line,
      the given command list is executed with `.' initially set to that
      line.  A single command or the first of multiple commands appears
      on the same line with the global command. All lines of  a  multi-
      line  list except the last line must be ended with `\'. a, i, and
      c commands and associated input are permitted; the `.'  terminat-
      ing  input mode may be omitted if it would be on the last line of
      the command list. The (global) commands g, and v, are not permit-
      ted in the command list.



      9.2  Quit
                                      q

      Tells UED to exit.  No automatic  write  of  the  file  is  done,
      although if the file has not recently been written, UED will com-
      plain  instead  of  exiting.   Another  `q'   given   immediately
      thereafter  will  effect  an exit.  See the control-Z command.  A
      command of 'qq' has the same effect as two 'q' commands.



      9.3  inVerse
                      v/regular expression/command list

      Same as the `g' command except that the command list is  executed
      with `.' initially set to every line that does not match the reg-
      ular expression.



      9.4  temporary escape
                                 !<command>

      This command allows a temporary escape from the editor to perform
      system commands.



      10.  Screen Modes



      10.1  window mode
                                 (.)b[x[y]]

      Causes UED to go into window mode after setting dot  to  the  ad-

                                   - 12 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


      dressed  line.  The top 22 lines of the screen form the text win-
      dow, and the bottom two are used for interaction.  Dot is  always
      kept  centered  in  the  window; carriage returns or escapes will
      cause the display to move up or down, respectively.   Any  locate
      command  will  also cause the display to either scroll or redraw.
      The first character following the `b' sets the background display
      mode;  default  is normal.  The second character sets the current
      line display mode; default is underline.   These  two  characters
      can  be  in either case.  See Appendix A for other possibilities.
      UED will reenter line mode after receiving an `e', `z',  `g',  or
      `=' command, or after a multi line print.


      10.1.1  Page Fetches -

           In window mode the ampersand alters its meaning slightly and
      a new command is provided.


      10.1.2  next page -
                                    (.)&

      Fetches the next page of text.  In screen mode, it gets the  next
      page  of  text,  and is thus equivalent to "+22".  Dot is left at
      the last line printed.


      10.1.3  previous page -
                                      %

      Fetches the previous page of text.  Equivalent to "-22"  (but  it
      doesn't go past the top of file).



      10.2  screen mode
                             l[#number][pattern]


           First, the important news: this mode works only on Telerays.

           L mode, or screen mode, puts the user in a situtation  where
      every  character  entered  is  acted  upon immediately.  The user
      types in either text or control characters; text is  placed  into
      memory  right  where  the  cursor  is, and control characters are
      treated as discussed below.  Control characters will be designat-
      ed by ^ followed by the letter.

           When invoking screen mode, the user can specify which column
      to  place  the  cursor; this ranges from 1-80 and is specified by
      typing the column number after a `#' character.  Also, a  regular
      expression can be given, in which case UED moves to the beginning
      of the first occurence of the regular expression  on  that  line.
      Don't use the slashes unless the pattern begins with a digit.  As
      usual, if just slashes are specified, UED uses the  last  regular
      expression it knows.

                                   - 13 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


           If no column number or regular expression is given,  or  the
      regular expression does not occur in the line, the cursor goes to
      column one.


      RETURN   move cursor to left margin of next line.  The  left
               margin  is  set  on entry into screen mode or the T
               command below. (moves the screen  rather  than  the
               cursor)

      ESCAPE   move  cursor  to  left  margin  of  preceding line.
               (moves the screen rather than the cursor)

      I and B  (control-I  is  TAB)  moves the cursor to the next
               tab position. Control-B  moves  it  backwards.  On
               Telerays  do  not  use  the backtab key. Note that
               these keys are only for cursor  positioning;  they
               do not enter any text.

      J and K  move cursor: J is left, K is right.

      Y and H  move cursor: Y is up, H is down.

      R and L  move  text  right  (R) or left (L) one column. Text
               moved past the cursor is deleted. Data  moved  past
               column 80 is not deleted, it's just invisible. Data
               moved past column 132, however, is deleted.

      A        Deletes  the  first chunk of whitespace between the
               cursor and the rest of the line.

      D        erase from cursor to end of line.

      E        expand mode. This is a toggle: whenever it is on  a
               RETURN  will  aause a new blank line to be inserted
               in the text. This mode continues until  another  ^E
               is typed or the user exits from screen mode.

      G        delete  the  current line. Cursor moves to the same
               column in line dot plus one. If line $  is  deleted
               the cursor instead moves to the new line $.

      N        exit from screen mode

      O        open  up  the  line.  Takes  the  rest  of the line
               starting from the cursor and adjusts it so it is on
               the right side of the  screen.  THIS  IS  ONLY  FOR
               COSMETIC   PURPOSES.   Now   the   user  can  enter
               additional text, and when done with  that,  another
               ^O  moves the original rest of the line and appends
               it to the modified line. Actually, the reattachment
               is performed when any of ^O, ^E, ^Z, ^C, RETURN, or
               ESCAPE. Even if the new text overtypes some of  the
               text that was shot to the right, UED will correctly
               reattach it.


                                   - 14 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


      P        moves   to  the  next  occurrence  of  the  pattern
               specified when entering screen mode. If there is no
               pattern, move to left margin. This command searches
               only on the current  line  and  will  wrap  to  the
               beginning  of  the  line if necessary. Note that if
               this command finds the pattern it resets  the  left
               margin.

      T        sets  the  left margin for RETURN and ESCAPE at the
               current cursor  position.  This  position  will  be
               remembered  until  it  is  reset or until exit from
               UED.

      U        restores the current line  to  its  original  state
               provided  you  have not moved the cursor to another
               line. Each time the cursor  is  moved  the  current
               line is permanently stored.

      V        line split. Remainder of line after cursor position
               becomes line dot plus one.

      W        word  tab.  Moves the cursor to the next word, i.e.
               the next sequence of alphameric  characters.  Wraps
               around to the beginning of the line if necessary.


           Exercise caution in typing past line 80; the  Teleray  might
      wrap  the  cursor, and UED's idea of where the cursor is will get
      screwed up.  If there is any question, exit from screen mode  and
      do  a  `b' command, then go back into screen mode.  Remember that
      the screen is only a display and may not represent  exactly  what
      is actually stored.

           If the cursor is on line 1 and an upwards  movement  is  at-
      tempted, UED complains and stays put.  If the cursor is on line $
      and a downwards movement is attempted, UED adds a new blank  line
      to the end of the buffer.

           When entering (exiting) screen mode  the  underline  on  the
      screen  will be removed (restored).  This applies only to Teleray
      terminals.

           An entry of control-? in  screen  mode  prints  a  two  line
      quickie help message.



      11.  New Commands

           These commands are all prefixed with the letter `n'.   There
      weren't any more letters in the Latin alphabet for more commands.



      11.1  enCrypt text
                               (1,$)nc<string>

                                   - 15 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED



      Performs a mysterious operation on the text in the buffer to make
      it  apparently  incomprehensible.  The nc command may be executed
      any number of times to compound the encryption.  De-encryption is
      performed  by executing the nc command with the same string; com-
      pound de-encryptions are performed by executing all the  nc  com-
      mands  that  were  given originally; they may be performed in any
      order.  Only the first 40 characters  of  the  given  string  are
      used.

                                    NOTE

           If any lines have imbedded newline characters the  user
           should execute the standard tricky sequence.  Otherwise
           only the characters before the newline will be encrypt-
           ed.




      11.2  new Substitute
                              (1,$)s0#/from/to

      This command is intended to globally change some regular  expres-
      sion.   Note that the default range is the whole text buffer, and
      all occurrences in each line will be changed.  The number follow-
      ing  the  `s'  can  be  overridden  by  typing the desired number
      directly after the "ns", e.g.

                                 ns2/from/to

      which would change the second occurrence in every line.   The  ns
      command can also be given a line range in the normal manner.



      11.3  enFormat
                            (.)nf p1 p2 p3 p4 p5

      Calls up a modest word processor to fill  and  justify  the  text
      within  the  given  line  range.  The parameters are optional and
      have the following functions:

      1.   Left margin
      2.   Right margin
      3.   Indent factor (can be 0)
      4.   Spacing
      5.   Justification flag (0 is off, 1 is on)

      If any parameters  are  not  specified  then  the  value  is  not
      changed.  For example, to change just the indent to 5:

                                   nf ,,5

      The line range is specified in the usual manner.  If  line  0  is
      specified,  this  indicates  to  UED to only change the parameter

                                   - 16 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


      values.

      An easy way to set the right and left margins is to let UED meas-
      ure one of the lines to be formatted.  Simply specify a period as
      the only parameter:

                                     nf.

      A convenient way to set the parameters would be to  find  a  line
      that has the correct size and issue:

                                    0nf.

      This command will measure the current line and set the parameters
      according to its extents.



      12.  Run-time Options



      12.1  Options
                               o[vtsinfabh?*]

      Permits selection of various run time options.  Multiple  options
      may be selected in one command by simple concatenation of the key
      letter.


      1.   v for verbose operation (long error messages)

      2.   t for terse operation

      3.   s to sense case in string matching

      4.   i to ignore case in string matching

      5.   n for line numbering on.

      6.   f for line numbering off (may be specified as off)

      7.   a is a toggle for screen mode that controls margin dragging.
           If oa is on then the tab and backtab functions will move the
           margin to the last postion that a tab or backtab moved to.

      8.   b is a toggle that controls the attempt to put leading  tabs
           back in the text

      9.   h is a toggle that redefines tabs (and back  tabs)  to  have
           only half their effect, i.e. the field width is 4 instead of
           8.  This applies only in screen mode.

      10.  * Resets all toggles to the default values enumerated below.

      11.  ?  This is not really an option; it is  used  to  print  the

                                   - 17 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


           value of the temp file pointer.  This works only when not in
           screen mode.

      The defaults are:

                        oi          - case insensitive
                        ol          - line numbering on
                        ov          - verbose
                        oa is off   - don't drag margins
                        ob is on    - will attempt
                        oh is off   - tabs have normal effect














































                                   - 18 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


                                 References

      [1] ... ....... is still looking this up

      [2]  Software  Tools,  Kernighan,  Brian  W.,  Plaugher,  P.  J.,
      Addison-Wesley, Reading, Massachusetts, 1976

      [3] "A Tutorial Introduction to the Unix editor", Kernighan, Bri-
      an W., Bell laboratories internal memorandum
















































                                   - 19 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


                                 Appendix A

                      Alphabetical Summary of Commands

           <CR>    (.+1)<newline>          go to next line
           ^Z      Control-z               write new version and exit
           <ESC>   <escape>                go to preceding line
           !       !<mcr command>          execute system command
           "       (.)"                    concatenate next line
           %       (.)%                    print previous screenful
           &       (.)&                    print next screenful
           =       (.)=                    print line number
           a       (.)a                    Append
           a       (.,.)a<text>            line Append
           b       (.)b[x[y]]              window screen mode
           c       (.,.)c                  Change
           d       (.,.)d                  Delete
           e       e filename              Edit
           f       f filename              Filename
           g       g/regular expression/commandlist
                                           Global
           i       (.)i                    Insert
           i       (.,.)i<text>            line Insert
           j       (.,$)j filename         Join
           k       (.,.)ka                 Kopy
           l       l                       screen mode
           m       (.,.)ma                 Move
           o       o[vtsinfabh?]           Options
           p       (.,.)p                  Print
           q       q                       Quit
           r       ($)r filename           Read
           s       (.,.)s#/regular expression/replacement/[g][p]
                                           Substitute
           t       (.)t                    Tag
           u       u                       Undo
           v       v/regular expression/commandlist
                                           inVerse
           w       (1,$)w filename         Write
           x       (1,$)x filename         neXt version
           y       (1)y                    macro (M is in use)
           z       (.)z[+-][n]             show surrounding
















                                   - 20 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


                                 Appendix B

                                 Some Hints



      m+       switches dot with line following

      -m       switches dot with previous line

      k        copies dot to after itself

      g        this command has a quirk  which  turns  out  to  be
               useful.  Create  a  file  full  of  filenames, then
               remove any headings so that the only  text  is  the
               actual list. Then issue the commands:

                       g/./k.k.
                       g//+s/.*/"&"/+s/.*/(&)/

               This would result in:

               file1
               "file1"
               (file1)
               file2
               "file2"
               (file2)
               ...

               This, of course,is only an example; the actual text
               may  require  different results. The quirk works in
               screen mode but it won't  be  visible  because  the
               lines   overprint.   To  remedy  this  execute  the
               "standard  tricky  sequence"  after   each   global
               change.


      t        tags the current line
               go do something else that doesn't retag
       <CR>    goes  to  line  you just marked and prints it. Note
               the blank space before the carriage return.  screen
               mode, the whole page will get refresehed.














                                   - 21 -




      Computer Graphics Laboratory                      16-September-80
      UED editor                                                    UED


                                 Appendix C

                          Teleray Display Mode Keys



              letter  blinks  dims    inverts underlines
              ------  ------  ----    ------- ----------

                A     yes     no      no      no
                B     no      yes     no      no
                C     yes     yes     no      no
                D     no      no      yes     no
                E     yes     no      yes     no
                F     no      yes     yes     no
                G     yes     yes     yes     no
                H     no      no      no      yes
                I     yes     no      no      yes
                J     no      yes     no      yes
                K     yes     yes     no      yes
                L     no      no      yes     yes
                M     yes     no      yes     yes
                N     no      yes     yes     yes
                O     yes     yes     yes     yes

































                                   - 22 -


