#-h- ruler.r         1165 asc 24-oct-80 11:48:35
## Ruler - Draw a `ruler' <n> columns wide on STDOUT.

 subroutine main
define(NUMSTRSIZE,12)

character nstr(NUMSTRSIZE)
integer   i, n
integer   alldig, ctoi, getarg # function(s)
string    digstr "0123456789"

if( getarg( 1, nstr, NUMSTRSIZE) == EOF )
  n = 80 # Default width
else if( alldig( nstr) == NO ) # Output error message
  call error("? Usage:  ruler [n]       (1 <= n <= MAXLINE ; Default = 80)")
else
{
  i = 1
  n = ctoi( nstr, i)
  n = min( n, MAXLINE) # Limit  1 <= width <= MAXLINE
  n = max( n, 1)
}

for( i = 1 ; i <= n ; i = i + 1 ) # Output top row of ruling.
  if( mod( i, 10) == 0 )
    call putc( PLUS)
  else
    call putc( MINUS)

call putc( NEWLINE)

for( i = 1 ; i <= n ; i = i + 1 ) # Output `tens' digits.
  if( mod( i, 10) == 0 )
    call putc( digstr( mod( mod( i, 100)/10, 10) + 1 ))
  else
    call putc( BLANK)

call putc( NEWLINE)

for( i = 1 ; i <= n ; i = i + 1 ) # Output `ones' digits.
  call putc( digstr( mod( i, 10) + 1 ))

call putc( NEWLINE)

for( i = 1 ; i <= n ; i = i + 1 ) # Output bottom row of ruling.
  if( mod( i, 10) == 0 )
    call putc( PLUS)
  else
    call putc( MINUS)

call putc( NEWLINE)


 return
end
