#-h- mansym            73 asc 12-oct-80 17:30:43
 define(ENTRYSIZE,20)
 define(MAXENTRIES,100)
 define(MAXTABLESIZE,2000)
#-h- cman             275 asc 12-oct-80 17:30:44
 common / cman / lstent, lstloc, entptr(MAXENTRIES),
		 entry(MAXTABLESIZE)

 integer lstent		# last entry pointer used; init = 0
 integer lstloc		# last location used in entry; init = 0
 integer entptr		# pointers into entry
 character entry	# entry names stored end to end
#-h- man.r           2612 asc 12-oct-80 17:30:45
#-h- mans.q          1022 asc 12-oct-80 17:30:34
 include mansym

 subroutine main

 integer i, getarg, j, int, open, k, opendr, desc, gdrprm
 character docdir(FILENAMESIZE), arg(FILENAMESIZE)

 include cman

# call initr4
 lstent = 0
 lstloc = 0
 call getdir(MANDIRECTORY, LOCAL, docdir)
 for (i=1; getarg(i, arg, FILENAMESIZE) != EOF; i=i+1)
    if (arg(1) == QMARK & arg(2) == EOS)
	call error("usage:  man [toolname] ...")
    else
	call stakit(arg)
 if (lstent == 0)
    {
    if (opendr(docdir, desc) == ERR)
	call error("Cannot open directory of documentation files.")
    while (gdrprm(desc, arg) != EOF)
	call stakit(arg)
    call closdr(desc)
    call shell(entptr, lstent, entry)	# sort the entries
    }
 for (i=1; i <= lstent; i=i+1)
    {
    j = 1
    call stcopy(docdir, 1, arg, j)
    k = entptr(i)
    call scopy(entry(k), 1, arg, j)
    int = open(arg, READ)
    if (int == ERR)
	{
	call putlin(entry(k), ERROUT)
	call remark(" : no manual entry available.")
	}
    else
	{
	call fcopy(int, STDOUT)
	call close(int)
	}
    }

# call endr4
 return
 end
#-h- stakit.q         403 asc 08-may-80 09:29:40
 subroutine stakit(buf)

 character buf(ARB)
 integer nlen, length

 include cman

 nlen = length(buf) + 1
 if (lstloc + nlen > MAXTABLESIZE | lstent >= MAXENTRIES)
    {
    call putlin(buf, ERROUT)
    call remark(" : too many entries.")
    }
 else
    {
    lstent = lstent + 1
    entptr(lstent) = lstloc + 1
    call scopy(buf, 1, entry, lstloc + 1)
    lstloc = lstloc + nlen
    }

 return
 end
#-h- shell.q          474 asc 08-may-80 09:29:41
 subroutine shell(linptr, nlines, linbuf)

 character linbuf(ARB)
 integer compar
 integer gap, i, ig, j, k, linptr(ARB), nlines

 for (gap = nlines / 2; gap > 0; gap = gap / 2)
    for (j = gap + 1; j <= nlines; j = j + 1)
        for (i = j - gap; i > 0; i = i - gap)
            {
            ig = i + gap
            if (compar(linptr(i), linptr(ig), linbuf) <= 0)
                break
            call exchan(linptr(i), linptr(ig), linbuf)
            }

 return
 end
#-h- exchan.q         126 asc 08-may-80 09:29:42
 subroutine exchan(lp1, lp2, linbuf)

 character linbuf(ARB)
 integer k, lp1, lp2

 k = lp1
 lp1 = lp2
 lp2 = k

 return
 end
#-h- compar.q         342 asc 08-may-80 09:29:42
 integer function compar(lp1, lp2, linbuf)

 character linbuf(ARB)
 integer i, j, lp1, lp2

 i = lp1
 j = lp2
 while (linbuf(i) == linbuf(j))
    {
    if (linbuf(i) == EOS)
        {
        compar = 0
        return
        }
    i = i + 1
    j = j + 1
    }
 if (linbuf(i) < linbuf(j))
    compar = -1
 else
    compar = +1

 return
 end
