#-h- ccomm            314 asc 07-may-80 12:11:48
 ## ccomm - common block to hold flags for comm
 # Put on a file called 'ccomm'
 # Used only the comm tool
 
 common /ccomm/  one, two, three
 integer one		#flag to print col1 (lines only in file 1)
 integer two		#flag to print col2 (lines only in file 2)
 integer three		#flag to print col3 (lines in both files)
#-h- comm.r          3753 asc 07-may-80 12:11:49
#-h- main             283 asc 07-may-80 12:11:22
 #---------------------------------------------------------------------
 # include symbol definitions
 #        include symbols
 #---------------------------------------------------------------------
 ## main - calling routine for comm
 
# call initr4
# call comm
# call endr4
# end
#-h- comms            844 asc 07-may-80 12:11:23
 ## comm - print lines common to two files
# subroutine comm
 subroutine main
 
 character buf(MAXLINE)
 integer getarg, open, index
 integer i, file(2), j
 include ccomm    
 
 one = YES
 two = YES
 three = YES
 j = 0
 for (i=1; getarg(i,buf,MAXLINE)!=EOF; i=i+1)
	{
	if (buf(1) == QMARK & buf(2) == EOS)
		call error ('usage:  [-123] file1 file2.')
	if (j == 2)
		break
	if (buf(1) == MINUS & buf(2) != EOS)
		{
		if (index(buf, DIG1) == 0)
			one = NO
		if (index(buf, DIG2) == 0)
			two = NO
		if (index(buf, DIG3) == 0)
			three = NO
		}
	else if (buf(1) == MINUS)
		{
		j = j + 1
		file(j) = STDIN
		}
	else
		{
		j = j + 1
		file(j) = open(buf,READ)
		if (file(j) == ERR)
			call cant(buf)
		}
	}
 
 if (j == 0)
	call error ('usage:  comm [-123] file1 file2.')
 
 if (j == 1)
	file(2) = STDIN
 call common(file(1), file(2))
 return
 end
#-h- common           959 asc 07-may-80 12:11:25
 ## common - print lines common to file1 and file2
 subroutine common(file1, file2)
 integer file1, file2, k, stat1, stat2
 integer getlin
 character buf1(MAXLINE), buf2(MAXLINE)
 integer cmpar
 
 stat1 = getlin(buf1,file1)
 stat2 = getlin(buf2,file2)
 repeat
	{
	if (stat1 == EOF | stat2 == EOF)
		break
	k = cmpar(buf1, buf2)		#compare lines
	if (k < 0)			#line only in file1
		{
		call col1(buf1)
		stat1 = getlin(buf1, file1)
		}
	else if (k > 0)			#line only in file2
		{
		call col2(buf2)
		stat2 = getlin(buf2, file2)
		}
	else				#line in both files
		{
		call col3(buf1)
		stat1 = getlin(buf1, file1)
		stat2 = getlin(buf2, file2)
		}
	}
 
 if (stat1 == EOF & two == YES)		#end of file1, print rest of file2
	while(stat2 != EOF)
		{
		call col2(buf2)
		stat2 = getlin(buf2, file2)
		}
 else if (stat2 == EOF & one == YES)	#end of file2, print rest of file1
	while (stat1 != EOF)
		{
		call col1(buf1)
		stat1 = getlin(buf1, file1)
		}
 
 return
 end
#-h- cmpar            272 asc 07-may-80 12:11:27
 ## cmpar - compare lin1 with lin2
 integer function cmpar(lin1, lin2)
 character lin1(ARB), lin2(ARB)
 integer i
 
 for (i=1; lin1(i) == lin2(i); i=i+1)
	if (lin1(i) == EOS)
		{
		cmpar = 0
		return
		}
 if (lin1(i) < lin2(i))
	cmpar = -1
 else
	cmpar = + 1
 return
 end
#-h- col1             282 asc 07-may-80 12:11:28
 ## col1 - print col1 (lines only in file1) for comm tool
 #  (remove leading blanks)
 subroutine col1 (buf)
 character buf(ARB)
 include ccomm    
 
 if (one == NO)		#return if column not to be printed
	return
 i = 1
 call skipbl (buf, i)
 call putlin(buf(i), STDOUT)
 return
 end
#-h- col2             355 asc 07-may-80 12:11:30
 ## col2 - print col2 (lines only in file2) for comm tool
 # (remove leading blanks)
 
 subroutine col2 (buf)
 character buf(ARB)
 integer i
 include ccomm    
 
 if (two == NO)		#return if column not to be printed
	return
 if (one == YES)
	for (i=1; i<=15; i=i+1)
		call putc(BLANK)
 i = 1
 call skipbl (buf, i)
 call putlin(buf(i), STDOUT)
 return
 end
#-h- col3             415 asc 07-may-80 12:11:31
 ## col3 - print col3 (lines in both files) for comm tool
 #  (remove leading blanks)
 subroutine col3(buf)
 character buf(ARB)
 integer i
 include ccomm    
 
 if (three == NO)		#return if column not to be printed
	return
 if (one == YES)
	for (i=1; i<=10; i=i+1)
		call putc(BLANK)
 if (two == YES)
	for (i=1; i<=15; i=i+1)
		call putc(BLANK)
 i = 1
 call skipbl(buf, i)
 call putlin(buf(i), STDOUT)
 return
 end
