	.TITLE	TAPEIO
	.IDENT	"BOBDNY"
	.ENABL LC
;
; This patch file implements a clean method of reading the 512. byte
; ANSI boot block on a BRU tape. At Gould, we were unable to read 
; bru tapes. It's a really long story, but if you're curious, look
; at the interrupt processing code in MTDRV and note the double
; interrupt timing window. If an interrupt occurs while the previous
; fork is in the window, it is junked!!! A little ways into the fork,
; interrupt processing is re-enabled. What was happening was that
; the read of the 512. byte block was being done by BRU with an 80.
; byte request. When our AVIV brand controller hit 80 bytes, it
; IMMEDIATELY aborted the operation, initiating an interrupt and
; indicating a "data overrun" error. The next I/O request got snagged
; and started before the tape stopped moving, creating the race.
; So I am intercepting the code and doing an "honest" 512. byte
; read for the boot block. If you are super curious, dissasemble
; the virgin "TAPEIO" module, and look at the code starting at
; relocatable location 2314. Youll find some real spaghetti code
; for reading the first batch of blocks on the tape, those that are
; in the "header file" before the first tape mark.
;
; By
;	Bob Denny
;	Software Engineering
;	17-Jul-80
;
	START = .

	.=START+2442
	JMP	PATCH

	.=START+2470
RESUME:

	.PSECT	PATCH	
PATCH:
	MOV	#512.,Q.IOPL+2(R0)	;SET FOR 512. BYTE BLOCK
	JSR	PC,START+3300		;READ IT
	MOV	#EFN9,-(SP)		;WAIT
	MOV	#1051,-(SP)
	EMT	377
	MOV	#80.,Q.IOPL+2(R0)	;RESET BLOCK SIZE TO 80.
	TSTB	$TPSTA			;OK?
	BPL	10$			;BR IF OK.
	MOVB	$TPSTA,$IOCOD		;OOPS, ERROR. GET CODE FOR MESSAGE
	TRAP	-EC.BOT			;DRAT

10$:	JSR	PC,START+3300		;READ THE 80. BYT'ER
	MOV	#EFN9,-(SP)		;WAIT
	MOV	#1051,-(SP)
	EMT	377
	JMP	RESUME			;AND PICK BACK UP.

	.END
