#-h- kwicsym          182 asc 03-jul-80 13:17:56
 ## definitions for kwic and unrot tools
 # put on a filed called 'kwicsym'
 
 define(FOLD,DOLLAR)	#character to indicate beginning of folded line
 define(MAXOUT,80)	#width of index
#-h- unrot.r         2510 asc 03-jul-80 13:17:58
#-h- main             292 asc 03-jul-80 13:17:40
 #---------------------------------------------------------------------
 # include symbol definitions
 #        include symbols
	  include kwicsym
 #---------------------------------------------------------------------
 ## main driver for kwic
 
#	call initr4
#	call unrot
#	call endr4
#	end
#-h- unrots           654 asc 03-jul-80 13:17:41
 ## unrot - unrotate lines rotated by kwic
# subroutine unrot
 subroutine main
 
 character buf(MAXLINE)
 integer getarg, open, ctoi
 integer i, int, width, j, n
 
 data width /MAXOUT/
  
 for (i=1; getarg(i,buf,MAXLINE)!=EOF; i=i+1)
	{
	if (buf(1) == QMARK & buf(2) == EOS)
		call error ('usage: unrot [-n] [file].')
	if (buf(1) == MINUS & buf(2) != EOS)
		{
		j = 2
		n = ctoi(buf,j)
		if (n > 0)
			width = n
		next
		}
	else if (buf(1) == MINUS)
		int = STDIN
	else
		{
		int = open(buf, READ)
		if (int == ERR)
			call cant(buf)
		}
	call nrot (int, width)
	if (int != STDIN)
		call close(int)
	}
 
 if (i==1)
	call nrot (STDIN, width)
 return
 end
#-h- nrot            1074 asc 03-jul-80 13:17:44
 ## nrot - unrotate lines from file -int-
 subroutine nrot(int, width)
 character inbuf(MAXLINE), outbuf(MAXLINE)
 integer getlin, index
 integer int, i, j, width, middle
 
 middle = max(width/2, 1)
 while (getlin(inbuf, int) != EOF)
	{
	for (i=1; i<width; i=i+1)		#blank line
		outbuf(i) = BLANK
	j = middle
	for (i=1; inbuf(i)!=FOLD & inbuf(i)!=NEWLINE; i=i+1)
		{
		j = j + 1			#copy up to FOLD
		if (i>1 & inbuf(i-1) == BLANK)
			if (nextj(+1,inbuf,i,j) >= width - 1)
				j = 1
			if (j >= width - 1)
				j = 1
		outbuf(j) = inbuf(i)
		}
	if (inbuf(i) == FOLD)			#copy second half
		{
		j = middle			#working backwards
		for (i=index(inbuf,NEWLINE)-1; i>0; i=i-1)
			{
			if (inbuf(i) == FOLD)
				break
			j = j -1
			if (inbuf(i+1) == BLANK)
				if (nextj(-1,inbuf,i,j) <= 0)
					j = width - 2
			if (j <= 0)
				j = width - 2
			outbuf(j) = inbuf(i)
			}
		}
	for (i=width-2; i > 0; i=i-1)
		if (outbuf(i) != BLANK)		#delete trailing blanks
			break
	outbuf(i+1) = NEWLINE			#terminate line properly
	outbuf(i+2) = EOS
	call putlin(outbuf, STDOUT)
	}
 
 return
 end
#-h- nextj            294 asc 03-jul-80 13:17:46
	## nextj - see if enough space for another word
	integer function nextj(incmnt,buf,i,j)
	character buf(ARB)
	integer incmnt, i, j, k
 
	nextj = j
	for (k=i; k>0; k = k + incmnt)
		{
		if (buf(k) == BLANK | buf(k) == FOLD | buf(k) == NEWLINE)
			break
		nextj = nextj + incmnt
		}
	return
	end
