#-h- oversym          176 asc 08-may-80 09:37:49
 ## definitions for overstrike tool
 # put on a file named 'oversym'
 # Used only by overstrike
 
 define(NOSKIP,PLUS)		#suppress carriage-return/line feed
 define(SKIP,BLANK)
#-h- os.r            1617 asc 08-may-80 09:37:50
#-h- main             307 asc 08-may-80 09:37:40
 #---------------------------------------------------------------------
 # include symbol definitions
 #        include symbols
	  include oversym
 #---------------------------------------------------------------------
 ## main calling program for overstrike tool
# call initr4
# call os
# call endr4
# end
#-h- oss              528 asc 08-may-80 09:37:41
 ## os - convert backspaces into multiple lines
# subroutine os
 subroutine main
 
 character buf(MAXLINE)
 integer getarg, open
 integer i
 
 for (i=1; ; i=i+1)
	{
	if (getarg(i,buf,MAXLINE) == EOF)
		{
		if (i != 1)
			break
		int = STDIN
		}
	else if (buf(1) == QMARK & buf(2) == EOS)
		call error('usage:  os [file ...].')
	else if (buf(1) == MINUS & buf(2) == EOS)
		int = STDIN
	else
		{
		int = open(buf,READ)
		if (int == ERR)
			call cant(buf)
		}
	call overs (int)
	if (int != STDIN)
		call close(int)
	}
 return
 end
#-h- overs            635 asc 08-may-80 09:37:42
 ## overs - convert backspaces into multiple lines from file -int-
 subroutine overs(int)
 character getch
 character c
 integer col, newcol, int
 
 col = 1
 repeat
	{
	newcol = col
	while (getch(c,int) == BACKSPACE)	#eat up backspaces
		newcol = max(newcol-1, 1)
	if (newcol < col)			#start overstrike line
		{
		call putc(NEWLINE)
		call putc(NOSKIP)
		for (col=1; col<newcol; col=col+1)
			call putc(BLANK)
		}
	else if (col == 1 & c != EOF)		#start normal line
		call putc(SKIP)
						#else middle of line
	if (c == EOF)
		break
	call putc(c)				#normal character
	if (c == NEWLINE)
		col = 1
	else
		col = col + 1
	}
 return
 end
