#-h- countr.mac      1853 asc 04-jun-80 14:58:10
	.title	countr
;
;	this program keeps a two character counter, which cycles from
;	AA to ZZ lexicographically.  When a process invoked from MCR
;	first goes to spawn a subtask, is sends a message to COUNTR,
;	which returns this two character sequence.  The process then
;	uses these two characters in naming all child processes.
;
;	This scenario is used to eliminate any conflicts in scratch
;	file names and task names.
;
	.mcall	gtsk$,rcst$,rcvd$,sdat$s,srda$s,dir$,ustp$s,astx$s
;
;	local data
;
rcvtsk:	.blkw	2		; Will contain this task's name
rcvbuf:				; label for 30 byte receive buffer
sndtsk:	.blkw	2		; will contain the task which requested XX
sndbuf:	.blkw	13.		; buffer to send
gtskdb:	gtsk$	rcvtsk		; DPB for get task info
rcstdb:	rcst$	,rcvbuf		; DPB for receive data or stop
rcvddb:	rcvd$	,rcvbuf		; DPB for receive data
lowch:	.ascii	/A/		; low character of pair
highch:	.ascii	/A/		; high character of pair
biga:	.ascii	/A/		; value of ascii A for comparison
bigz:	.ascii	/Z/		; value of ascii Z for comparison
;
;	code for countr
;
start:
	dir$	#gtskdb		; get this task's name
	srda$s	#unsast		; establish receive data AST address
5$:
	dir$	#rcstdb		; receive data or stop
	cmp	#1,$dsw		; see if received data
	beq	10$		; if DSW == 1, received data
	dir$	#rcvddb		; get data that triggered AST
10$:
	mov	lowch,sndbuf	; copy two characters into buffer
	sdat$s	#sndtsk,#sndbuf	; send buffer to task
	incb	lowch
	cmpb	lowch,bigz	; see if need to carry
	ble	5$		; if <=, NO
	movb	biga,lowch	; reset lowch to A
	incb	highch		; increment high character
	cmpb	highch,bigz	; see if need to cycle
	ble	5$		; if <=, NO
	movb	biga,highch	; reset highch to A
	br	5$
;
;
;	this is the receive data AST routine
;
;	it has the effect of unstopping the current task
;
unsast:
	ustp$s	#rcvtsk		; unstop ourselves
	astx$s			; exit from AST
	.end	start
#-h- countr.bld       109 asc 04-jun-80 14:58:12
pip countr.obj;*/de,countr.lst;*/de,countr.tsk;*/de,countr.map;*/de
mac countr,countr=countr
tkb @countr.tkb
#-h- countr.tkb        46 asc 04-jun-80 14:58:13
countr,countr=countr
/
units=0
task=countr
//
