/
/ PDP-11 C.
/ Stdio.
/
/ Read file system header.
/

	.globl	gethdr

/
/ gethdr(b, fn, fs);
/ struct hdr *b;
/ int fn, fs;
/

IOSB	=	-4		/I/O Status Block
RATCB	=	-12		/Read attributes block

gethdr:	jsr	r0,_save	/Get a stack frame
	sub	$12,sp		/Room for read attributes block

/
/ Get a lun.
/ Caveat: must use same algorithm as `fopen'.
/

	mov	_nluns,r0	/# of luns
	mov	$_luns,r1	/Ptr to lun table

0:	dec	r0		/Any more to choose from?
	bmi	1f		/No (return -1)
	tst	(r1)+		/How about this lun?
	bne	0b		/In use
	sub	$_luns,r1	/Get lun number for QIO
	asr	r1		/

/
/ Build IO.RAT parameter block.
/ Function code is -10. (Read entire header).
/

	clr	RATCB+4(r5)	/End mark
	mov	12(r5),RATCB+2(r5) /Buffer address
	mov	$[-12&377]+[92.<<8.],RATCB(r5) /Code

/
/ Do an access for read QIO.
/ Use read attribute parameters to cause
/ the header to be saved in the buffer.
/

	clr	-(sp)		/FNB
	mov	$100000,-(sp)	/Access
	clr	-(sp)		/Extend
	clr	-(sp)		/
	mov	r5,-(sp)	/Ratcb
	add	$RATCB,(sp)	/
	mov	r5,-(sp)	/File number and file sequence
	add	$14,(sp)	/
	clr	-(sp)		/AST
	mov	r5,-(sp)	/IOSB
	add	$IOSB,(sp)	/
	mov	$1,-(sp)	/Event flag
	mov	r1,-(sp)	/Lun
	mov	$IO.ACR,-(sp)	/Access for reading.
	mov	$1+[12.<<8.],-(sp) /QIO
	emt	377		/Do it
	bcc	0f		/Ok
	mov	_dsw,r0		/Grab error code
	br	1f		/

0:	mov	$1,-(sp)	/Wait for the QIO to finish
	mov	$41.+[2.<<8.],-(sp) /
	emt	377		/
	bcc	0f		/Ok
	mov	_dsw,r0		/Grab error code
	br	1f		/

0:	mov	IOSB(r5),r0	/Pick up the status word
	bmi	1f		/Br on error

/
/ Access was ok.
/ Assume the header has been read in.
/ Close down the lun.
/ No error checks.
/ There isn't much we could do.
/

	clr	-(sp)		/IOPL
	clr	-(sp)		/
	clr	-(sp)		/
	clr	-(sp)		/
	clr	-(sp)		/
	clr	-(sp)		/
	clr	-(sp)		/AST
	clr	-(sp)		/IOSB
	mov	$1,-(sp)	/EFN
	mov	r1,-(sp)	/LUN
	mov	$IO.DAC,-(sp)	/IO function
	mov	$1+[12.<<8.],-(sp) /QIO
	emt	377		/Do it
	bcc	0f		/
	mov	_dsw,r0		/Urk
	br	1f

0:	mov	$1,-(sp)	/WTSE $1
	mov	$41.+[2.<<8.],-(sp) /
	emt	377		/
	clr	r0

1:	jmp	_ret		/
