/ Profiler.
/ Using new names.

	.globl	__psav

lim:	.limit

w:	.asciz	"w"
fn:	.asciz	"profile"
fmt:	.asciz	"%8s %6d"

	.even

/
/ This is the special profiler version of the
/ standard save.
/ It is called by
/	jsr	r0,__psav
/	.word	0		/Counter
/	.word	p		/Pointer to name
/
/ In addition to doing the profile counts, this routine
/ stuffs a pointer to the profile print code in the
/ global cell `__pptr'. The exit routine does an indirect
/ call through this cell.
/ The cell should (clearly) be moved into the vector
/ extension area when the library gets redone.
/
 
__psav:	mov	r5,(sp)
	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	mov	sp,r5
	inc	(r0)		/Bump profile count
	mov	$prof,__pptr	/Stuff profile pointer
	jsr	pc,4(r0)	/tst -(sp); jmp 4(r0)

/
/ Write the profile out to file
/ "profile".
/ Open the file.
/

prof:	jsr	r0,__csav	/ Get new frame.

	mov	$w,(sp)
	mov	$fn,-(sp)
	jsr	pc,fopen
	tst	(sp)+

	mov	r0,r4
	beq	2f

/
/ Loop through all of core looking
/ for jsr r0,__psav.
/ Put out the format count for
/ each.
/

	mov	lim,r3
	clr	r2

1:	cmp	r3,lim+2
	bhis	1f

	cmp	(r3)+,$4067	/Jsr r0
	bne	1b
	mov	(r3)+,r0	/Pointing to __psav
	add	r3,r0
	cmp	r0,$__psav
	bne	1b

	tst	r2
	beq	3f

	mov	$' ,r0
	cmp	r2,$4
	blo	0f
	mov	$12,r0
	clr	r2

0:	mov	r4,(sp)
	mov	r0,-(sp)
	jsr	pc,putc
	tst	(sp)+

3:	mov	(r3)+,(sp)
	mov	(r3)+,-(sp)
	mov	$fmt,-(sp)
	mov	r4,-(sp)
	jsr	pc,fprintf
	add	$6,sp
	inc	r2
	br	1b

/
/ Close file.
/ Return.
/

1:	tst	r2
	beq	0f
	mov	r4,(sp)
	mov	$12,-(sp)
	jsr	pc,putc
	tst	(sp)+

0:	mov	r4,(sp)
	jsr	pc,fclose

2:	jmp	__cret
