/
/ Floating multiply.
/

	.globl	__fmul

/
/ __fmul
/ Called via jsr pc,__fmul
/ Result is identical to a FMUL SP
/ instruction.
/

__fmul:	jsr	r0,__fsav

	mov	F_A(sp),r0
	asl	r0
	rol	F_SIGN(sp)
	clr	F_AE(sp)
	swab	r0
	movb	r0,F_AE(sp)
	beq	4f
	sec
	ror	r0
	clrb	r0
	bisb	F_A+3(sp),r0
	mov	r0,F_AF(sp)
	clr	r0
	bisb	F_A+2(sp),r0
	swab	r0
	mov	r0,F_AF+2(sp)

	mov	F_B(sp),r0
	asl	r0
	adc	F_SIGN(sp)
	clr	F_BE(sp)
	swab	r0
	movb	r0,F_BE(sp)
	beq	4f
	sec
	ror	r0
	clrb	r0
	bisb	F_B+3(sp),r0
	mov	r0,F_BF(sp)
	clr	r0
	bisb	F_B+2(sp),r0
	swab	r0
	mov	r0,F_BF+2(sp)

/
/ Multiply.
/ Bottom 8 bits are zero.
/

	clr	r0
	clr	r1
	mov	F_AF(sp),r2
	mov	F_AF+2(sp),r3
	mov	$24.,r4

1:	bit	$400,r3
	beq	0f
	add	F_BF(sp),r0
	add	F_BF+2(sp),r1
	adc	r0

0:	clc
	ror	r0
	ror	r1
	ror	r2
	ror	r3

	dec	r4
	bne	1b

/
/ Product in r0-r3 is in the range
/ 0.25 <= p < 1.0
/ Compute exponant and normalise.
/

	mov	F_AE(sp),r4
	add	F_BE(sp),r4

	rol	r1
	rol	r0
	bcs	0f

	rol	r1
	rol	r0
	dec	r4

0:	sub	$200,r4
	ble	3f
	cmp	r4,$377
	bgt	2f

/
/ Reassemble the number from
/ the fraction (less the hidden
/ bit) in r0-r1 and the exponant
/ in r4.
/

	clrb	r1
	bisb	r0,r1
	swab	r1

	clrb	r0
	bisb	r4,r0
	swab	r0

	ror	F_SIGN(sp)
	ror	r0
	ror	r1
	br	5f

/
/ Special cases.
/ 2: is exp. overflow.
/ 3: is exp. underflow.
/ 4: is quick duck out for 0.0
/

2:	jsr	pc,__fofl
	br	5f

3:	jsr	pc,__fufl
	br	5f

4:	clr	r0
	clr	r1

/
/ Store back the result.
/ Return.
/

5:	mov	r0,F_A(sp)
	mov	r1,F_A+2(sp)

	jmp	__frta
