C	BOXES.FOR
C	DEMONSTRATION PROGRAM FOR FORTRAN/GT
C	USES: DPTR,APNT,VECT,SUBP,TEXT,ESUB,TRAK,LPEN,ERAS
C
C  THIS PROGRAM ATTEMPTS TO KEEP THE TRACKING OBJECT WITHIN A SERIES
C  OF CONCENTRIC BOXES UNTIL A LIGHT-PEN HIT IS
C  FELT ON THE SUBPICTURE:   *END*
C
C  LAY OUT DATA AREAS
C
	DIMENSION X(4),Y(4),H(4),V(4),IBUF(400),IP(4)
	EQUIVALENCE (XX,XA),(YY,YA)
C
C  INITIALIZE BOX DIMENSIONS AND POSITIONS
C
	DATA X/450.,400.,300.,200./
	DATA Y/450.,420.,275.,250./
	DATA H/100.,200.,400.,550./
	DATA V/100.,160.,350.,450./
C
C  COORDINATES FOR TRACKING
C
	DATA XX/500./,YY/500./
C
C  INITIALIZE
C
	CALL INIT(IBUF,400)
C
C  DRAW BOXES AND STORE POINTERS
C
	DO 1 I=1,4
	CALL DPTR(J)
	IP(I)=J+1
C
C  POSITION BOX
C
	CALL APNT(X(I),Y(I),0,-5)
C
C  DRAW BOX
C
	CALL VECT(H(I),0.)
	CALL VECT(0.,V(I))
	CALL VECT(-H(I),0.)
1	CALL VECT(0.,-V(I))
C
C  PUT UP END MESSAGE
C
	CALL SUBP(1)
	CALL APNT(850.,200.,1,-5)
	CALL TEXT('*END*')
C
C	TURN OFF LIGHT PEN SENSITIVITY
C
	CALL RDOT(0.,0.,-1,-5)
	CALL ESUB
C
C  PUT UP TRAK
C
	CALL TRAK(XX,YY)
C
C  MAIN LOOP
C
2	CALL LPEN(IH,IT)
C
C  SEE IF HIT ON *END*
C
	IF (IH.EQ.1 .AND. IT.EQ.1) GOTO 99
C
C  READJUST BOXES
C  ONLY IF XX.LT.820
C
	IF(XX.GE.820) GO TO 2
	DO 3 I=1,4
	IF(YY.GT.Y(I)+V(I)) Y(I)=YY-V(I)
	IF(YY.LT.Y(I)) Y(I)=YY
	IF(XX.GT.X(I)+H(I)) X(I)=XX-H(I)
	IF(XX.LT.X(I)) X(I)=XX
C
C  ADJUST IN DISPLAY FILE
C
	IBUF(IP(I)) = X(I)
3	IBUF(IP(I)+1) = Y(I)
C
C  KILL A LITTLE TIME- DON'T ASSUME REAL-TIME CLOCK
C
	DO 4 I=1,1000
4	J=I*2
	GO TO 2
C
C  THE END
C TURN OFF TRACKING OBJECT
C
99	CALL ERAS
	STOP
	END
