#include <stdio.h>

#define  HUGE	10000

int	level;
int	rflag;
FILE	*ifp;

main(argc, argv)
char *argv[];
{
	register char *p;
	register c, i;

	for (i=1; i<argc; ++i) {
		p = argv[i];
		if (*p == '-') {
			argv[i] = NULL;
			++p;
			while ((c = *p++) != '\0')
				switch (c) {

				case 'L':
				case 'l':
					if (++i >= argc)
						usage();
					level = atoi(argv[i]);
					argv[i] = NULL;
					break;

				case 'R':
				case 'r':
					++rflag;
					break;

				default:
					usage();
				}
		}
	}
	for (i=1; i<argc; ++i) {
		if ((p = argv[i]) == NULL)
			continue;
		if ((ifp = fopen(p, "r")) == NULL) {
			fprintf(stderr, "%s: cannot open.\n", p);
			continue;
		}
		extract();
		fclose(ifp);
	}
}

extract()
{
	register c, n;

	c = getc(ifp);
	while (c != EOF) {
		if (c != '/') {
			c = getc(ifp);
			continue;
		}
		c = getc(ifp);
		if (c != '*')
			continue;
		c = getc(ifp);
		n = HUGE;
		if (c >= '0' && c <= '9') {
			n = 0;
			while (c >= '0' && c <= '9') {
				n = 10*n + c - '0';
				c = getc(ifp);
			}
			ungetc(c, ifp);
		}
		comment(n <= level);
		c = getc(ifp);
	}
}

comment(f)
{
	register c, depth;

	if (f)
		printf("/*");
	depth = 1;
	while (depth) {
		if ((c = getc(ifp)) == EOF)
			break;
		if (f)
			putchar(c);
		if (c == '/' && nextis('*')) {
			++depth;
			if (f)
				putchar('*');
			continue;
		}
		if (c == '*' && nextis('/')) {
			--depth;
			if (f) {
				putchar('/');
				if (nextis('\n'))
					putchar('\n');
			}
			continue;
		}
	}

}

nextis(n)
{
	register c;

	if ((c = getc(ifp)) == n)
		return (1);
	ungetc(c, ifp);
	return (0);
}

usage()
{
	fprintf(stderr, "Usage: strip [-l #] [-r] [file ...]\n");
	exit(1);
}
