/*
 * Fragment.
 * Split the string `cp' into its first `n'
 * fields (delimited by whitespace).
 * Stash the pointers in `fp'.
 * Return the number of fields.
 */
#include <stdio.h>

fragment(n, cp, fp)
register char *cp;
register char **fp;
{
	register c;
	int fields;

	fields = 0;
	while (n-- > 0)
		if ((c = *cp) != '\0') {
			while (c==' ' || c=='\t' || c=='\n')
				c = *++cp;
			if (c != '\0') {
				*fp++ = cp;
				++fields;
				while (c!='\0' && c!=' ' && c!='\t' && c!='\n')
					c = *++cp;
				if (c != '\0')
					*cp++ = '\0';
			} else
				*fp++ = NULL;
		} else
			*fp++ = NULL;
	return(fields);
}
