/
/ Long divide/Remainder.
/

	.globl	div_l
	.globl	div_li
	.globl	mod_l
	.globl	mod_li

/
/ long div_li(a, b);
/ long a; int b;
/ Long divide op.
/

div_li:	jsr	r0,__csav	/Linkage
	clr	-(sp)		/Create sign flag
	clr	r4		/Clear high order part
	mov	r5,r0		/Make accessor
	add	$20,r0
	mov	-(r0),r5	/Get divisor
	bpl	1f		/Skip compliment if positive
	neg	r5		/Make pos.
	br	0f		/Go flip flag !

/
/ long div_l(a, b);
/ long a; long b;
/ Long divide op.
/

div_l:	jsr	r0,__csav	/Linkage
	clr	-(sp)		/Create sign flag
	mov	r5,r0		/Make accessor
	add	$22,r0
	mov	-(r0),r5	/Get divisor (l)
	mov	-(r0),r4	/  	     (h)
	bpl	1f		/Br if pos.
	neg	r4		/Negate
	neg	r5
	sbc	r4
0:	com	(sp)		/Flip sign flag

1:	mov	-(r0),r1	/Get dividend (l)
	mov	-(r0),r0	/	      (h)
	bpl	0f		/Br if pos.
	neg	r0		/Make pos.
	neg	r1
	sbc	r0
	com	(sp)		/Flip sign flag

0:	call	uldiv		/Divide

	tst	(sp)+		/Need to negate ?
	beq	2f		/No
	neg	r0		/Do it
	neg	r1
	sbc	r0
	br	2f

/
/ long mod_li(a, b);
/ long a; int b;
/ Long remainder op.
/

mod_li:	jsr	r0,__csav	/Linkage
	clr	-(sp)		/Create sign flag
	clr	r4		/Clear high order divisor
	mov	r5,r0		/Make accessor
	add	$20,r0
	mov	-(r0),r5	/Get divisor
	bpl	1f		/Make pos.
	neg	r5		/Make pos.
	br	0f		/Go flip flag.

/
/ long mod_l(a, b);
/ long a; long b;
/ Long remainder op.
/

mod_l:	jsr	r0,__csav	/Linkage
	clr	-(sp)		/Create sign flag
	mov	r5,r0		/Make accessor
	add	$22,r0
	mov	-(r0),r5	/Get divisor (l)
	mov	-(r0),r4	/	     (h)
	bpl	1f		/Br if pos.
	neg	r4		/Make divisor neg.
	neg	r5
	sbc	r4
0:	com	(sp)		/Flip sign flag

1:	mov	-(r0),r1	/Get dividend (l)
	mov	-(r0),r0	/             (h)
	bpl	0f
	neg	r0		/Make pos.
	neg	r1
	sbc	r0
	com	(sp)		/Flip sign flag

0:	call	uldiv		/Divide

	tst	(sp)+		/Negate if required
	beq	0f		/Not needed !
	neg	r2
	neg	r3
	sbc	r2

0:	mov	r3,r1		/Return the remainder
	mov	r2,r0

2:	tst	(sp)+		/Do it yourself `__cret' that
	mov	(sp)+,r2	/works with a bad `r5'
	mov	(sp)+,r3
	mov	(sp)+,r4
	mov	(sp)+,r5
	return

/
/ Do the divide.
/ Unsigned.
/ Entry:
/	r0	dividend hord
/	r1	dividend lord
/	r2	-
/	r3	-
/	r4	divisor hord
/	r5	divisor lord
/ Exit:
/	r0	quotient hord
/	r1	quotient lord
/	r2	remainder hord
/	r3	remainder lord
/	r4	divisor hord
/	r5	divisor lord
/

uldiv:	mov	$32.,-(sp)	/32 shifts
	clr	r2		/Clear quotient
	clr	r3

1:	asl	r1		/Quad shift left the quotient...
	rol	r0
	rol	r3		/...and the dividend
	rol	r2

	cmp	r2,r4		/Is shifted dividend >= divisor?
	blo	3f		/ no, hord smaller ->
	bhi	2f		/ yes, hord greater...
	cmp	r3,r5		/	hords equal; test lords
	blo	3f

2:	sub	r5,r3		/If yes, subtract divisor from dividend
	sbc	r2
	sub	r4,r2

	inc	r1		/ then add a bit to the quotient.

3:	dec	(sp)		/Decrement the loop count
	bne	1b		/Loop if more divisor remains ^

	tst	(sp)+		/Pop loop counter
	return
