/*
 * esa.h
 * Header.
 *
 * Sizes of tables.
 * All may be freely changed, with the exception
 * of ERRMAX (If you really need to change him, look
 * at `outlisting').
 */
#define NCPS	8		/* Characters per symbol */
#define CODEMAX	100		/* Max bytes code per line */
#define USERMAX	300		/* User names */
#define SRCMAX	120		/* Source line length */
#define ERRMAX	10		/* Maximum errors per line */
#define CRSIZE	32		/* Bytes per object record */

#define dot	(&ust[0])	/* Location counter */

/*
 * 8008 magic.
 */
#define	LBI	016		/* Opcodes */
#define LCI	026
#define LDI	036
#define LEI	046
#define LHI	056
#define LLI	066

/*
 * Listing control modes.
 * Go in `listmode'.
 */
#define NLIST	0		/* No list */
#define SLIST	1		/* Source only list */
#define ALIST	2		/* Just address */
#define CLIST	3		/* Address and code */

/*
 * Symbol table structure.
 * Used in both the user symbol table and
 * the opcode table.
 */
struct sym {
	char s_name[NCPS];	/* Name */
	char s_type;		/* Type */
	char s_flag;		/* Some flags */
	int  s_value;		/* Value */
};

/*
 * Types.
 */
#define S_UND	0		/* Undefined */
#define S_ABS	1		/* Absolute */
#define S_IN	2		/* in */
#define S_OUT	3		/* out */
#define S_PAGE	4		/* .page */
#define S_BYTE	5		/* .byte */
#define S_WORD	6		/* .word */
#define S_ASCII	7		/* .ascii */
#define S_ASCIZ	8		/* .asciz */
#define S_BLKB	9		/* .blkb */
#define S_OP1	10		/* Opcode */
#define S_OP2	11		/* Opcode byte */
#define S_OP3	12		/* Opcode addr */
#define S_OP4	13		/* lbci */
#define S_OP5	14		/* ldei */
#define S_OP6	15		/* lhli */

/*
 * Flags.
 */
#define SF_MDF	01		/* Multiply defined */
#define SF_ASG	02		/* Defined by assignment */

/*
 * Variables.
 */
extern struct sym pst[];	/* Perm. symbol table */
extern struct sym ust[];	/* User  symbol table */
extern int listmode;		/* Listing control */
extern int listaddr;		/* Listing control */
extern FILE *src;		/* Source file */
extern FILE *lst;		/* Listing file */
extern FILE *esb;		/* Binary file */
extern int lflag;		/* `-l' flag */
extern int nflag;		/* `-n' flag */
extern int pass;		/* Which pass flag */
extern char *sptr;		/* Source pointer */
extern char sbuf[];		/* Source buffer */
extern char *cptr;		/* Code pocharer */
extern int  cadr;		/* Code base address */
extern int  crec;		/* Code buffer loc */
extern char cbuf[];		/* Code buffer */
extern char crbf[];		/* Code buffer */
extern char *eptr;		/* Error pointer */
extern char ebuf[];		/* Error buffer */
extern struct sym *pptr;	/* End of pst */
extern struct sym *uptr;	/* End of ust */
extern int lineno;		/* Line number */

/*
 * Functions.
 */
extern struct sym *lookup();	/* Lookup a name */
