100 REM STERL2 -- PROGRAM ON FLY POPULATION CONTROL BY INTRODUCTION   
105 REM OF STERILE MALE FLIES AND USE OF PESTICIDE
110 REM COPYRIGHT 1972 - STATE UNIVERSITY OF NEW YORK
115 REM S(T)=NUMBER OF STERILE MALES ON DAY T 
120 REM INFORMATION ON THE LIFE CYCLE OF THE FLY IS CONTAINED IN THE  
125 REM E,P,Q,V, AND W ARRAYS, WHICH ARE TREATED AS CIRCULAR QUEUES.  
130 REM E=EGGS, G=POINTER FOR E 
135 REM P=NORMAL MALES, Q=STERILE MALES, L=POINTER FOR P AND Q
140 REM V=POPULATION OF NORMAL MALES FOUR DAYS AGO  
145 REM W=POPULATION OF STERILE MALES FOUR DAYS AGO 
150 REM P1=POINTER FOR V AND W  
155 REM PROGRAM DEVELOPED BY L. BRAUN AND A. FRISHMAN 
160 REM PROGRAMMED BY C. LOSIK, JANUARY 1971  
165 REM MODIFIED BY L. KAUFMAN, JUNE 1972
170 REM LATEST REVISION: 8-28-72
175 PRINT " ","CONTROL OF SCREW-WORM FLY POPULATION"
180 PRINT 
185 PRINT "INSTRUCTIONS (1=YES, 0=NO)"; 
190 INPUT F 
195 IF F=0 THEN 330
200 IF F<>1THEN185
205 PRINT 
210 PRINT "YOUR GOAL WILL BE TO ELIMINATE THE ONE MILLION MALE" 
215 PRINT "FLIES NOW IN YOUR 10000 SQUARE MILE AREA, THUS DESTROYING" 
220 PRINT "THE TOTAL FLY POPULATION.  YOU MAY USE A PESTICIDE," 
225 PRINT "RELEASE STERILE MALE FLIES, OR BOTH.  INDICATE THE TYPE" 
230 PRINT "OF CONTROL PROGRAM YOU WANT BY TYPING IN THE APPROPRIATE"
235 PRINT "RESPONSES TO THE FOLLOWING QUESTIONS:"
240 PRINT 
245 PRINT "'PESTICIDE?'"
250 PRINT "  0= NO PESTICIDES." 
255 PRINT "  1= PESTICIDES ON SPECIFIED DAYS.  INDICATE"
260 PRINT "     THESE DAYS BY TYPING A DAY NUMBER (BETWEEN 1 AND 75)" 
265 PRINT "     NEXT TO EACH '?' THAT APPEARS; TYPE 0 WHEN FINISHED." 
270 PRINT 
275 PRINT "'STERILE FLIES?'"
280 PRINT "  0= NO STERILE FLIES."
285 PRINT "  1= STERILE FLIES WILL BE RELEASED.  COMPUTER WILL"
290 PRINT "     ASK 'HOW OFTEN?'  TYPE 1=DAILY OR 2=CERTAIN DAYS" 
295 PRINT "  IF 1, SPECIFY NUMBER OF FLIES EACH DAY (UP TO 1000000)," 
300 PRINT "        THE FIRST DAY OF THE PERIOD, AND THE LAST DAY" 
305 PRINT "        (BETWEEN 1 AND 75 DAYS)."  
310 PRINT "  IF 2, FOR EACH DAY SELECTED, SPECIFY THE DAY NUMBER" 
315 PRINT "       (BETWEEN 1 AND 75) AND THE NUMBER OF STERILE FLIES"
320 PRINT "        (UP TO 1000000).  USE A NEW LINE FOR EACH DAY."  
325 PRINT "        TYPE 0,0 WHEN FINISHED." 
330 PRINT
335 PRINT "**********"
340 REM SET UP INITIAL CONDITIONS 
345 DIM S(76),P(17),Q(17),E(13),V(4),W(4)
350 REM T1:DAYS FROM EGG TO ADULT
355 LET T1=13 
360 REM T2:LIFE SPAN AS ADULT 
365 LET T2=17 
370 REM X9:MAXIMUM NUMBER OF MALE FLIES THAT THE AREA CAN SUPPORT 
375 LET X9=1000000
380 REM K:SEXUAL EFFECTIVENESS COEFFICIENT OF STERILE MALES
385 LET K=.25 
390 REM B0:NORMAL BIRTH RATE OF MALES 
395 LET B0=250/2
400 REM C:SURVIVAL RATE OF EGG,MAGGOT,PUPA  
405 LET C=.01
410 REM C9:COST OF CONTROL PROGRAM IN THOUSANDS OF DOLLARS
415 LET C9=0
420 REM S:TOTAL NUMBER OF NORMAL FLIES
425 LET S=0
430 REM START POPULATION AT MAXIMUM VALUE 
435 LET X=X9
440 LET S(1)=0
445 REM INITIAL CONDITIONS FOR ADULT MALES AND EGGS 
450 FOR L=1 TO T2 
455 LET P(L)=X/T2
460 LET Q(L)=0
465 NEXT L
470 FOR G=1TOT1
475 LET E(G)=B0*X/T2
480 NEXT G
485 FOR P1=1 TO 4 
490 LET V(P1)=X/T2
495 LET W(P1)=0 
500 NEXT P1 
505 LET L=17
510 LET G=13
515 LET P1=4
520 FOR T=2 TO 76
525 LET S(T)=1
530 NEXT T
535 PRINT 
540 REM DETERMINE OPTIONS IN MODEL  
545 PRINT "PESTICIDE (1=YES, 0=N0)";
550 INPUT T 
555 IF T=0 THEN 605
560 IF T<>1THEN545
565 PRINT "WHICH DAYS"
570 INPUT T 
575 IF T=0 THEN 605
580 IF ABS(T-38)>37 THEN 565
585 IF T<>INT(T)THEN565
590 LET S(T+1)=-1
595 LET C9=C9+100
600 GOTO 570
605 PRINT 
610 PRINT "STERILE FLIES (1=YES, 0=NO)";
615 INPUT T 
620 IF T=0 THEN 775
625 IF T<>1THEN605
630 PRINT "HOW OFTEN (1=DAILY, 2=SELECTED DAYS)"; 
635 INPUT T 
640 IF T=1 THEN 700
645 IF T<>2THEN630
650 PRINT "DAY, NUMBER OF FLIES"
655 INPUT T,J 
660 IF T=0 THEN 775
665 IF ABS(J-X9/2)>X9/2 THEN 650
670 IF J<>INT(J)THEN650
675 IF ABS(T-38)>37THEN650
680 IF T<>INT(T)THEN650
685 LET S(T+1)=S(T+1)*J
690 LET C9=C9+1E-5*J
695 GOTO 655
700 PRINT "HOW MANY PER DAY"; 
705 INPUT J 
710 IF ABS(J-X9/2)>X9/2 THEN 700
715 IF J<>INT(J)THEN700
720 PRINT "FROM WHEN, TO WHEN"; 
725 INPUT T,T9
730 IF ABS(T9-38)>37THEN720
735 IF T9<>INT(T9)THEN720
740 IF ABS(T-38)>37THEN720
745 IF T<>INT(T)THEN720
750 IF T>T9 THEN 720
755 FOR F=T+1 TO T9+1 
760 LET S(F)=S(F)*J
765 NEXT F
770 LET C9=C9+J*(T9-T+1)*1E-5
775 PRINT
780 PRINT " ","MILLIONS OF NORMAL ADULT MALE FLIES"
785 PRINT "     0        .2        .4        .6        .8         1"
790 PRINT "DAY  I---------I---------I---------I---------I---------I"
795 PRINT 0;TAB(4);"I";TAB(55);"* ";INT(X+.5)
800 REM START SIMULATION  
805 FOR T=1 TO 75
810 REM OLD AGE DEATHS IN POPULATION  
815 LET D=P(L)
820 LET D1=Q(L) 
825 REM BIRTHS IN POPULATION  
830 LET T9=T+1
835 LET C=-3.33E-08*X+.04333
840 LET P(L)=C*E(G) 
845 IF S(T9)=-1THEN855
850 IF S(T9)<>1 THEN865
855 LET Q(L)=0
860 GOTO870
865 LET Q(L)=ABS(S(T9))
870 IF S(T)=-1THEN885
875 REM EMIGRATION/IMMIGRATION EFFECTS  
880 IF S(T)<>1THEN890
885 LET S(T)=0
890 LET Z=X+P(L)+ABS(S(T))-(D+D1+X9)
895 IF Z<0 THEN 915
900 LET F=Z/(Z+X9)
905 GOSUB 1125
910 GOTO 945
915 LET D=D+.1*Z
920 LET Z=ABS(.1*Z/T2)
925 FOR J=1 TO T2 
930 LET P(J)=P(J)+Z 
935 NEXT J
940 REM PESTICIDE EFFECTS 
945 IF S(T9)>=0THEN960
950 LET F=.9
955 GOSUB 1125
960 LET X1=X+C*E(G)-D
965 IF S(T9)=-1THEN975
970 IF S(T9)<>1THEN980
975 LET S(T9)=0
980 LET S(T9)=ABS(S(T))+ABS(S(T9))-D1
985 LET S=S+INT(X1+.5)
990 PRINT T;TAB(4);"I";TAB(5+INT(50*X1/X9+.5));"* ";INT(X1+.5)
995 REM BACK UP SEVEN DAYS FOR EGG CALCULATION
1000 LET Z=L-7 
1005 IF Z>=1THEN1015
1010 LET Z=Z+T2
1015 LET F=V(P1)+K*W(P1) 
1020 IF F>.5 THEN 1035
1025 LET E(G)=P(Z)*B0
1030 GOTO 1040
1035 LET E(G)=P(Z)*B0*V(P1)/F
1040 LET Z=L-3 
1045 IF Z>=1THEN1055
1050 LET Z=Z+T2
1055 LET V(P1)=P(Z)
1060 LET W(P1)=Q(Z)
1065 LET L=L+1 
1070 IF L<=T2THEN1080
1075 LET L=1 
1080 LET G=G+1 
1085 IF G<=T1THEN1095
1090 LET G=1 
1095 LET P1=P1+1 
1100 IF P1<=4THEN1110
1105 LET P1=1
1110 LET X=X1
1115 NEXT T
1120 GOTO 1165
1125 LET Z=1-F 
1130 FOR J=1 TO T2
1135 LET D=D+F*P(J)
1140 LET D1=D1+F*Q(J)
1145 LET P(J)=Z*P(J) 
1150 LET Q(J)=Z*Q(J) 
1155 NEXT J
1160 RETURN  
1165 PRINT "     I---------I---------I---------I---------I---------I"
1170 PRINT 
1175 PRINT
1180 PRINT "COST OF FLY CONTROL: $";
1185 IF C9>=1000THEN1200
1190 PRINT C9;" THOUSAND";
1195 GOTO1205
1200 PRINT C9/1000;" MILLION";
1205 PRINT" DOLLARS"
1210 PRINT
1215 PRINT"ESTIMATED DAMAGE: $";
1220 IF S/15000>=1000THEN1235
1225 PRINT S/15000;" THOUSAND";
1230 GOTO1240
1235 PRINT S/(15*1E6);" MILLION";
1240 PRINT" DOLLARS"
1245 PRINT 
1250 PRINT "ANOTHER RUN (1=YES, 0=NO)";
1255 INPUT T 
1260 IF T=1 THEN 330
1265 IF T<>0THEN1250
1270 END
