/*
 * A program to simulate the Photon Econosetter.
 *    Copyright (c) 1978, Johann H. George
 *    Thanks to M0rk for the fonts.
 *    Thanks to Dmm for the inverse video and other stuff
 */

char cpr[] {
	"Copyright (c) 1978, Johann H. George"
};

#include <stdio.h>
#include <tty.h>
#include <ascii.h>

/*
 * Some manifests.
 */

#define	NFONT	4		/* number of fonts available */
#define CPF	112		/* number of characters per font */

/*
 * Commands to the Photon Econosetter.
 */
#define CFACE	1
#define CDIR	2
#define CPOINT	3
#define CMOVE	4
#define CLEAD	5

int hmode;				/* Current mode HP is in */
long int hx;				/* Current x co-ordinate */
long int hy;				/* Current y co-ordinate */

long int xp;				/* Current x position */
long int yp;				/* Current y position */
int dir;				/* Current direction */
int pt;					/* Current pointsize */
int ft;					/* Current font */
int wi;					/* Width of current character */
long int slead = 0;			/* Distance to start displaying */
int clrflg 1;				/* Whether to clear screen */

int pnttab[];
int xtab[];
int ytab[];
int widtab[NFONT][CPF];
char *codtab[NFONT][CPF];
char *modestr = "r1a";
char *pagestr = "b";
int wrap();

FILE *in;				/* Input file */
FILE *tty;				/* Terminal */
struct ttymode ttyv;

char outbuf[BUFSIZ];
main(argc, argv)
char *argv[];
{
	initialize();
	setup(argc, argv);
	process();
	wrap();
}

/*
 * Initialisation.
 */
initialise()
{
	hx = -1000;
	hy = -1000;
	hmode = 0;
	xp = 0;
	yp = 36*3;
	dir = 1;
	pt = 10;
	ft = 0;
	slead = 0;
}

/*
 * Open files and put the terminal into graphics mode.
 */
setup(argc, argv)
char *argv[];
{
	register u, i;

	if((tty=fopen("/dev/tty", "r")) == NULL)
		error("Cannot open tty\n");
	in = stdin;
	setbuf(stdout, outbuf);
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '+') {
			slead = 3*144L*atoi(&argv[i][1]);
			continue;
		} else if(argv[i][0] == '-')
			switch(argv[i][1]) {
			case 'c':
				clrflg = 0;
				continue;
			case 'w':	/* white on black */
				modestr = "r";
				pagestr = "a";
				continue;
			}
		if((in=fopen(argv[i], "r")) == NULL)
			error("Cannot open input\n");
	}

	signal(1, &wrap);
	signal(2, &wrap);
	signal(3, &wrap);
	gtty(fileno(stdout), &ttyv);
	i = ttyv.t_mode;
	ttyv.t_mode = (ttyv.t_mode&~ECHO) | HOLD;
	stty(fileno(stdout), &ttyv);
	ttyv.t_mode = i;
	printf("\033*m%sZ\033*df%sZ", modestr, pagestr);
	fflush(stdout);
	printf("\033*p");
}

/*
 * Preview his input.
 */
process()
{
	register char c;

	while((c=get7()) != EOF) {
		switch(c) {
		case CFACE:
			ft = get7();
			if(ft>=NFONT || ft<0)
				err("Illegal typeface\n");
			break;
		case CDIR:
			dir = gets7();
			if(dir<-1 || dir>1)
				err("Illegal direction\n");
			break;
		case CPOINT:
			c = get7();
			if(c<0 || c>3)
				err("Illegal pointsize\n");
			pt = pnttab[c];
			break;
		case CMOVE:
			move(gets7());
			break;
		case CLEAD:
			lead(gets7());
			break;
		default:
			c =- 020;
			if(c<0 || c>=CPF)
				err("Bad character: %o\n", c+020);
			if(dir > 0) {
				move(width(c));
				flash(c);
			} else if(dir == 0)
				flash(c);
			else {
				flash(c);
				move(-width(c));
			}
		}
	}
	endpage();
}

/*
 * Return terminal back to its normal state.
 */
wrap()
{
	signal(2, 1);
	signal(3, 1);
	printf("\033*ddE");
	stty(fileno(stdout), &ttyv);
	exit();
}

/*
 * Lead the given amount.
 * It is specified in half points.
 */
lead(n)
{
	yp =+ n*3;
	if(yp < slead) {
		return;
	} else {
		if(slead) yp = 0;
		slead = 0;
	}
	if(yp > 4*144*3)
		scroll();
}

/*
 * Move the given amount which is specified
 * in half units.
 */
move(n)
{
	xp =+ n*pt*6;
}

/*
 * Print the given character.
 */
flash(c)
char c;
{
	int dontdraw;
	char *p;

	if(slead)
		return;
	wi = width(c);
	dontdraw = 1;
	for(p=codtab[ft][c]; (c = *p)!='\0'; p++) {
		if(c == ',') {
			dontdraw = 1;
			continue;
		}
		if(c < 'a')
			c =- '0';
		else
			c = c-'a' + 10;
		line(xtab[c], ytab[c], dontdraw);
		dontdraw = 0;
	}
}

/*
 * Draw a line from the current position to a distance
 * which in an increment of the given co-ordinates.
 */
line(dx, dy, dontdraw)
{
	int realx, realy;

	realx = (xp + dx*wi*pt) * 5 / 864;
	realy = (yp + dy*pt)*5 / 24;
	if(dontdraw)
		putchar('a');
	cursor(realx, 359-realy);
}

/*
 * Cursor to the given position.
 */
cursor(x, y)
{
	int dx, dy, mode;

	dx = x - hx;
	dy = y - hy;

	if(dx>=-16 && dx<=15 && dy>=-16 && dy<=15)
		mode = 'j';
	else
		mode = 'i';

	if(mode != hmode)
		putchar(hmode=mode);

	if(hmode == 'j') {
		puth(dx);
		puth(dy);
	} else {
		puth(x>>5);
		puth(x);
		puth(y>>5);
		puth(y);
	}
	hx = x;
	hy = y;
}

/*
 * Put out a character for the Hewlett Packard 2648A.
 */
puth(c)
char c;
{
	putchar(c&037 | 040);
}

/*
 * Scroll the screen.
 */
scroll()
{

	yp =- 4*144*3 - 3*72;
	endpage();
	printf("\033*d%sZ\033*p", pagestr);
}

/*
 * Pause at the end of a page.
 */
endpage()
{
	char s[100];

	putchar('Z');
	putchar(BEL);
	fflush(stdout);
	fgets(s, sizeof s, tty);
	if(s[0] == '+')
		slead = 3*144L*atoi(&s[1]);
}

/*
 * Find the width of the given character.
 */
width(c)
{
	return(widtab[ft][c]);
}

/*
 * Get a character and extend its sign.
 * The character is 7 bits.
 */
gets7()
{
	char c;

	if((c=get7()) >= 64)
		c =- 128;
	return(c);
}

/*
 * Get a 7 bit character.
 */
get7()
{
	char c;

	while((c=getc(in)) == '\n');
	return(c==EOF ? EOF : c&0177);
}

/*
 * Print error message.
 */

err(args)
char *args;
{
	printf("\033*ddE");
	fflush(stdout);
	fprintf(stderr, "%r", &args);
	stty(fileno(stdout), &ttyv);
	exit();
}

/*
 * Table of pointsizes.
 */
pnttab[] {
	8, 10, 14, 18
};

/*
 * Tables for mapping the character from the code tables into
 * x and y positions.
 */
int xtab[] {
	-5, -4, -3, -2, -1,
	-5, -4, -3, -2, -1,
	-5, -4, -3, -2, -1,
	-5, -4, -3, -2, -1,
	-5, -4, -3, -2, -1,
	-5, -4, -3, -2, -1,
	-5, -4, -3, -2, -1
};

int ytab[] {
	-4, -4, -4, -4, -4,
	-3, -3, -3, -3, -3,
	-2, -2, -2, -2, -2,
	-1, -1, -1, -1, -1,
	 0,  0,  0,  0,  0,
	 1,  1,  1,  1,  1,
	 2,  2,  2,  2,  2
};

/*
 * The width tables for the Photon Econosetter.
 */
int widtab[NFONT][CPF] {
{
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 12, 12, 16, 12, 18,
	 10, 19, 14, 19, 14, 19, 19, 10, 19, 16, 12, 30, 18, 25, 19, 18,
	 19, 17, 20, 19, 10, 18, 16, 10, 10, 10, 10, 18, 12, 10, 18, 36,
	 28, 28, 28, 28, 22, 36, 18, 36, 30, 14, 12, 12, 30, 24, 24, 28,
	 15, 30, 22, 28, 28, 30, 28, 24, 30, 26, 23, 36, 28, 36, 23, 28,
	 24, 26, 28, 28, 17, 28, 25, 10, 10, 10, 10, 18, 12, 14, 18, 10,
	 20, 20, 22, 18, 30, 30, 30, 24, 14, 30, 18, 18, 30, 18, 18, 30,
},
{
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 12, 12, 16, 12, 18,
	 10, 19, 14, 19, 14, 19, 19, 10, 19, 16, 12, 30, 18, 25, 19, 18,
	 19, 17, 20, 19, 10, 18, 16, 10, 10, 10, 10, 18, 12, 10, 18, 36,
	 28, 28, 28, 28, 22, 36, 18, 36, 30, 14, 12, 12, 30, 24, 24, 28,
	 15, 30, 22, 28, 28, 30, 28, 24, 30, 26, 23, 36, 28, 36, 23, 28,
	 24, 26, 28, 28, 17, 28, 25, 10, 10, 10, 10, 18, 12, 14, 18, 10,
	 20, 20, 22, 18, 30, 30, 30, 24, 20, 28, 18, 18, 30, 18, 18, 30,
},
{
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 12, 12, 16, 12, 18,
	 10, 18, 14, 18, 14, 18, 18, 10, 18, 16, 12, 28, 18, 24, 18, 18,
	 18, 14, 20, 18, 10, 20, 16, 10, 10, 12, 10, 18, 12, 10, 18, 36,
	 28, 28, 28, 28, 22, 36, 18, 36, 30, 14, 12, 12, 30, 24, 24, 26,
	 14, 28, 22, 28, 26, 30, 28, 24, 28, 26, 22, 36, 26, 36, 24, 26,
	 24, 26, 26, 28, 18, 26, 26, 10, 10, 12, 10, 18, 12, 14, 18, 10,
	 20, 20, 22, 16, 30, 30, 30, 24, 20, 22, 18, 18, 30, 18, 18, 30,
},
{
	 36, 36, 14, 14, 30, 18, 30, 30, 30, 30, 30, 30, 30, 22, 14, 16,
	 18, 22, 20, 16, 16, 22, 20, 14, 16, 22, 16, 16, 18, 20, 12, 16,
	 22, 22, 20, 22, 18, 16, 18, 30, 30, 18, 18, 30, 12, 36, 18, 10,
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 30, 30, 18, 26, 26, 24,
	 24, 36, 30, 26, 26, 30, 18, 34, 26, 18, 14, 16, 30, 26, 30, 36,
	 26, 36, 36, 24, 30, 30, 30, 30, 30, 18, 30, 30, 12, 18, 22, 10,
	 18, 36, 36, 18, 30, 30, 14, 16, 16, 16, 30, 16, 30, 30, 30, 18
}
};

/*
 * This is the table used for generating the letters.
 * The letters correspond to the following positions.
 *
 *    01234
 *    56789
 *    abcde
 *    fghij
 *    klmno
 *    pqrst
 *    uvwxy
 */
char *codtab[NFONT][CPF] {
	/*
	 * Times Roman.
	 */
{
	"62m,ln",		/* 1 */
	"04eako",		/* 2 */
	"04ok,eb",		/* 3 */
	"ea4o", 		/* 4 */
	"4059ok",		/* 5 */
	"40koea",		/* 6 */
	"04k",			/* 7 */
	"a04okae",		/* 8 */
	"ea04ok",		/* 9 */
	"f5139jnlf",		/* 0 */
	"95aejf,2m",		/* $ */
	"09jk", 		/* ) */
	"ae",			/* - */
	"fjeako",		/* e */
	"2mo,59",		/* t */
	"aeokfj",		/* a */
	"22,cm",		/* i */
	"kaeo", 		/* n */
	"eafjok",		/* s */
	"kaeok",		/* o */
	"kae",			/* r */
	"0k,aeo",		/* h */
	"4okae",		/* d */
	"2m",			/* l */
	"akoe", 		/* u */
	"eako", 		/* c */
	"42m,ae",		/* f */
	"kaeo,cm",		/* m */
	"ako,eyu",		/* y */
	"akoe,cm",		/* w */
	"uaeok",		/* p */
	"okaeyu",		/* g */
	"0koea",		/* b */
	"ame",			/* v */
	"0ke,ho",		/* k */
	"okaey",		/* q */
	"44,eyup",		/* j */
	"ao,ke",		/* x */
	"aeko", 		/* z */
	"kot",			/* , */
	"ko",			/* . */
	"59,kot",		/* ; */
	"049",			/* ' */
	"1l,3n,59,fj",		/* # */
	"04ok", 		/* ] */
	"27",			/* ' */
	"4k",			/* / */
	"pt",			/* _ */
	"0a,9p,omjt",		/* 1/4 */
	"0a,4k,hjomrt", 	/* 1/2 */
	"02ca,75,9p,omjt",	/* 3/4 */
	"05610,4k,jopkj",	/* % */
	"pt",			/* _ */
	"04",			/* - */
	"ae",			/* - */
	"ae",			/* - */
	"o517fke",		/* & */
	"504ech,mm",		/* ? */
	"2h,mm",		/* ! */
	"45fo", 		/* ( */
	"2m,ae",		/* + */
	"40ko,ad",		/* E */
	"04,2m",		/* T */
	"k04o,ae",		/* A */
	"04,2m,ko",		/* I */
	"k0o4", 		/* N */
	"40aeok",		/* S */
	"40ko4",		/* O */
	"k04ea,co",		/* R */
	"0k,ae,4o",		/* H */
	"k09jk",		/* D */
	"0ko",			/* L */
	"0ko4", 		/* U */
	"40ko", 		/* C */
	"40k,ad",		/* F */
	"k0c4o",		/* M */
	"0ad4,cm",		/* Y */
	"0ko4,cm",		/* W */
	"k04ea",		/* P */
	"40koec",		/* G */
	"k09ajk",		/* B */
	"0m4",			/* V */
	"0k,4ao",		/* K */
	"ok04oc",		/* Q */
	"4okf", 		/* J */
	"0o,4k",		/* X */
	"04ko", 		/* Z */
	"405",			/* ' */
	"27",			/* ' */
	"77,hh",		/* : */
	"059",			/* ' */
	"2m,5j,9f",		/* * */
	"40ko", 		/* [ */
	"05,49",		/* " */
	"0o",			/* \ */
	"2m",			/* | */
	"31l,aeo",		/* fi */
	"l14o,ac",		/* fl */
	"l14,3n,ae",		/* ff */
	"04950",		/* deg */
	"77,ae,hh",		/* div */
	"5j,9f",		/* mult */
	"ae",			/* - */
	"3n,o40ae",		/* PP */
	"40fj,59ok",		/* sect */
	"f5139jnlf",		/* circle */
	"95fj,2m",		/* cent */
	"2r,59",		/* dagger */
	"ae,fj",		/* = */
	"04ok0,g68dbi", 	/* (R) */
	"04ok0,86gi",		/* (C) */
	"i86gj40ko",		/* @ */
},
	/*
	 * Times Italic.
	 */
{
	"63l,km",		/* 1 */
	"24dbkm",		/* 2 */
	"24mk,dc",		/* 3 */
	"db4m", 		/* 4 */
	"4268mk",		/* 5 */
	"42kmdb",		/* 6 */
	"24k",			/* 7 */
	"b24mkbd",		/* 8 */
	"db24mk",		/* 9 */
	"k24mk",		/* 0 */
	"97bdhf,4k",		/* $ */
	"29ik", 		/* ) */
	"ae",			/* - */
	"gieckm",		/* e */
	"3clm,69",		/* t */
	"cemkgi",		/* a */
	"33,cl",		/* i */
	"kcem", 		/* n */
	"ecgimk",		/* s */
	"cemkc", 		/* o */
	"kce",			/* r */
	"2k,ben",		/* h */
	"4mkbd",		/* d */
	"3l",			/* l */
	"ckme", 		/* u */
	"ecko", 		/* c */
	"43l,ae",		/* f */
	"kcem,dl",		/* m */
	"cln,ewu",		/* y */
	"ckme,ld",		/* w */
	"ucenl",		/* p */
	"nlcewu",		/* g */
	"2kmdb",		/* b */
	"ake",			/* v */
	"2ke,ho",		/* k */
	"nlcew",		/* q */
	"44,dvup",		/* j */
	"cm,ek",		/* x */
	"ceko", 		/* z */
	"kos",			/* , */
	"ko",			/* . */
	"ae,kmq",		/* ; */
	"049",			/* ' */
	"2k,4m,69,fi",		/* # */
	"24mk", 		/* ] */
	"36",			/* ' */
	"4k",			/* / */
	"pt",			/* _ */
	"2b,9p,omjs",		/* 1/4 */
	"2b,9p,ijnmqr", 	/* 1/2 */
	"23ba,67,9p,omjs",	/* 3/4 */
	"15621,4k,imnji",	/* % */
	"pt",			/* _ */
	"ae",			/* - */
	"ae",			/* - */
	"ae",			/* - */
	"o517fke",		/* & */
	"504ech,mm",		/* ? (Not italicized) */
	"3b,kk",		/* ! */
	"46fm", 		/* ( */
	"3l,ae",		/* + */
	"42km,bc",		/* E */
	"04,2k",		/* T */
	"kb3dm,bd",		/* A */
	"24,3l,km",		/* I */
	"k2m4", 		/* N */
	"42bdmk",		/* S */
	"24mk2",		/* O */
	"k24db,cm",		/* R */
	"2k,bd,4m",		/* H */
	"k29ik",		/* D */
	"4ko",			/* L */
	"2km4", 		/* U */
	"42km", 		/* C */
	"42k,bc",		/* F */
	"k2c4m",		/* M */
	"2bd4,cl",		/* Y */
	"2km4,cl",		/* W */
	"k24db",		/* P */
	"42kmd",		/* G */
	"k29bik",		/* B */
	"0h4",			/* V */
	"2k,4bm",		/* K */
	"mk24mc",		/* Q */
	"4nkf", 		/* J */
	"2m,4k",		/* X */
	"24km", 		/* Z */
	"415",			/* ' */
	"27",			/* ' */
	"88,gg",		/* : */
	"059",			/* ' */
	"3l,6i,9f",		/* * */
	"42km", 		/* [ */
	"15,48",		/* " */
	"0o",			/* \ */
	"3l",			/* | */
	"42k,adm",		/* fi */
	"k24m,ac",		/* fl */
	"k24m,ae",		/* ff */
	"23762",		/* deg */
	"88,ae,gg",		/* div */
	"6i,9f",		/* mult */
	"ae",			/* - */
	"3n,o40ae",		/* PP */
	"40fj,59ok",		/* sect */
	"04ok0",		/* box */
	"97fh,4k",		/* cent */
	"2r,59,ko",		/* daggers */
	"ae,2m,ko",		/* _+ */
	"04ok0,g68dbi", 	/* (R) */
	"04ok0,86gi",		/* (C) */
	"i86gj40ko",		/* @ */
},
	/*
	 * Times Bold.
	 */
{
	"62m,23n,ln",		/* 1 */
	"04eako,3d,bl", 	/* 2 */
	"04ok,eb,3n",		/* 3 */
	"ea3no43",		/* 4 */
	"4059ok,16,8n", 	/* 5 */
	"40koea,bl,dn", 	/* 6 */
	"04lk3",		/* 7 */
	"a04okae,1l,3n",	/* 8 */
	"ea04ok,1b,3n", 	/* 9 */
	"1lf5139jn3,ln",	/* 0 */
	"95aejf,2m,6b,di",	/* $ */
	"09jk,8i",		/* ) */
	"ae",			/* - */
	"fjeako,bl,di", 	/* e */
	"m21lo,59",		/* t */
	"aeokfj,gl,dn", 	/* a */
	"23,cdnmc",		/* i */
	"blkaeond",		/* n */
	"eafjok,bg,in", 	/* s */
	"kaeok,bl,dn",		/* o */
	"blkae",		/* r */
	"01lk0,aeo,nd", 	/* h */
	"n34okae,bl",		/* d */
	"23nm2",		/* l */
	"lbakoedn",		/* u */
	"eako,bl",		/* c */
	"41lm2,ae",		/* f */
	"blkaeond,cm",		/* m */
	"lbako,xdeyu",		/* y */
	"lbakoedn,cm",		/* w */
	"bvuaeok,dn",		/* p */
	"okaeyu,bl,dx", 	/* g */
	"0koea,bl,dn",		/* b */
	"aldeml",		/* v */
	"lk01l9,ho",		/* k */
	"okaeyxd,bl",		/* q */
	"34,xdeyupqv",		/* j */
	"ao,dkled",		/* x */
	"ael,dko",		/* z */
	"kotsn",		/* , */
	"ko",			/* . */
	"59,kotsn",		/* ; */
	"04983",		/* ' */
	"1l,3n,59,fj",		/* # */
	"04ok,3n",		/* ] */
	"16721",		/* ' */
	"3kl43",		/* / */
	"pt",			/* _ */
	"0ab10,8pq98,trjyxn",	/* 1/4 */
	"0ab10,8pq98,motrwy,nx",					 /* 1/2 */
	"02ca,75,1b,8pq98,trjyxn",					 /* 3/4 */
	"05610,3kl43,inoji",	/* % */
	"pt",			/* _ */
	"04",			/* - */
	"ae",			/* - */
	"ae",			/* - */
	"o517fke",		/* & */
	"16504echi3,mn",	/* ? */
	"1gh21,lm",		/* ! */
	"45fo,6g",		/* ( */
	"3m,ae",		/* + */
	"40ko,ad,1l",		/* E */
	"03,2ml1",		/* T */
	"6lka2eon8,ae", 	/* A */
	"03,2m,1l,kn",		/* I */
	"1lk01no43n",		/* N */
	"40aeok,1b,dn", 	/* S */
	"40ko4,1l,3n",		/* O */
	"1lk04ea,3d,co",	/* R */
	"0kl10,ae,3no43",	/* H */
	"1lk019jl",		/* D */
	"l10ko",		/* L */
	"l10ko43n",		/* U */
	"40ko,1l",		/* C */
	"40kl1,ad",		/* F */
	"1lk01c34on3",		/* M */
	"0b34cmlbc",		/* Y */
	"l10klcno43n",		/* W */
	"1lk04ea,3d",		/* P */
	"40koec,1l,dn", 	/* G */
	"1lk019bjl",		/* B */
	"0l34ml",		/* V */
	"0kl10,4bo",		/* K */
	"l10ko43n,cm,13", 	/* Q */
	"n34okfgl",		/* J */
	"0o,3kl43",		/* X */
	"04l,3ko",		/* Z */
	"40561",		/* ' */
	"16721",		/* ' */
	"67,gh",		/* : */
	"405",			/* ' */
	"2m,5j,9f",		/* * */
	"40ko,1l",		/* [ */
	"05610,38943",		/* " */
	"0o",		/* \ */
	"2m",			/* | */
	"31l,aeo",		/* fi */
	"l14o,ac",		/* fl */
	"l14,3n,ae",		/* ff */
	"04950",		/* deg */
	"66,ae,hh",		/* div */
	"5j,8fg98",		/* mult */
	"ae",			/* - */
	"3n,o40ae",		/* PP */
	"40fj,59ok,1g,8n",	/* sect */
	"59jf5",		/* box */
	"95fj,6g,2mn32",	/* cent */
	"1qr21,58",		/* dagger */
	"ae,fj",		/* = */
	"04ok0,g68dbi", 	/* (R) */
	"04ok0,86gi",		/* (C) */
	"i86gj40ko",		/* @ */
},
	/*
	 * Greek
	 */
{
	"ae,7eh",		/* -> */
	"ae,7ah",		/* <- */
	"a2e,2m",		/* |^ */
	"ame,2m",		/* |v */
	"abm4", 		/* root */
	"04",			/* bar */
	"0eko", 		/* _> */
	"4aok", 		/* _< */
	"59,ae,fj",		/* -= */
	"a6d9,fbie",		/* approx */
	"04,2m",		/* T */
	"a6ie", 		/* ~ */
	"a6ie,ko",		/* _~ */
	"51c,4k",		/* gamma */
	"eako,fj",		/* epsilon */
	"ake,ho",		/* kappa */
	"lb,aet",		/* eta */
	"akoe,hm",		/* omega */
	"0o,ck",		/* lambda */
	"f5139jnlf,ae",		/* theta */
	"40okac",		/* delta */
	"ae,bl,dn",		/* pi */
	"ap,ko,dn",		/* mu */
	"eakot",		/* sigma */
	"42ko,be",		/* xi */
	"69if6,3l",		/* phi */
	"able", 		/* nu */
	"uq",			/* , */
	"059kot",		/* zeta */
	"u04c,aenk",		/* beta */
	"ako",			/* iota */
	"benhb",		/* omicron */
	"akoe,2r",		/* psi */
	"56st,9p",		/* chi */
	"dnkae",		/* sigma */
	"obke", 		/* alpha */
	"ubenl",		/* rho */
	"abkne",		/* upsilon */
	"ae,cl",		/* tau */
	"5flmj9",		/* union */
	"96aflo",		/* subset */
	"40uy", 		/* [ */
	"04,kn",		/* bars */
	"96aflo,pt",		/* ______subset */
	"02mk,ce",		/* } */
	"pt",			/* _ */
	"4k",			/* / */
	"2m",			/* | */
	"4hw",			/* {1 */
	"2w",			/* | */
	"27frw",		/* {2 */
	"2hy",			/* {3 */
	"0hw",			/* }1 */
	"277jrw",		/* }2 */
	"2hu",			/* }3 */
	"42w",			/* [1 */
	"2wy",			/* [3 */
	"02w",			/* ]1 */
	"2m,ko",		/* _| */
	"ae,fj,8l",		/* /= */
	"2wu",			/* ]3 */
	"f5139jnlf,ae",		/* THETA */
	"5049,bd,fkoj", 	/* XI */
	"kl04no",		/* OMEGA */
	"51c,93cm",		/* UPSILON */
	"ae",			/* - */
	"04m0", 		/* DEL */
	"59jf5,13,2m,ln",	/* PHI */
	"k3o",			/* LAMBDA */
	"41alo,ae",		/* EPS. */
	"59e",			/* not */
	"942kmi,bd",		/* E */
	"40cko",		/* SIGMA */
	"95fj,2m",		/* cent */
	"42wu", 		/* integral */
	"47",			/* ' */
	"04,1l,3n",		/* PI */
	"k2ok", 		/* DELTA */
	"5fj9,13,2m,ln",	/* PSI */
	"f5139jnlf,k4",		/* phi */
	"fkglhminj",		/* squiggle */
	"04",			/* - */
	"f5139nlf",		/* O */
	"40k",			/* GAMMA */
	"41alo,ae,3n",		/* ~EPS. */
	"0ek",			/* > */
	"4ao",			/* < */
	"ka68eo",		/* intersection */
	"58ejnk",		/* contains */
	"04yu", 		/* ] */
	"04,ae,2m",		/* minus-plus */
	"58ejnk,pt",		/* ________contains */
	"42mo,ac",		/* { */
	"ko",			/* _ */
	"0o",			/* \ */
	"2w",			/* | */
	"41l,ko,ac",		/* pound */
	"kk,oo",		/* .. */
	"ko,pt",		/* = */
	"04950",		/* deg */
	"77,ae,hh",		/* div */
	"5j,f9",		/* mult */
	"05,49",		/* " */
	"36",			/* ' */
	"529",			/* ^ */
	"18",			/* ` */
	"eako,cm",		/* varies */
	"5184", 		/* ~ */
	"ae,2mko",		/* _+ */
	"cc,kk,oo",		/* therefore */
	"ceokacm",		/* infinity */
	"04okae"		/* part.d */
}
};
