/
/ Floating point simulation.
/ Common code.
/

	.globl	__fsav
	.globl	__frta
	.globl	__frtb

	.globl	F_A,	F_B,	F_PC,	F_AF,	F_BF
	.globl	F_AE,	F_BE,	F_SIGN,	F_SIZE

/
/ Stack items.
/

F_A	=	40		/Argument A
F_B	=	34		/Argument B

F_PC	=	32		/Return PC

F_BF	=	12		/Fraction B (2 words)
F_AF	=	6		/Fraction A (2 words)
F_BE	=	4		/Exponant B
F_AE	=	2		/Exponant A
F_SIGN	=	0		/Signs

F_SIZE	=	16		/Size of extension frame

/
/ __fsav.
/ Save registers.
/ Aquire stack space.
/ Called by jsr r0,__fsav
/

__fsav:	mov	r1,-(sp)
	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	r4,-(sp)
	mov	r5,-(sp)

	sub	$F_SIZE,sp

	jmp	(r0)

/
/ __frta
/ __frtb
/ Return to caller. 
/ Remove stuff from the stack.
/ Set codes.
/

__frtb:	mov	F_B(sp),F_A(sp)
	mov	F_B+2(sp),F_A+2(sp)

__frtb:	add	$F_SIZE,sp

/
/ Remove B from stack.
/

	mov	sp,r0
	add	$F_A-F_SIZE,r0
	mov	sp,r1
	add	$F_B-F_SIZE,r1

0:	mov	-(r1),-(r0)
	cmp	r1,sp
	bhi	0b
	mov	r0,sp

/
/ Restore registers.
/

	mov	(sp)+,r5
	mov	(sp)+,r4
	mov	(sp)+,r3
	mov	(sp)+,r2
	mov	(sp)+,r1
	mov	(sp)+,r0

/
/ Set codes.
/ FIS clears C and V.
/ 

	tst	2(sp)
	bmi	0f
	bit	$77600,2(sp)

0:	clc
	clv
	rts	pc
