/
/ Block Read and Block Write.
/

	.globl	__rvb
	.globl	__wvb

/
/ Write a disc block, growing the file as required.
/ The seek address is in V_RBLK.
/ If the device is not a file (VF_FIL==0) change the
/ IO.WVB into an IO.WLB.
/

__wvb:	bit	$VF_FIL,V_FLAG(r4)
	beq	1f

/
/ Grow the file (via IO.EXT) if seek address is
/ beyond the physical end of file.
/

	mov	V_RBLK(r4),r0
	mov	V_RBLK+2(r4),r1
	cmp	r0,V_HIBK(r4)
	bhi	0f
	blo	1f
	cmp	r1,V_HIBK+2(r4)
	blos	1f

0:	sub	V_HIBK(r4),r0
	sub	V_HIBK+2(r4),r1
	sbc	r0
	mov	V_RBLK(r4),V_HIBK(r4)
	mov	V_RBLK+2(r4),V_HIBK+2(r4)

	clr	-(sp)
	clr	-(sp)
	mov	r1,-(sp)
	bis	$100000,r0
	mov	r0,-(sp)
	clr	-(sp)
	clr	-(sp)
	mov	$IO.EXT,r0
	call	__qiow
	bcs	2f

/
/ Now do the write.
/

1:	clr	-(sp)
	mov	V_RBLK+2(r4),-(sp)
	mov	V_RBLK(r4),-(sp)
	clr	-(sp)
	mov	$512.,-(sp)
	mov	V_BBUF(r4),-(sp)
	mov	$IO.WVB,r0
	bit	$VF_FIL,V_FLAG(r4)
	bne	0f
	mov	$IO.WLB,r0
0:	call	__qiow
	bcc	0f

2:	bis	$VF_ERR,V_FLAG(r4)
0:	return

/
/ Read a disc block into the block buffer.
/ The seek address is in V_RBLK.
/

__rvb:	clr	-(sp)
	mov	V_RBLK+2(r4),-(sp)
	mov	V_RBLK(r4),-(sp)
	clr	-(sp)
	mov	$512.,-(sp)
	mov	V_BBUF(r4),-(sp)
	mov	$IO.RVB,r0
	bit	$VF_FIL,V_FLAG(r4)
	bne	0f
	mov	$IO.RLB,r0
0:	call	__qiow
	bcc	0f
	bis	$VF_ERR,V_FLAG(r4)
0:	return
