/*
 * as84.c
 * Code and listing.
 */
#include <stdio.h>
#include "as8.h"

/*
 * Output code byte.
 * Save it in the per line
 * buffer for outlisting.
 * Update dot.
 */
codeb(b)
{
	b &= 0377;
	if(cptr < &cbuf[CLMAX])
		*cptr++ = b;
	else
		err('z');
	if(pass && !nflag) {
		if(crec>=CBMAX || cadr+crec!=dot->s_value) {
			cflush(0);
			cadr = dot->s_value;
		}
		crbf[crec++] = b;
	}
	++dot->s_value;
}

/*
 * Output a word.
 * Low then high.
 */
codew(w)
{
	codeb(w);
	codeb(w>>8);
}

/*
 * Signal error.
 * Add it to the error buffer
 * if not already there.
 */
err(c)
{
	register char *p;

	p = ebuf;
	while(p < eptr)
		if(*p++ == c)
			return;
	if(p >= &ebuf[ERRMAX])
		abort();
	*p++ = c;
	eptr = p;
}

/*
 * Format a line for the
 * listing.
 * More work than you would
 * think.
 * Only called if -l.
 */
outlisting()
{
	register int nbytes;
	register char *cp;
	int w1, w2, w3;

	if(listmode == NLIST)
		return;
	for(cp = eptr; cp < &ebuf[ERRMAX]; *cp++ = ' ');
	if(listmode == SLIST)
		fprintf(lst, "%.10s      ", ebuf);
	else
		fprintf(lst, "%.10s %04x ", ebuf, listaddr);
	if(listmode == ALIST)
		fprintf(lst, "%9s%6d %s\n", "", lineno, sbuf);
	else {
		nbytes = cptr-cbuf;
		w1 = cbuf[0]&0377;
		w2 = cbuf[1]&0377;
		w3 = cbuf[2]&0377;
		switch(nbytes) {

		case 0:
			fprintf(lst, "%9s", "");
			break;

		case 1:
			fprintf(lst, "%02x%7s", w1, "");
			break;

		case 2:
			fprintf(lst, "%02x %02x%4s", w1, w2, "");
			break;

		default:
			fprintf(lst, "%02x %02x %02x ", w1, w2, w3);
		}
		fprintf(lst, "%6d %s\n", lineno, sbuf);
		cp = &cbuf[3];
		while((nbytes -= 3) > 0) {
			fprintf(lst, "%16s", "");
			switch(nbytes) {

			case 1:
				w1 = cp[0]&0377;
				fprintf(lst, "%02x\n", w1);
				break;

			case 2:
				w1 = cp[0]&0377;
				w2 = cp[1]&0377;
				fprintf(lst, "%02x %02x\n", w1, w2);
				break;

			default:
				w1 = cp[0]&0377;
				w2 = cp[1]&0377;
				w3 = cp[2]&0377;
				fprintf(lst, "%02x %02x %02x\n", w1, w2, w3);
			}
			cp += 3;
		}
	}
}

/*
 * Write errors to the tty.
 */
outerrors()
{
	register char *p;

	p = ebuf;
	while(p < eptr)
		printf("%c %04d\n", *p++, lineno);
}

/*
 * Flush the binary code
 * buffer.
 * HP format.
 * The lf flag, if true, says that
 * this is the last line.
 */
cflush(lf)
{
	register int i;

	if(crec == 0)
		return;
	fprintf(obj, "%06oa", cadr);
	for(i=0; i<crec-1; ++i)
		fprintf(obj, "%03od", crbf[i]&0377);
	fprintf(obj, "%03o", crbf[i]&0377);
	if(lf) {
		if(entaddr == 0)
			fprintf(obj, "D\n");
		else
			fprintf(obj, "d\n%06oaE\n", entaddr);
	} else
		fprintf(obj, "d\n");
	crec = 0;
}
