/
/ PDP-11 C.
/ Standard Library.
/
/ Issue QIOW.
/

	.globl	_qiow

/
/ This routine is used to issue QIOW directives from
/ all over the I/O package.
/ r0=I/O function code
/ r4=IOV pointer
/ The IOPL paramaters are on the stack (pushed right
/ to left).
/
/ Returns with c bit clear if all ok, or the c bit set
/ and the error code in r0 on error.
/
/ In RSX-11M V02, this routine actually does a QIO and a
/ WTSE. But the Gods are none the wiser.
/
/ Uses: r0, r1
/

_qiow:
	mov	(sp)+,r1
	clr	-(sp)
	mov	r4,-(sp)
	add	$V_IOSB,(sp)
	mov	$1,-(sp)
	mov	V_LUN(r4),-(sp)
	mov	r0,-(sp)
	mov	$3.+[12.<<8.],-(sp)
	emt	377
	bcc	0f
	mov	_dsw,r0
	br	1f

0:
	movb	V_IOSB(r4),r0
	cmp	r0,$IS.SUC
	bne	0f
	clc
	br	1f

0:
	sec

1:
	jmp	(r1)
