/
/ PDP-11 C.
/ Stdio.
/
/ Put characters.
/
 
	.globl	putcha
	.globl	putc
	.globl	_putc
 
/
/ putchar(c);
/ putc(c, ioptr);
/
/ These routines put out a single character to either
/ the standard output (putchar) or the specified
/ stream (putc).
/ The character is returned. If there is an error
/ EOF is returned instead.
/

putcha:	jsr	r0,_save	/Get a stack frame.
	mov	stdout,r4	/Get standard output IOV.
	br	0f		/
 
putc:	jsr	r0,_save	/Get a stack frame.
	mov	14(r5),r4	/Get user's IOV.
	call	_ckiov

0:	mov	12(r5),r0	/Get character.
	call	_putc		/Call off to common routine.
	bit	$VF_ERR,(r4)	/Any errors?
	bne	0f		/Br if yes
	mov	12(r5),r0	/Return the character
	br	1f		/

0:	mov	$-1,r0		/Return EOF.
1:	jmp	_ret		/
 
/
/ Put characters.
/ Called from above, from puts and from printf.
/ Works on NOS and normal files.
/ Gives an error if UBF file.
/
/ r5=stack frame pointer
/ r4=ioptr
/ r0=character to put out
/
 
_putc:	bit	$VF_UBF,(r4)	/"u"
	beq	0f		/No.
	bis	$VF_ERR,(r4)	/Set error flag.
	br	1f		/

0:	bit	$VF_NOS,(r4)	/"n"
	beq	0f		/No
	movb	r0,*V_R1(r4)	/Put character
	inc	V_r0(r4)	/In
	inc	V_R1(r4)	/The buffer
	cmp	V_R0(r4),V_RBSZ(r4) /And if the buffer fills
	blo	1f		/Then
	call	_flush		/Write it out
	br	1f		/

0:	cmp	r0,$12		/Not "n", is char a newline?
	bne	0f		/Br if not
	movb	r0,*V_R1(r4)	/Store newline
	inc	V_R0(r4)	/Fix count
	inc	V_R1(r4)	/Fix pointer
	call	_flush		/Write out the line
	br	1f		/

0:	cmp	V_R0(r4),V_RBSZ(r4) /Does it fit in buffer
	bhis	1f		/No, toss away
	movb	r0,*V_R1(r4)	/Store character
	inc	V_R0(r4)	/Fix count
	inc	V_R1(r4)	/Fix pointer

1:	return			/Cmon return
