/
/ PDP-11 C.
/ Stdio.
/
/ EIS simulation code.
/ All C callable.
/
 
	.globl	_mul, _div, _asl, _asr, _mod
 
/
/ _asl(x, y) does x<<y
/
 
_asl:
	mov	2(sp),r0
	mov	4(sp),r1
	beq	1f
 
0:
	asl	r0
	dec	r1
	bne	0b
 
1:
	rts	pc
 
/
/ _asr(x, y) does x>>y
/
 
_asr:
	mov	2(sp),r0
	mov	4(sp),r1
	beq	1f
 
0:
	asr	r0
	dec	r1
	bne	0b
 
1:
	rts	pc
 
/
/ _mul(x, y) does x*y
/
 
_mul:
	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	r4,-(sp)
 
	clr	r2
	mov	10(sp),r1
	bpl	0f
	neg	r1
	com	r2
 
0:
	mov	12(sp),r3
	bpl	0f
	neg	r3
	com	r2
 
0:
	clr	r0
	mov	$16.,r4
 
1:
	bit	$1,r1
	beq	0f
	add	r3,r0
 
0:
	clc
	ror	r0
	ror	r1
	dec	r4
	bne	1b
 
	tst	r2
	beq	0f
	neg	r1
 
0:
	mov	r1,r0
	mov	(sp)+,r4
	mov	(sp)+,r3
	mov	(sp)+,r2
	return
 
/
/ _div(x, y) does x/y
/
 
_div:
	call	divmod
	return
 
/
/ _mod(x, y) does x%y
/
 
_mod:
	call	divmod
	mov	r1,r0
	return
 
/
/ Common code for _div and _mod.
/ Divide 12(sp) by 14(sp).
/ Return quotient in r0.
/ Return remainder in r1.
/
 
divmod:
	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	r4,-(sp)
 
	clr	r2
	clr	r0
	mov	12(sp),r1
	bpl	0f
	neg	r1
	com	r2
 
0:
	mov	14(sp),r3
	bpl	0f
	neg	r3
	com	r2
 
0:
	mov	$16.,r4
 
1:
	asl	r1
	rol	r0
	cmp	r0,r3
	blo	0f
	sub	r3,r0
	inc	r1
 
0:
	dec	r4
	bne	1b
 
	tst	r2
	bne	0f
	tst	14(sp)
	bpl	1f
	inc	r1
	br	1f
 
0:
	tst	14(sp)
	bmi	0f
	inc	r1
 
0:
	neg	r1
 
1:
	mov	r0,r2
	mov	r1,r0
	mov	r2,r1
 
	mov	(sp)+,r4
	mov	(sp)+,r3
	mov	(sp)+,r2
	return
