/
/ PDP-11 C.
/ Stdio
/
/ Validate an IOV pointer
/

	.globl	_ckiov
	.globl	.nluns
	.globl	_luns

/
/ This routine validates an IOV pointer ('ioptr') in R4 by ensuring
/
/	a) It is word aligned
/	b) It is in the task's address space (unimplimented)
/	c) The LUN in it (V_LUN(R4))
/		-is ppositive
/		-is <= .nluns
/	d) The LUN table ('_luns' in start.s) entry for the LUN
/	   points to the IOV
/

_ckiov:
	bit	$1,r4		/even address ?
	bne	err		/no - error

	mov	V_LUN(r4),r0	/get LUN
	bmi	err		/negative - error
	cmp	r0,.nluns	/ > maximum LUN ?
	bgt	err		/yes - error

	asl	r0		/convert to word index
	cmp	r4,_luns-2(r0)	/LUN table agrees ?
	bne	err		/no - error

	return			/yes - return

err:
	iot			/*** TEMPORARY ***
