/*
 * esa5.c
 * Tables and things.
 */

#include <stdio.h>
#include "esa.h"

/*
 * Assorted variables.
 */
int  lop;			/* Lines on the page */
int  listmode;			/* Listing mode */
int  listaddr;			/* Listing address */
FILE *src;			/* Source ioptr */
FILE *lst;			/* Listing ioptr */
FILE *esb;			/* Binary ioptr */
int  lflag;			/* `-l' flag */
int  nflag;			/* `-n' flag */
int  pass;			/* Pass indicator */
int  lineno;			/* Line number */
int  pageno;			/* Page number */
char *sptr;			/* Source scanning pointer */
char *cptr;			/* Code pocharer */
int cadr -1;			/* Code base address */
int crec  0;			/* Code buffer pointer */
char *eptr;			/* Error pointer */

/*
 * Buffers.
 */
char sbuf[SRCMAX];		/* Source line buffer */
char ebuf[ERRMAX];		/* Error buffer */
char cbuf[CODEMAX];		/* Code buffer */
char crbf[CRSIZE];		/* Output code buffer */

/*
 * User symbol table.
 * The first item must be '.'.
 */
struct sym ust[USERMAX] {
	".",		S_ABS,		SF_ASG,	0,
	"port0",	S_ABS,		0,	020,
	"port1",	S_ABS,		0,	021,
	"port2",	S_ABS,		0,	022,
	"port3",	S_ABS,		0,	023,
	"port4",	S_ABS,		0,	024,
	"port5",	S_ABS,		0,	025,
	"port6",	S_ABS,		0,	026,
	"port7",	S_ABS,		0,	027,
	"port8",	S_ABS,		0,	030,
	"port9",	S_ABS,		0,	031,
	"porta",	S_ABS,		0,	032,
	"portb",	S_ABS,		0,	033,
	"portc",	S_ABS,		0,	034,
	"portd",	S_ABS,		0,	035,
	"porte",	S_ABS,		0,	036,
	"portf",	S_ABS,		0,	037
};

/*
 * Opcode table.
 * Also contains pseudo operations and
 * registers.
 */
struct sym pst[] {
	".page",	S_PAGE,		0,	0,
	".byte",	S_BYTE,		0,	0,
	".word",	S_WORD,		0,	0,
	".ascii",	S_ASCII,	0,	0,
	".asciz",	S_ASCIZ,	0,	0,
	".blkb",	S_BLKB,		0,	0,
	"aca",		S_OP1,		0,	0210,	
	"acb",		S_OP1,		0,	0211,	
	"acc",		S_OP1,		0,	0212,	
	"acd",		S_OP1,		0,	0213,	
	"ace",		S_OP1,		0,	0214,	
	"ach",		S_OP1,		0,	0215,	
	"acl",		S_OP1,		0,	0216,	
	"acm",		S_OP1,		0,	0217,	
	"ada",		S_OP1,		0,	0200,	
	"adb",		S_OP1,		0,	0201,	
	"adc",		S_OP1,		0,	0202,	
	"add",		S_OP1,		0,	0203,	
	"ade",		S_OP1,		0,	0204,	
	"adh",		S_OP1,		0,	0205,	
	"adl",		S_OP1,		0,	0206,	
	"adm",		S_OP1,		0,	0207,	
	"cpa",		S_OP1,		0,	0270,	
	"cpb",		S_OP1,		0,	0271,	
	"cpc",		S_OP1,		0,	0272,	
	"cpd",		S_OP1,		0,	0273,	
	"cpe",		S_OP1,		0,	0274,	
	"cph",		S_OP1,		0,	0275,	
	"cpl",		S_OP1,		0,	0276,	
	"cpm",		S_OP1,		0,	0277,	
	"dcb",		S_OP1,		0,	0011,	
	"dcc",		S_OP1,		0,	0021,	
	"dcd",		S_OP1,		0,	0031,	
	"dce",		S_OP1,		0,	0041,	
	"dch",		S_OP1,		0,	0051,	
	"dcl",		S_OP1,		0,	0061,	
	"hlt",		S_OP1,		0,	0377,	
	"inb",		S_OP1,		0,	0010,	
	"inc",		S_OP1,		0,	0020,	
	"ind",		S_OP1,		0,	0030,	
	"ine",		S_OP1,		0,	0040,	
	"inh",		S_OP1,		0,	0050,	
	"inl",		S_OP1,		0,	0060,	
	"laa",		S_OP1,		0,	0300,	
	"lab",		S_OP1,		0,	0301,	
	"lac",		S_OP1,		0,	0302,	
	"lad",		S_OP1,		0,	0303,	
	"lae",		S_OP1,		0,	0304,	
	"lah",		S_OP1,		0,	0305,	
	"lal",		S_OP1,		0,	0306,	
	"lam",		S_OP1,		0,	0307,	
	"lba",		S_OP1,		0,	0310,	
	"lbb",		S_OP1,		0,	0311,	
	"lbc",		S_OP1,		0,	0312,	
	"lbd",		S_OP1,		0,	0313,	
	"lbe",		S_OP1,		0,	0314,	
	"lbh",		S_OP1,		0,	0315,	
	"lbl",		S_OP1,		0,	0316,	
	"lbm",		S_OP1,		0,	0317,	
	"lca",		S_OP1,		0,	0320,	
	"lcb",		S_OP1,		0,	0321,	
	"lcc",		S_OP1,		0,	0322,	
	"lcd",		S_OP1,		0,	0323,	
	"lce",		S_OP1,		0,	0324,	
	"lch",		S_OP1,		0,	0325,	
	"lcl",		S_OP1,		0,	0326,	
	"lcm",		S_OP1,		0,	0327,	
	"lda",		S_OP1,		0,	0330,	
	"ldb",		S_OP1,		0,	0331,	
	"ldc",		S_OP1,		0,	0332,	
	"ldd",		S_OP1,		0,	0333,	
	"lde",		S_OP1,		0,	0334,	
	"ldh",		S_OP1,		0,	0335,	
	"ldl",		S_OP1,		0,	0336,	
	"ldm",		S_OP1,		0,	0337,	
	"lea",		S_OP1,		0,	0340,	
	"leb",		S_OP1,		0,	0341,	
	"lec",		S_OP1,		0,	0342,	
	"led",		S_OP1,		0,	0343,	
	"lee",		S_OP1,		0,	0344,	
	"leh",		S_OP1,		0,	0345,	
	"lel",		S_OP1,		0,	0346,	
	"lem",		S_OP1,		0,	0347,	
	"lha",		S_OP1,		0,	0350,	
	"lhb",		S_OP1,		0,	0351,	
	"lhc",		S_OP1,		0,	0352,	
	"lhd",		S_OP1,		0,	0353,	
	"lhe",		S_OP1,		0,	0354,	
	"lhh",		S_OP1,		0,	0355,	
	"lhl",		S_OP1,		0,	0356,	
	"lhm",		S_OP1,		0,	0357,	
	"lla",		S_OP1,		0,	0360,	
	"llb",		S_OP1,		0,	0361,	
	"llc",		S_OP1,		0,	0362,	
	"lld",		S_OP1,		0,	0363,	
	"lle",		S_OP1,		0,	0364,	
	"llh",		S_OP1,		0,	0365,	
	"lll",		S_OP1,		0,	0366,	
	"llm",		S_OP1,		0,	0367,	
	"lma",		S_OP1,		0,	0370,	
	"lmb",		S_OP1,		0,	0371,	
	"lmc",		S_OP1,		0,	0372,	
	"lmd",		S_OP1,		0,	0373,	
	"lme",		S_OP1,		0,	0374,	
	"lmh",		S_OP1,		0,	0375,	
	"lml",		S_OP1,		0,	0376,	
	"nda",		S_OP1,		0,	0240,	
	"ndb",		S_OP1,		0,	0241,	
	"ndc",		S_OP1,		0,	0242,	
	"ndd",		S_OP1,		0,	0243,	
	"nde",		S_OP1,		0,	0244,	
	"ndh",		S_OP1,		0,	0245,	
	"ndl",		S_OP1,		0,	0246,	
	"ndm",		S_OP1,		0,	0247,	
	"ora",		S_OP1,		0,	0260,	
	"orb",		S_OP1,		0,	0261,	
	"orc",		S_OP1,		0,	0262,	
	"ord",		S_OP1,		0,	0263,	
	"ore",		S_OP1,		0,	0264,	
	"orh",		S_OP1,		0,	0265,	
	"orl",		S_OP1,		0,	0266,	
	"orm",		S_OP1,		0,	0267,	
	"ral",		S_OP1,		0,	0022,	
	"rar",		S_OP1,		0,	0032,	
	"ret",		S_OP1,		0,	0007,	
	"rfc",		S_OP1,		0,	0003,	
	"rfp",		S_OP1,		0,	0033,	
	"rfs",		S_OP1,		0,	0023,	
	"rfz",		S_OP1,		0,	0013,	
	"rlc",		S_OP1,		0,	0002,	
	"rrc",		S_OP1,		0,	0012,	
	"rs1",		S_OP1,		0,	0015,	
	"rs2",		S_OP1,		0,	0025,	
	"rs3",		S_OP1,		0,	0035,	
	"rs4",		S_OP1,		0,	0045,	
	"rs5",		S_OP1,		0,	0055,	
	"rs6",		S_OP1,		0,	0065,	
	"rs7",		S_OP1,		0,	0075,	
	"rst",		S_OP1,		0,	0005,	
	"rtc",		S_OP1,		0,	0043,	
	"rtp",		S_OP1,		0,	0073,	
	"rts",		S_OP1,		0,	0063,	
	"rtz",		S_OP1,		0,	0053,	
	"sba",		S_OP1,		0,	0230,	
	"sbb",		S_OP1,		0,	0231,	
	"sbc",		S_OP1,		0,	0232,	
	"sbd",		S_OP1,		0,	0233,	
	"sbe",		S_OP1,		0,	0234,	
	"sbh",		S_OP1,		0,	0235,	
	"sbl",		S_OP1,		0,	0236,	
	"sbm",		S_OP1,		0,	0237,	
	"sua",		S_OP1,		0,	0220,	
	"sub",		S_OP1,		0,	0221,	
	"suc",		S_OP1,		0,	0222,	
	"sud",		S_OP1,		0,	0223,	
	"sue",		S_OP1,		0,	0224,	
	"suh",		S_OP1,		0,	0225,	
	"sul",		S_OP1,		0,	0226,	
	"sum",		S_OP1,		0,	0227,	
	"xra",		S_OP1,		0,	0250,	
	"xrb",		S_OP1,		0,	0251,	
	"xrc",		S_OP1,		0,	0252,	
	"xrd",		S_OP1,		0,	0253,	
	"xre",		S_OP1,		0,	0254,	
	"xrh",		S_OP1,		0,	0255,	
	"xrl",		S_OP1,		0,	0256,	
	"xrm",		S_OP1,		0,	0257,	
	"ihl",		S_OP1,		0,	0070,	
	"dhl",		S_OP1,		0,	0071,	
	"exc",		S_OP1,		0,	0042,	
	"sfa",		S_OP1,		0,	0311,	
	"rfa",		S_OP1,		0,	0322,	
	"sam",		S_OP1,		0,	0166,	
	"sma",		S_OP1,		0,	0126,	
	"ide",		S_OP1,		0,	0344,	
	"dde",		S_OP1,		0,	0333,	
	"ina",		S_OP1,		0,	0116,	
	"dca",		S_OP1,		0,	0077,	
	"pop",		S_OP1,		0,	0156,	
	"jde",		S_OP1,		0,	0176,	
	"cde",		S_OP1,		0,	0174,	
	"aci",		S_OP2,		0,	0014,	
	"adi",		S_OP2,		0,	0004,	
	"cpi",		S_OP2,		0,	0074,	
	"lai",		S_OP2,		0,	0006,	
	"lbi",		S_OP2,		0,	0016,	
	"lci",		S_OP2,		0,	0026,	
	"ldi",		S_OP2,		0,	0036,	
	"lei",		S_OP2,		0,	0046,	
	"lhi",		S_OP2,		0,	0056,	
	"lli",		S_OP2,		0,	0066,	
	"lmi",		S_OP2,		0,	0076,	
	"ndi",		S_OP2,		0,	0044,	
	"ori",		S_OP2,		0,	0064,	
	"sbi",		S_OP2,		0,	0034,	
	"sui",		S_OP2,		0,	0024,	
	"xri",		S_OP2,		0,	0054,	
	"tai",		S_OP2,		0,	0072,	
	"gam",		S_OP3,		0,	0136,	
	"gbm",		S_OP3,		0,	0114,	
	"gcm",		S_OP3,		0,	0124,	
	"gdm",		S_OP3,		0,	0134,	
	"gem",		S_OP3,		0,	0144,	
	"ghm",		S_OP3,		0,	0154,	
	"glm",		S_OP3,		0,	0164,	
	"gma",		S_OP3,		0,	0001,	
	"gmb",		S_OP3,		0,	0017,	
	"gmc",		S_OP3,		0,	0027,	
	"gmd",		S_OP3,		0,	0037,	
	"gme",		S_OP3,		0,	0047,	
	"gmh",		S_OP3,		0,	0057,	
	"gml",		S_OP3,		0,	0067,	
	"inm",		S_OP3,		0,	0146,	
	"cal",		S_OP3,		0,	0106,	
	"cfc",		S_OP3,		0,	0102,	
	"cfp",		S_OP3,		0,	0132,	
	"cfs",		S_OP3,		0,	0122,	
	"cfz",		S_OP3,		0,	0112,	
	"ctc",		S_OP3,		0,	0142,	
	"ctp",		S_OP3,		0,	0172,	
	"cts",		S_OP3,		0,	0162,	
	"ctz",		S_OP3,		0,	0152,	
	"jfc",		S_OP3,		0,	0100,	
	"jfp",		S_OP3,		0,	0130,	
	"jfs",		S_OP3,		0,	0120,	
	"jfz",		S_OP3,		0,	0110,	
	"jmp",		S_OP3,		0,	0104,	
	"jtc",		S_OP3,		0,	0140,	
	"jtp",		S_OP3,		0,	0170,	
	"jts",		S_OP3,		0,	0160,	
	"jtz",		S_OP3,		0,	0150,	
	"in",		S_IN,		0,	0101,
	"out",		S_OUT,		0,	0101,
	"advrdr",	S_OP1,		0,	0121,
	"outdat",	S_OP1,		0,	0123,
	"outcon",	S_OP1,		0,	0125,
	"setx",		S_OP1,		0,	0127,
	"punch",	S_OP1,		0,	0131,
	"sety",		S_OP1,		0,	0135,
	"beep",		S_OP1,		0,	0121,
	"inio",		S_OP1,		0,	0101,
	"incon",	S_OP1,		0,	0103,
	"rdy",		S_OP1,		0,	0105,
	"portin",	S_OP1,		0,	0111
};

/*
 * Pointers to the end of the two symbol
 * tables.
 * These must be here for the `sizeof' to
 * work.
 */
struct sym *pptr &pst[sizeof(pst)/sizeof(pst[0])]; /* Ditto */
struct sym *uptr &ust[17];
