/*
 * ldr [-dis] [-x #] [-s #] file [file ...]
 */
#include <stdio.h>
#include <rel.h>

/*
 * Relocatable items.
 */
#define	O_REL	0		/* Rel. file header */
#define O_LIB	1		/* Lib. file header */
#define O_EOF	2		/* Fake EOF */
#define O_DIR	3		/* Lib. directory */
#define O_PSECT	4		/* Psect */
#define O_SYM	5		/* Symbols */
#define O_SYEND	6		/* SYEND of symbols */
#define O_ABS	7		/* Absolute text */
#define O_TEXT	8		/* Full text */

/*
 * Psect node.
 * One per psection.
 * Global psections are kept
 * in a hash table.
 * Local psections are only
 * refered to by load table
 * entries.
 */
struct	psect {
	struct	psect *p_link;
	char	p_name[NCPS];
	int	p_flag;
	loc_t	p_size;
};

#define	P_I	01		/* I space */
#define P_SHR	02		/* Shared */
#define P_OVR	04		/* Overlaid */
#define P_LOCAL	010		/* Local */
#define P_BOUND	020		/* Already bound */

/*
 * Symbol node.
 * Symbol nodes exist for
 * global and local symbols.
 * Globals are put into a hash
 * table by pass 0.
 * Locals are put there by pass
 * 1 for use in the map and the
 * symbol table.
 * Locals are ripped out at
 * the end of processing a
 * file.
 */
struct	sym	{
	struct	sym *s_link;
	char	s_name[NCPS];
	int	s_flag;
	loc_t	s_loc;
};

#define	S_LOCAL	01		/* Local */
#define S_WEAK	02		/* Weak */
#define S_DEF	04		/* Defined */
#define S_BOUND	010		/* Bound */

/*
 * Load table node.
 * An entry is made in the
 * load table for each file
 * processed by pass 0.
 * It also saves pointers to
 * the psect and symbol nodes
 * associated with a module.
 * Pass 1 reads through this
 * table to perform the actual
 * loading.
 */
struct	ltab {
	struct	ltab *l_link;
	char	*l_file;
	int	l_nps;
	int	l_nsym;
	struct	psect ***l_psp;
	struct	sym ***l_symp;
};

int	dflag;
int	ssize	= 256;
int	xsize;

/*
 * This is the part that does
 * the loadin'
 */
main(argc, argv)
char *argv[];
{
	register char *p;
	register int c, i;
	int nf;

	nf = argc-1;
	for(i=1; i<argc; ++i) {
		p = argv[i];
		if(*p == '-') {
			++p;
			argv[i] = NULL;
			--nf;
			while(c = *p++)
				switch(c) {

				case 'd':
				case 'D':
					++dflag;
					break;

				case 'i':
				case 'I':
					fprintf(stderr, "%c: meaningless\n", c);
					break;

				case 's':
				case 'S':
				case 'x':
				case 'X':
					if(++i >= argc)
						usage();
					if(c=='s' || c=='S')
						ssize = atoi(argv[i]);
					else
						xsize = atoi(argv[i]);
					argv[i] = NULL;
					--nf;
					break;

				default:
					usage();
				}
		}
	}
	if(nf == 0)
		usage();

	/*
	 * Begin loading.
	 */
	init();
	for(i=1; i<argc; ++i)
		if((p=argv[i]) != NULL)
			p0arg(p);
	bind();
	if(dflag)
		ltdump();
	p1();
	finish();
}

/*
 * Process a pass 0 argument.
 * Open the file.
 * Check that it is an object
 * file.
 * Call off to pass 0.
 */
p0arg(f)
char *f;
{
	fn = f;
	if((fp=fopen(f, "ru")) == NULL) {
		fprintf(stderr, "%s: cannot open\n", f);
		return;
	}
	if(fget(&rb, sizeof(rb), fp) != sizeof(rhdr)) {
		format("header size");
		fclose(fp);
		return;
	}
	if(rb.r_type == O_REL)
		p0(0, 0);
	else if(rb.r_type == O_LIB)
		p0lib();
	else
		format("header type");
	fclose(fp);
}

/*
 * Process a library.
 * Read through the library
 * directory and call pass 0
 * for each relocatable element
 * needed.
 */
p0lib()
{
	format("library");
}

/*
 * Run through the load table
 * binding the psections and
 * symbols to their final addresses
 * in the image.
 */
bind()
{
	/*
	 * Psections.
	 */
	if(iflag) {
		loc = 0;
		bind1(P_I|P_SHR);
		if(nflag)
			uploc();
		bind1(P_I);
		ibreak = loc;
	}
	loc = DBASE;
	if(!iflag)
		bind1(P_I|P_SHR);
	bind1(P_SHR);
	if(nflag)
		uploc();
	if(!iflag)
		bind1(P_I);
	bind1(0);
	dbreak = loc;
	bind1(P_BSS);
	bbreak = loc;

	/*
	 * Symbols.
	 */
}

/*
 * Bump the location counter
 * by `n' bytes.
 * If it overflows look at
 * the flags and print out a
 * nice overflow message.
 */
bumploc(n, f)
loc_t n;
{
	register loc_t nloc;
	register char *s;

	nloc = loc+n;
	if(nloc < loc) {
		if((f&P_BSS) != 0)
			s = "Data spece (bss)";
		else if((f&P_I) != 0)
			s = "Instruction space";
		else
			s = "Data space";
		fprintf(stderr, "%s overflow!\n", s);
		exit(1);
	}
	loc = nloc;
}

/*
 * Complain about the format
 * of a relocatable file.
 */
format(s)
char *s;
{
	fprintf(stderr, "%s: bad format (%s)\n", fn, s);
	exit(1);
}
