/
/ PDP-11 C.
/ Stdio.
/
/ Integer to ASCII (all radix).
/
 
	.globl	_itoc, _itox, _itoc8
 
t10:	.word	-10000.
	.word	-1000.
	.word	-100.
	.word	-10.
t10e:	.blkw	0
 
htab:	.ascii	"0123456789ABCDEF"
 
 
/
/ Integer to decimal ascii.
/ Number in r0
/ Pointer to output area in r1
/
 
_itoc:
	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
 
	mov	r0,-(sp)
	bpl	0f
	movb	$'-,(r1)+
	br	1f
 
0:
	neg	r0
 
1:
	mov	$t10,r2
	clr	r3
 
2:
	mov	$'0,r4
 
0:
	cmp	r0,(r2)
	bgt	0f
	sub	(r2),r0
	inc	r4
	br	0b
 
0:
	cmp	r4,$'0
	bne	0f
	tst	r3
	beq	1f
 
0:
	movb	r4,(r1)+
	inc	r3
 
1:
	tst	(r2)+
	cmp	r2,$t10e
	blo	2b
	neg	r0
	add	$'0,r0
	movb	r0,(r1)+
 
	mov	(sp)+,r0
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r4
	return
 
/
/ _itox
/ Integer to hexadecimal ascii.
/ Number in r0.
/ Output pointer in r1.
/
 
_itox:
	mov	r0,-(sp)
	mov	r2,-(sp)
	mov	r3,-(sp)
 
	mov	$3,r2
 
0:
	call	2f
	bne	1f
	dec	r2
	bne	0b
 
0:
	call	2f
 
1:
	movb	htab(r3),(r1)+
	dec	r2
	bge	0b
 
	mov	(sp)+,r3
	mov	(sp)+,r2
	mov	(sp)+,r0
	return
 
2:
	clr	r3
	asl	r0
	rol	r3
	asl	r0
	rol	r3
	asl	r0
	rol	r3
	asl	r0
	rol	r3
	return
 
/
/ _itoc8.
/ Integer to octal ascii.
/ Number in r0.
/ Pointer in r1.
/
 
_itoc8:
	mov	r0,-(sp)
	mov	r2,-(sp)
	mov	r3,-(sp)
 
	mov	$4,r2
	asl	r0
	bcc	0f
	movb	$'1,(r1)+
	br	1f
 
0:
	call	3f
	cmp	r3,$'0
	bne	2f
	dec	r2
	bne	0b
 
1:
	call	3f
 
2:
	movb	r3,(r1)+
	dec	r2
	bge	1b
 
	mov	(sp)+,r3
	mov	(sp)+,r2
	mov	(sp)+,r0
	return
 
3:
	mov	$6,r3
	asl	r0
	rol	r3
	asl	r0
	rol	r3
	asl	r0
	rol	r3
	return
