/*
 * FCS attribute block.
 */
struct	fcs
{
	char	f_rtyp;
	char	f_ratt;
	int	f_rsiz;
	int	f_hibk[2];
	int	f_efbk[2];
	int	f_ffby;
	char	f_gok[18];
};

#define	R_FIX	01		/* Fixed length records */
#define R_VAR	02		/* Variable length records */
#define R_SEQ	04		/* Sequenced records */

#define FD_FTN	01		/* FORTRAN slew */
#define FD_CR	02		/* CRLF slew */
#define FD_BLK	010		/* Records cannot straddle blocks */

/*
 * Files-11 header block.
 */
struct	hdr
{
	char	h_idof;		/* Identification area offset */
	char	h_mpof;		/* Map area offset */
	int	h_fnum;		/* File number */
	int	h_fseq;		/* File sequence */
	int	h_flev;		/* Structure level */
	char	h_prog;		/* Member number */
	char	h_proj;		/* Group number */
	int	h_fpro;		/* File protection code */
	char	h_ucha;		/* User characteristics */
	char	h_scha;		/* System characteristics */
	struct	fcs h_ufat;	/* FCS attributes */
	char	i_fnam[6];	/* File name */
	char	i_ftyp[2];	/* File type */
	int	i_fver;		/* File version */
	int	i_rvno;		/* Revision number */
	char	i_rvdt[7];	/* Revision date */
	char	i_rvti[6];	/* Revision time */
	char	i_crdt[7];	/* Creation date */
	char	i_crti[6];	/* Creation time */
	char	i_exdt[7];	/* Expiration date */
	char	i_fill;		/* To word boundry */
	char	m_esqn;		/* Extension segment number */
	char	m_ervn;		/* Extension rel. volume number */
	int	m_efnu;		/* Extension file number */
	int	m_efsq;		/* Extension sequence number */
	char	m_ctsz;		/* Size of count in rp */
	char	m_lbsz;		/* Size of logical block in rp */
	char	m_use;		/* Words of pointers in use */
	char	m_max;		/* Max words available */
	char	m_rtrv[408];	/* The pointers */
	int	h_cksm;		/* Checksum */
};

/*
 * Some magic bits.
 * Mostly in the system and user characteristic
 * fields.
 */
#define	UC_CON	0200
#define UC_DLK	0100
#define SC_MDL	0200
#define SC_BAD	0100
