/*
 * l [-n] [file ...]
 */
#include <stdio.h>

#define PGSIZE	22
#define LBSIZE	128

int	nflag;

main(argc, argv)
char *argv[];
{
	register int c, i;
	register char *p;
	int nf;
	FILE *iop;

	nf = argc-1;
	for(i=1; i<argc; ++i) {
		p = argv[i];
		if(*p == '-') {
			++p;
			while(c = *p++)
				switch(c) {

				case 'n':
				case 'N':
					++nflag;
					break;

				default:
					error("Usage: l [-n] [file ...]\n");
				}
			argv[i] = 0;
			--nf;
		}
	}
	if(nf == 0)
		list(stdin);
	else
		for(i=1; i<argc; ++i)
			if(p = argv[i]) {
				if((iop=fopen(p, "r")) == NULL)
					cant(p);
				list(iop);
				fclose(iop);
			}
}

list(iop)
FILE *iop;
{
	register int lop;
	char b[LBSIZE], nlb[10];

	lop = 0;
	while(fgets(b, iop)) {
		if(!nflag && lop>=PGSIZE) {
			lop = 0;
			if(gets(nlb) == NULL)
				break;
		}
		puts(b);
		++lop;
	}
}

cant(p)
char *p;
{
	error("%s: cannot open\n", p);
}
