/*
 * as85.c
 * Tables.
 */
#include <stdio.h>
#include "as8.h"

/*
 * Assorted variables.
 */
int	listmode;		/* Listing control */
int	listaddr;		/* Listing control */
int	entaddr;		/* Entry address */
FILE	*src;			/* Source */
FILE	*lst;			/* Listing */
FILE	*obj;			/* Object */
int	lflag;			/* -l flag */
int	nflag;			/* -n flag */
int	pass;			/* Which pass? */
int	lineno;			/* Line number */
char	*sptr;			/* Source pointer */
char	sbuf[SRCMAX];		/* Source buffer */
char	*cptr;			/* Listing code pointer */
char	cbuf[CLMAX];		/* Listing code buffer */
char	*eptr;			/* Error pointer */
char	ebuf[ERRMAX];		/* Error buffer */
int	cadr;			/* Object address */
int	crec;			/* Object index */
char	crbf[CBMAX];		/* Object buffer */

/*
 * User symbol table.
 * The first item must be '.'.
 */
struct sym ust[USERMAX] = {
	".",		S_ABS,		SF_ASG,	0
};

/*
 * Opcode table.
 * Also contains pseudo operations and
 * registers.
 */
struct sym pst[] = {
	"b",		S_REG,		0,	0,
	"c",		S_REG,		0,	1,
	"d",		S_REG,		0,	2,
	"e",		S_REG,		0,	3,
	"h",		S_REG,		0,	4,
	"l",		S_REG,		0,	5,
	"m",		S_REG,		0,	6,
	"a",		S_REG,		0,	7,
	"bc",		S_REGP,		0,	0,
	"de",		S_REGP,		0,	1,
	"hl",		S_REGP,		0,	2,
	"sp",		S_REGP,		0,	3,
	"psw",		S_REGP,		0,	PSW,
	".entry",	S_ENTRY,	0,	0,
	".byte",	S_BYTE,		0,	0,
	".word",	S_WORD,		0,	0,
	".ascii",	S_ASCII,	0,	0,
	".asciz",	S_ASCIZ,	0,	0,
	".blkb",	S_BLKB,		0,	0,
	"pchl",		S_OP1,		0,	0351,
	"ret",		S_OP1,		0,	0311,
	"rc",		S_OP1,		0,	0330,
	"rnc",		S_OP1,		0,	0320,
	"rz",		S_OP1,		0,	0310,
	"rnz",		S_OP1,		0,	0300,
	"rm",		S_OP1,		0,	0370,
	"rp",		S_OP1,		0,	0360,
	"rpe",		S_OP1,		0,	0350,
	"rpo",		S_OP1,		0,	0340,
	"xchg",		S_OP1,		0,	0353,
	"sphl",		S_OP1,		0,	0371,
	"cma",		S_OP1,		0,	0057,
	"daa",		S_OP1,		0,	0047,
	"rlc",		S_OP1,		0,	0007,
	"rrc",		S_OP1,		0,	0017,
	"ral",		S_OP1,		0,	0027,
	"rar",		S_OP1,		0,	0037,
	"xthl",		S_OP1,		0,	0343,
	"ei",		S_OP1,		0,	0373,
	"di",		S_OP1,		0,	0363,
	"stc",		S_OP1,		0,	0067,
	"nop",		S_OP1,		0,	0000,
	"hlt",		S_OP1,		0,	0166,
	"in",		S_OP2,		0,	0333,
	"out",		S_OP2,		0,	0323,
	"adi",		S_OP2,		0,	0306,
	"aci",		S_OP2,		0,	0316,
	"sui",		S_OP2,		0,	0326,
	"sbi",		S_OP2,		0,	0336,
	"ani",		S_OP2,		0,	0346,
	"xri",		S_OP2,		0,	0356,
	"ori",		S_OP2,		0,	0366,
	"cpi",		S_OP2,		0,	0376,
	"mvi",		S_OP3,		0,	0006,
	"mov",		S_OP4,		0,	0100,
	"ldax",		S_OP5,		0,	0012,
	"stax",		S_OP5,		0,	0002,
	"dad",		S_OP6,		0,	0011,
	"inx",		S_OP6,		0,	0003,
	"dcx",		S_OP6,		0,	0013,
	"push",		S_OP7,		0,	0305,
	"pop",		S_OP7,		0,	0301,
	"rst",		S_OP8,		0,	0307,
	"add",		S_OP9,		0,	0200,
	"sub",		S_OP9,		0,	0220,
	"adc",		S_OP9,		0,	0210,
	"sbb",		S_OP9,		0,	0230,
	"ana",		S_OP9,		0,	0240,
	"xra",		S_OP9,		0,	0250,
	"ora",		S_OP9,		0,	0260,
	"cmp",		S_OP9,		0,	0270,
	"inr",		S_OP9,		0,	0004,
	"dcr",		S_OP9,		0,	0005,
	"lxi",		S_OP10,		0,	0001,
	"jpo",		S_OP11,		0,	0342,
	"jpe",		S_OP11,		0,	0352,
	"jm",		S_OP11,		0,	0372,
	"jp",		S_OP11,		0,	0362,
	"jnz",		S_OP11,		0,	0302,
	"jz",		S_OP11,		0,	0312,
	"jnc",		S_OP11,		0,	0322,
	"jc",		S_OP11,		0,	0332,
	"cpo",		S_OP11,		0,	0344,
	"cpe",		S_OP11,		0,	0354,
	"cm",		S_OP11,		0,	0374,
	"cp",		S_OP11,		0,	0364,
	"cnz",		S_OP11,		0,	0304,
	"cz",		S_OP11,		0,	0314,
	"cnc",		S_OP11,		0,	0324,
	"cc",		S_OP11,		0,	0334,
	"call",		S_OP11,		0,	0315,
	"jmp",		S_OP11,		0,	0303,
	"lda",		S_OP11,		0,	0072,
	"sta",		S_OP11,		0,	0062,
	"lhld",		S_OP11,		0,	0052,
	"shld",		S_OP11,		0,	0042
};

/*
 * Pointers to the end of the
 * tables.
 * Must be here!
 */
struct sym *pptr &pst[sizeof(pst)/sizeof(pst[0])]; /* Ditto */
struct sym *uptr &ust[1];	/* Pointer to end of ust */
