/*
 * as8.h
 * Header.
 * Sizes of tables.
 * Don't change ERRMAX.
 */
#define NCPS	8		/* Characters per symbol */
#define CLMAX	100		/* Code bytes, line */
#define CBMAX	16		/* Code bytes, object */
#define USERMAX	100		/* User names */
#define SRCMAX	128		/* Source line length */
#define ERRMAX	10		/* Maximum errors per line */

#define dot	(&ust[0])	/* Location counter */

/*
 * 8080 Magic numbers.
 */
#define BC	0		/* BC in instructions */
#define DE	1		/* DE in instructions */
#define HL	2		/* HL in instructions */
#define SP	3		/* SP in instructions */
#define PSW	4		/* Flag */
#define INR	0004		/* INR opcode */
#define DCR	0005		/* DCR opcode */

/*
 * Listing control modes.
 * Go in `listmode'.
 */
#define NLIST	0		/* No list */
#define SLIST	1		/* Source only list */
#define ALIST	2		/* Just address */
#define CLIST	3		/* Address and code */

/*
 * Symbol table structure.
 * Used in both the user symbol table and
 * the opcode table.
 */
struct sym {
	char s_name[NCPS];	/* Name */
	char s_type;		/* Type */
	char s_flag;		/* Some flags */
	int  s_value;		/* Value */
};

/*
 * Types.
 */
#define S_UND	0		/* Undefined */
#define S_ABS	1		/* Absolute */
#define S_REG	2		/* Register */
#define S_REGP	3		/* Register pair */
#define S_ENTRY	4		/* .entry */
#define S_BYTE	5		/* .byte */
#define S_WORD	6		/* .word */
#define S_ASCII	7		/* .ascii */
#define S_ASCIZ	8		/* .asciz */
#define S_BLKB	9		/* .blkb */
#define S_OP1	10		/* Opcode */
#define S_OP2	11		/* Opcode byte */
#define S_OP3	12		/* Opcode reg,byte */
#define S_OP4	13		/* Opcode reg,reg */
#define S_OP5	14		/* Opcode bd */
#define S_OP6	15		/* Opcode bdhs */
#define S_OP7	16		/* Opcode bdhpsw */
#define S_OP8	17		/* Opcode 0-7 */
#define S_OP9	18		/* Opcode reg */
#define S_OP10	19		/* Opcode rp,word */
#define S_OP11	20		/* Opcode address */

/*
 * Flags.
 */
#define SF_MDF	01		/* Multiply defined */
#define SF_ASG	02		/* Defined by assignment */

/*
 * Variables.
 */
extern	struct	sym pst[];	/* Opcode table */
extern	struct	sym ust[];	/* User symbols */
extern	int	listmode;	/* Listing control */
extern	int	listaddr;	/* Listing control */
extern	int	entaddr;	/* .entry address */
extern	FILE	*src;		/* Source */
extern	FILE	*lst;		/* Listing */
extern	FILE	*obj;		/* Object */
extern	int	lflag;		/* -l flag */
extern	int	nflag;		/* -n flag */
extern	int	pass;		/* Which pass? */
extern	int	lineno;		/* Line number */
extern	char	*sptr;		/* Source pointer */
extern	char	sbuf[];		/* Source buffer */
extern	char	*cptr;		/* Listing code pointer */
extern	char	cbuf[];		/* Listing code buffer */
extern	char	*eptr;		/* Error pointer */
extern	char	ebuf[];		/* Error buffer */
extern	int	cadr;		/* Object address */
extern	int	crec;		/* Object index */
extern	char	crbf[];		/* Object buffer */
extern	struct	sym *pptr;	/* End of pst */
extern	struct	sym *uptr;	/* End of ust */

/*
 * Functions.
 */
extern	struct	sym *lookup();	/* Search */
