program PACKLIB ( input, output, tty );
 
(* This program compresses the source files of
   the runtime library modules to one file with unpacking
   information in it. The names of the source files are stored
   in the array NAMES. The resulting file contains for each file:
   - one line with the file name
   - the source module lines
   - one line containing '****'
   Unpacking can be performed by the program Unpack.         *)
 
const ANTAL = 70;
var   I,J,K: integer;
      C: char;
      EXT: array (.0..3.) of char;
      FILNAM: array (.0..20.) of char;
      NAMES: array (.1..ANTAL.) of array (.0..5.) of char;
 
 
begin
NAMES(.1.) := 'DEF   ';   NAMES(.2.) := 'INIT  ';   NAMES(.3.) := 'RESET ';   
NAMES(.4.) := 'GETPUT';   NAMES(.5.) := 'WRERR ';   NAMES(.6.) := 'EXIT  ';   
NAMES(.7.) := 'CMREAL';   NAMES(.8.) := 'WRREAL';   NAMES(.9.) := 'RDR   ';   
NAMES(.10.) := 'RDI   ';   NAMES(.11.) := 'RDHLP ';NAMES(.12.) := 'REAL  ';   
NAMES(.13.) := 'WRI   ';   NAMES(.14.) := 'MARKP ';   NAMES(.15.) := 'PBOOL ';   
NAMES(.16.) := 'REDSET';   NAMES(.17.) := 'EXPSET';   NAMES(.18.) := 'UNI4  ';   
NAMES(.19.) := 'INT4  ';   NAMES(.20.) := 'DIF4  ';   NAMES(.21.) := 'INITS ';   
NAMES(.22.) := 'SGSIN ';   NAMES(.23.) :='INN   ';   NAMES(.24.) := 'MPI   ';   
NAMES(.25.) := 'DVI   ';   NAMES(.26.):= 'LEQS1 ';   NAMES(.27.) := 'LEQS4 ';   
NAMES(.28.) := 'LEQ   ';   NAMES(.29.) := 'LEQM  ';   NAMES(.30.) := 'LEQM2 ';   
NAMES(.31.) := 'GEQ   ';   NAMES(.32.) := 'GEQM  ';   NAMES(.33.) := 'GEQM2 ';   
NAMES(.34.) := 'LES   ';   NAMES(.35.) := 'LESM  ';   NAMES(.36.) := 'LESM2 ';   
NAMES(.37.) := 'GRT   ';   NAMES(.38.) := 'GRTM  ';   NAMES(.39.) := 'GRTM2 ';   
NAMES(.40.) := 'NEQ   ';   NAMES(.41.) := 'NEQM  ';   NAMES(.42.) := 'NEQM2 ';   
NAMES(.43.) := 'EQU   ';   NAMES(.44.) := 'EQUM  ';   NAMES(.45.) := 'EQUM2 ';   
NAMES(.46.) := 'NEQS4 ';   NAMES(.47.) := 'GEQS1 ';   NAMES(.48.) := 'GEQS4 ';   
NAMES(.49.) := 'EQUS4 ';   NAMES(.50.) := 'TWPOW ';   NAMES(.51.) := 'SPLTRL';   
NAMES(.52.):= 'REXP  ';    NAMES(.53.) := 'RLOG  ';   NAMES(.54.) := 'RSQRT ';   
NAMES(.55.) := 'SINCOS';   NAMES(.56.) := 'RUNCHK';   NAMES(.57.) := 'MOVM  ';   
NAMES(.58.) := 'WROCT ';   NAMES(.59.) := 'GCML  ';   NAMES(.60.) := 'DATETM';   
NAMES(.61.) := 'FSR   ';   NAMES(.62.) := 'DUMP  ';   NAMES(.63.) := 'WRBOOL';
NAMES(.64.) := 'ABSPAS';   NAMES(.65.) := 'RANDOM';   NAMES(.66.) := 'EISMPI';
NAMES(.67.) := 'EISDVI';   NAMES(.68.) := 'FIS   ';   NAMES(.69.) := 'FPP   ';
NAMES(.70.) := 'FORTR ';
EXT := '.MAC';
 
rewrite( output, 'PASLIB.PAC');
writeln(tty,'Creating PASLIB.PAC');
 
for I:=1 to ANTAL do
 begin FILNAM := 'P11                  ';   J:=0;
  for K:=0 to 5 do
  if NAMES(.I,J.) <> ' ' then
  begin   FILNAM(.J+3.) := NAMES(.I,J.);   J:= J+1   end;
  for k:=0 to 3 do FILNAM(.J+K+3.) := EXT(.K.);
 
  reset( input, FILNAM );
  if eof(input) then writeln(tty,FILNAM,'not found')
  else
   begin   writeln( FILNAM );
    while not eof(input) do
     begin  (* copy a line *)
      while not eoln(input) do
       begin    read(c);   write(c)   end;
      readln;   writeln;
     end;
    writeln('****');
   end;
 end;
writeln(tty,'ready')
end.
