;%%A-RCB-0077-SL-10    LST -- INSTALLATION COMMAND FILE
.SETS SYS "SY"
.ASKS $S GIVE DISK FOR SOURCE FILES (1 or 2)
.ASKS $D GIVE DISK FOR LST, OBJ, TSK, MAP FILES (1 or 2)
.ENABLE SUBSTITUTION
.SETS $B "'$D'"
.SETS $T "'$D'"
;
; If the files are not available, they will be copied from DECtape.
.ASK X COPY FILES FROM TAPE
.IFF X .GOTO 200
     ;
     ; Retrieving files from DECtape
     .ASKS N GIVE DT
     FLX DK'$S':=DT'N':LSTGEN.RAT
     FLX DK'$S':=DT'N':LSTTXT.DAT,LSTAB0.DAT,LSTAB1.DAT,LSTAB3.DAT,LSTAB4.DAT
     FLX DK'$S':=DT'N':LSTAB5.DAT,LSTDAT.DAT
     FLX DK'$S':=DT'N':LSTSUB.RAT
     FLX DK'$S':=DT'N':LST.FTN,LSTINI.FTN,LSTCOM.FTN,LST30.FTN,LST40.FTN
     FLX DK'$S':=DT'N':LST50.FTN,LST90.FTN,LSTOPN.FTN
;
.200: ; If LSTGEN.TSK is not available, it will be built.
; LSTGEN is used to create the state transition table for LST.
.ASK X BUILD LSTGEN
.IFF X .GOTO 300
     ;
     ; Building LSTGEN
     .SETT $KNOWS
     .SETS $TASK "LSTGEN"
     .SETS $TYPE "RAT"
     .SETT $NEW
     .SETF $RUN
     .SETN $NSUB 0
     @[1,1]CLG
     PIP DK'$B':LSTGEN.OBJ;*,DK'$T':LSTGEN.LST;*/DE
     PIP DK'$S':LSTGEN.BLD;*/DE
;
.300: ;
; Creating new LSTTAB.DAT.  LSTTAB is a composite of the
; data files stored on the tape.  It is the input file for
; LSTGEN.
PIP 'SYS':LSTTAB.DAT;*/DE
PIP DK'$D':X.DAT=DK'$S':LSTTXT.DAT,LSTAB0,LSTAB1,LSTAB3
PIP 'SYS':LSTTAB.DAT=DK'$D':X.DAT,DK'$S':LSTAB4,LSTAB5,LSTDAT
PIP DK'$D':X.DAT;*/DE
;
; LSTTAB.DAT contains a table of the action routines and
; the actual state transition table.
.ASK X DO YOU WANT TO LIST LSTTAB.DAT
.IFF X .GOTO 500
     ;
     ; Listing LSTTAB
     LST DK'$D':X='SYS':LSTTAB.DAT
     HPP DK'$D':X.DAT
     PIP DK'$D':X.*;*/DE
.500: ;
; LSTGEN will create LSTTAB.FTN and LSTDCL.FTN from LSTTAB.DAT.
; LSTTAB.FTN is the BLOCK DATA program defining TABLE.
; LSTDCL.FTN defines the size of TABLE.
RUN DK'$T':LSTGEN
.GENWT: .IFNINS LSTGEN .GOTO GENWT
     .IFINS LSTGEN .WAIT LSTGEN
PIP 'SYS':LSTTAB.DAT;*/DE
;
.ASK X DO YOU WANT TO BUILD LST
.IFF X .GOTO END
;
; Compiling LSTSUB.RAT
PIP DK'$D':LSTSUB.LST;*,.OBJ;*/DE
RAT DK'$D':LSTSUB,DK'$D':LSTSUB=DK'$S':LSTSUB
F4P DK'$D':LSTSUB,DK'$D':X/-SP=DK'$D':LSTSUB/TR:NAMES
PIP DK'$D':LSTSUB.FTN;*/DE
;
; Compiling LST
PIP DK'$D':LST.LST;*,.OBJ;*/DE
F4P DK'$D':LST,DK'$D':LST/LI:2/-SP=DK'$S':LST/-TR
;
; Compiling LSTTAB
PIP DK'$D':LSTTAB.LST;*,.OBJ;*/DE
F4P DK'$D':LSTTAB,DK'$D':LSTTAB/-SP=SY:LSTTAB/-TR
;
; Compiling LSTOPN
PIP DK'$D':LSTOPN.LST;*,.OBJ;*/DE
F4P DK'$D':LSTOPN,DK'$D':LSTOPN/-SP=DK'$S':LSTOPN/TR:NAMES
;
; If there have been no errors, it is OK to build.
.ASK X OK TO BUILD
.IFF X .GOTO END
     ;
     ; Creating BLD and ODL files.
     PIP DK'$S':LST.BLD;*,LST.ODL;*/DE
     .OPEN DK'$S':LST.BLD
     .DATA DK'$D':LST/MU,DK'$D':LST/SH/-SP=DK'$S':LST/MP
     .DATA LIBR=F4PRES:RO
     .DATA PRI=55
     .DATA TASK=...LST
     .DATA ACTFIL=6
     .DATA MAXBUF=133
     .DATA //
     .CLOSE
     .OPEN DK'$S':LST.ODL
     .DATA ;  Programs required:
     .DATA ;     LST    -- Main program
     .DATA ;     LSTTAB -- Block data produced from LSTTAB.DAT
     .DATA ;                  by LSTGEN.TSK
     .DATA ;     LSTSUB -- Subroutines for LST, written in RATFOR
     .DATA ;     LSTOPN -- File opening routine
     .DATA ;
     .DATA ;  These PSECT declarations cause the task to be built with
     .DATA ; separate PURE and IMPURE sections, facilitating loading
     .DATA ; in a crowded memory.  They also cause TKB to produce a
     .DATA ; lot of messages indicating that PSECTs are multiply
     .DATA ; defined.  These messages should be ignored.
     .DATA ;
     .DATA ;  F4P PSECTs
     .DATA       .PSECT	$CODE1,RO,I,CON,LCL
     .DATA       .PSECT	$PDATA,RO,D,CON,LCL
     .DATA ;
     .DATA ;  Control table for states
     .DATA       .PSECT	TABLE,RO,D,OVR,GBL
     .DATA ;
     .DATA       .ROOT	DK'$D':LST-DK'$D':LSTTAB-DK'$D':LSTSUB-REST
     .DATA REST: .FCTR	DK'$D':LSTOPN-F4P-TABLE
     .DATA F4P:  .FCTR	$CODE1-$PDATA
     .DATA       .END
     .CLOSE
     PIP DK'$D':X.*;*/DE
     ;
     ; Building LST.
     ; The PSECT error messages may be ignored.
     PIP DK'$D':LST.TSK;*,.MAP;*/DE
     TKB @DK'$S':LST.BLD
     PIP DK'$S':LSTTAB.*;*,LSTDCL.FTN;*,DK'$D':LSTTAB.*;*/DE
     PIP DK'$D':LSTSUB.OBJ;*,LSTOPN.OBJ;*/DE
     PIP DK'$D':LST.OBJ;*,DK'$S':LST.BLD;*,.ODL;*/DE
.END:
