;%%A-RCB-0077-SL-1    EXTRAC -- USER'S GUIDE GENERATOR
.GOTO 10
;++
; .BEGIN A-RCB-0065-SP-7###########EXTRAC USER'S GUIDE
; .LAB1 ###################EXTRAC USER'S GUIDE###################
; .LAB3 P.D.#McMorran#;#77-12-1##;0065;7#;4#
; .SECT 8
; PURPOSE
; .NP
; EXTRAC is an MCR command file which extracts a brief user's guide
; from the comments of a source program.
; .SECT 8
; METHOD OF USE
; .NP
; Comments to be extracted are bracketted by ;++ and ;-- in the
; program text (where ';' is the appropriate comment flag).
; EXTRAC will drop the first two characters of each line extracted
; (unless the second character is a tab) 
; and will place the line in a file.
; .NP
; EXTRAC makes extensive use of the indirect MCR facility [1] of
; RSX-11D V6.2, and it is called with the MCR command @EXTRAC.
; It begins by listing a part of the user's directory and asking if
; the extraction program is present.
; It then creates the command file RNO.CMD, which is used to
; RUNOFF and HPP the output files, and it creates a file of standard
; RUNOFF macros.
; Finally, if the user indicated that the extraction program
; was not available, it is created.
; .NP
; When all is prepared, EXTRAC asks for the file to be processed.
; This will normally be a program source file, and the name
; given must include the file type (.FTN, .RAT, or .MAC).
; If the file is not found, a FORTRAN error message is printed,
; with a prompt for a new name.
; The comments between ;++ and ;-- are then  combined with the macro
; file in a file with the same name as the program, but with the
; type .GDE (for GUIDE).
; EXTRAC finishes by using RNO.CMD, to print the resulting
; file.
; .NP
; After the file is printed, EXTRAC prompts for another file.
; Type <cr> to exit.
; To print the file again, the RNO command file may be used directly.
; It prompts for the name, and then uses RNO and HPP to print it.
; .SECT 8
; RUNOFF MACROS
; .NP
; The macros provided by EXTRAC permit the generation of good-looking
; output with a minimum of clutter in the source file.
; Used as described, they yield margins of 1 inch top and
; bottom, 1.5 inches left and 1.25 inches right.
; They provide a label on the first page and they include features
; to facilitate the creation of tables and examples.
; The macros are defined in the following list.
; .SEG 40
; .NORMAL
;   MACRO	DESCRIPTION
;
;  .BEGIN TITLE	Initializes the margins and sets the page heading to
;			TITLE.  TITLE should not contain leading blanks.
;  .LAB1 TI	TI is the first line of the title on the label
; 			(57 letters).
;  .LAB2 ST	ST is the second line of the title (57 letters).
; 			LAB2 is optional.
;  .LAB3 NAM;DAT;RCB;SP;NP	Completes the label by adding:
; 			NAM -- author's name -- 14 letters
; 			DAT -- date -- 10 letters
; 			RCB -- RCB number -- 4 digits
; 			SP  -- SP number -- 2 digits
; 			NP  -- number of pages -- 2 digits
;  
; 	Any of these fixed-length fields may be padded with _# to obtain
; the specified length.
;  
;  .LONG	Sets the normal paper size.  LONG should be used on the
; 			second page to ensure that the label appears at
; 			the bottom of page 1.
;  
;  .NP		New paragraph -- includes a test.
;  
;  .SECT TEST	Section -- leaves a space, tests for TEST lines.
;  
;  .SEG TEST	Start of example -- leaves a space, tests for TEST lines
;			and switches to NOFILL with narrow margins.
;  .EDGE	Used during an example to print at the margin.
;  .EEG		End of example -- restores to normal.
;  
;  .TAB N	Table entry -- sets narrow margin, but prints N with
;			.IN -5.  N may be [n], n._#, or --, for
;			references, numbered lists, or plain lists.
;  .ENDTAB	Returns to normal after a table.
; .EEG
; .LONG
; .SEG 6
; .EDGE
; The last two lines extracted from the source file should be
;  .PE
;  BLANK PAGE AT END
; .EEG
; .SEG 25
; .EDGE
; For example, a typical FORTRAN program may contain
;
;	SUBROUTINE FRED
; C++
; C .BEGIN A-RCB-9999-SP-1   USER'S GUIDE FOR FRED
; C .LAB1 THIS IS A 57-LETTER TITLE TO SHOW THAT IT IS EXACTLY   57
; C .LAB3 P.D._#McMorran_#;_#77-01-01_#;9999;1_#;3_#
; C .SECT 8
; C PURPOSE
; C .NP
; C Text describing this program.
; C	.
; C	.
; C	.
; C .LONG  (once we are on page 2 -- this must be
; C			found empirically)
; C	.
; C	.
; C	.
; C .PE
; C BLANK PAGE
; C--
;	Program
;	END
; .EEG
; .SECT 8
; TECHNICAL DETAILS
; .TAB --
; EXTRAC creates several temporary files named X.
; These are all deleted at exit.
; .TAB --
; The program which performs the extraction does not actually
; check for comments.
; It is controlled by lines containing only 3 characters, ending
; in + or -.
; Column 2 is ignored for compatibility with LWRCMT [3] which
; puts a '.' in column 2 of comments which it has processed.
; .TAB --
; Lines of 3 characters or more are extracted beginning with column
; 3, or with the first tab, if it precedes column 3.
; Shorter lines are replaced by a single blank.
; .TAB --
; Actual program text may be extracted provided that each line begins
; with a tab, or at least two blanks.
; .TAB --
; Typing _^Z in response to the error prompt from the program
; causes it to exit and causes the command processor to terminate
; with an error.
; .TAB --
; The file EXTRAC.CMD [2] itself contains an extensive example
; of the use of the above macros since this document was
; produced by EXTRAC.
; .TAB --
; Note that omitting a ;-- may cause an entire program to be extracted.
; The solution is obvious.
; .TAB --
; EXTRAC may be run indirectly from another command file.
; In this case, if the symbol $NOMRG is set true, EXTRAC will
; create the program and the macro file, and process one input file
; to create X.RNO.
; It will then return to the calling file.
; This permits the use of different processing sequences involving
; files which are not known to EXTRAC.
; .ENDTAB
; .SECT 10
; REFERENCES
; .TAB [1]
; "Indirect MCR User's Guide".
; CRNL Reactor Control Branch Engineering Document A-RCB-0065-SP-8,
; December 1977.
; .TAB [2]
; "EXTRAC -- User's Guide Generator".
; CRNL Reactor Control Branch Engineering Document A-RCB-0077-SL-1,
; December 1977.
; .TAB [3]
; "LWRCMT -- Lower Case Comment Conversion Program."
; CRNL Reactor Control Branch Engineering File RCB-0152.
; .ENDTAB
; .PE
; BLANK PAGE AT END
;--
;%^

.10: .SETS MACFIL "GDEMAC.RNO"
.SETS TASK "EXTRAC"
.ENABLE SUBSTITUTION
PIP 'TASK'.TSK/BR
.ASK PROG IS 'TASK'.TSK IN THIS LIST
.DISABLE SUBSTITUTION
;
; Building RNO.CMD
PIP RNO.CMD;*/DE
.OPEN RNO.CMD
.DATA .ENABLE SUBSTITUTION
.DATA .IFNDF $NAME .ASKS $NAME GIVE FILENAME
.ENABLE DATA
RNO X/-SP='$NAME'/-FF/NL:80.
HPP X.LST/RP/NL:80.
PIP X.*;*/DE
.DISABLE DATA
.CLOSE
.ENABLE SUBSTITUTION
.GOTO 11
;%^

.11: ; Building 'MACFIL'
PIP 'MACFIL';*/DE
.OPEN 'MACFIL'
.DISABLE SUBSTITUTION
.DATA .; INITIAL MACRO FOR USER'S GUIDES
.DATA .MAC BEGIN TITLE
.DATA ^^
.DATA .TI #################%1
.DATA .PS 66,105
.DATA .NORMAL
.DATA .RMARG
.DATA .TSET
.DATA .NORMSP
.DATA .NJ
.DATA .FI
.DATA .NU 0
.DATA THIS PAGE IS BLANK
.DATA .PE
.DATA .E
.DATA .;
.DATA .; LABEL MACROS
.DATA .;	There are three label macros which must be used together.
.DATA .;  The reason for having three is that it is hard to put all
.DATA .;  the label information on one macro call line.
.DATA .;	LAB1 prints the job title, LAB2 prints the subtitle, and
.DATA .;  LAB3 prints the author, date, RCB number and SP number.  They
.DATA .;  should be used together, in order, at the start of the table
.DATA .;  of contents page.
.DATA .;	TI is the title,   which must be 57 letters.
.DATA .;	ST "   "  subtitle,  "    "   "  57    "
.DATA .;	NAM is the author's name; 14 letters.
.DATA .;	DAT is the date; 10 letters.
.DATA .;	RCB is the RCB number; 4 digits.
.DATA .;	SP  is the SP  number; 2 characters  (use 1# for SP-1)
.DATA .;	NP  is the number of pages in the document; 2 characters
.DATA .MAC LAB1 TI
.DATA .SP 1
.DATA .FO 5
.DATA .NF
.DATA .NJ
.DATA .RI 130
.DATA .LE 42
.DATA #
.DATA #
.DATA )BQ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;W
.DATA )B:)C%1)B:
.DATA )B:                                                         :
.DATA !
.DATA .E
.DATA .;
.DATA .MAC LAB2 ST
.DATA .SP 1
.DATA .FO 1
.DATA .NF
.DATA .NJ
.DATA .RI 130
.DATA .LE 42
.DATA )B:%1:
.DATA !
.DATA .E
.DATA .;
.DATA .MAC LAB3 NAM;DAT;RCB;SP;NP
.DATA .SP 1
.DATA .FO 9
.DATA .NF
.DATA .NJ
.DATA .RI 130
.DATA .LE 42
.DATA )B!,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,7,,,,,,7,,,,,7,,,,,,,"
.DATA )B: DR'N#%1DATE#%2 .BLDG. .CODE . CLASS :
.DATA )B!,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,/,,,,,,/,,,,,/,,,,,,,"
.DATA )B: APP'D              DATE            . 600  .     .   E   :
.DATA )B!,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,/,,,,,,8,,,,,8,,,,,,,"    
.DATA )B:     ATOMIC ENERGY OF CANADA        .   A-RCB-%3-SP-%4#:
.DATA )B:             LIMITED                .                    :
.DATA )B:    CHALK RIVER ONTARIO CANADA      .REV.   SHEET 1 OF %5:
.DATA )BA;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;$;;;;;;;;;;;;;;;;;;;;S
.DATA !
.DATA .RMARG
.DATA .NORMAL
.DATA .E
.DATA .;
.DATA .;MODE-SETTING MACROS
.DATA .;
.DATA .;	These must be adjusted for changes to margins, etc.
.DATA .;
.DATA .; Long for normal pages
.DATA .MAC LONG
.DATA .PS 60
.DATA .RMARG
.DATA .E
.DATA .;
.DATA .; Normal margin
.DATA .MAC NORMAL
.DATA .LE 17
.DATA .E
.DATA .;
.DATA .; Narrow column -- this leaves only 64 columns for typing.
.DATA .MAC NARROW
.DATA .LE 25
.DATA .E
.DATA .;
.DATA .; Normal spacing
.DATA .MAC NORMSP
.DATA .SP 1
.DATA .E
.DATA .;
.DATA .; Normal right margin
.DATA .MAC  RMARG
.DATA .RI 88
.DATA .E
.DATA .;
.DATA .; Open right margin for tables
.DATA .MAC OPEN
.DATA .RI 104
.DATA .E
.DATA .;
.DATA .; Standard tab settings -- modified to allow for 2-space
.DATA .;	shift.  This ensures same appearance on screen and on
.DATA .;	output.
.DATA .MAC TSET
.DATA .TA 17 23 31 39 47 55 63 71 79 87
.DATA .E
.DATA .;
.DATA .; Fudge tabs for IN -5 with tab broken from text
.DATA .MAC TFU
.DATA .TA 17 24 31
.DATA .E
.DATA .;
.DATA .; LOCAL MACROS
.DATA .;
.DATA .; New subsection macro -- equivalent to .PA 0
.DATA .MAC SECT TEST
.DATA .SK 2
.DATA .TE %1
.DATA .IN 0
.DATA .E
.DATA .;
.DATA .; New paragraph macro
.DATA .MAC NP
.DATA .SK 1
.DATA .TE 5
.DATA .IN 8
.DATA .E
.DATA .;
.DATA .; Start of example
.DATA .MAC SEG  CHECK
.DATA .SK 1
.DATA .TE %1
.DATA .NF
.DATA .NARROW
.DATA .OPEN
.DATA .E
.DATA .;
.DATA .; Print example line at margin -- only for NARROW
.DATA .MAC EDGE
.DATA .IN -8
.DATA .E
.DATA .;
.DATA .; End of example
.DATA .MAC EEG
.DATA .NORMAL
.DATA .RMARG
.DATA .FI
.DATA .SK 1
.DATA .E
.DATA .;
.DATA .; Table entry.  N is --, or [n] for numbered list.
.DATA .MAC TAB N
.DATA .SK 1
.DATA .TE 4
.DATA .NARROW
.DATA .TFU
.DATA .IN -5
.DATA %1	
.DATA .E
.DATA .;
.DATA .; End of table
.DATA .MAC ENDTAB
.DATA .NORMAL
.DATA .TSET
.DATA .SK 1
.DATA .E
.CLOSE
.ENABLE SUBSTITUTION
.1000: .IFT PROG .GOTO 2000
.GOTO 12
;%^

.12: ; Building 'TASK'
PIP 'TASK'.TSK;*/DE
.OPEN X.RAT
.DISABLE SUBSTITUTION
.ENABLE DATA
DEFINE	DATFIL	'X.DAT'
DEFINE	CMDFIL	'X.CMD'
DEFINE	OUTFIL	'X.RNO'
DEFINE	INPUT	1
DEFINE	OUTPUT	2
DEFINE	TYPER	5
DEFINE	MAXBUF	120
DEFINE	STARTCODE '+'
DEFINE	ENDCODE	'-'
DEFINE	TAB	"11
DEFINE	COL	3
DEFINE	COLP1	4
DEFINE	FILTYPE	'GDE'
#
1  FORMAT (Q,MAXBUF A1)
#
BYTE BUFFER(MAXBUF), BUF2(COLP1), BEXT(4)
EQUIVALENCE (EXTN,BEXT)
DATA EXTN /FILTYPE/
#
OPEN (UNIT=INPUT,NAME=DATFIL,TYPE='OLD',READONLY)
READ (INPUT,1) N,BUFFER
CLOSE (UNIT=INPUT)
#
REPEAT  [
     BUFFER (MIN(N+1,MAXBUF)) = 0
     OPEN (UNIT=INPUT,NAME=BUFFER,TYPE='OLD',READONLY,ERR=100)
     BREAK
     100  WRITE (TYPER,110);  110 FORMAT ('$OPEN ERROR -- GIVE FILENAME>')
     READ (TYPER,1,END=9999) N,BUFFER
]  # UNTIL NO.ERROR
#%^
OPEN (UNIT=OUTPUT,NAME=CMDFIL,TYPE='NEW',CARRIAGECONTROL='LIST')
FOR (I=1; I<=N && BUFFER(I)^='.'; I=I+1)
     ;
DO J = 1,3  [ I = I + 1;  BUFFER(I) = BEXT(J) ]
I = I + 1;  BUFFER(I) = '"';  N = I
WRITE (OUTPUT,200) (BUFFER(I), I=1,N)
200  FORMAT ('.SETS $NAME "',100A1)
CLOSE (UNIT=OUTPUT)
#
OPEN (UNIT=OUTPUT,NAME=OUTFIL,TYPE='NEW',CARRIAGECONTROL='LIST')
REPEAT  [
     READ (INPUT,1,END=1000) N,BUF2
     IF (N==COL && BUF2(COL)==STARTCODE)
          REPEAT  [
               READ (INPUT,1,END=1000) N, (BUFFER(I), I=1,N)
               IF (N==COL && BUFFER(COL)==ENDCODE) BREAK
               IF (N<<COL) CALL PUT (' ',1)
               ELSE  [
                    FOR (I=1; I<<COL && BUFFER(I)^=TAB; I=I+1)
                         ;
                    CALL PUT (BUFFER(I), N-I+1)
               ]
          ]
]  1000  # UNTIL END.OF.FILE
CLOSE (UNIT=OUTPUT)
9999  STOP '-- FINISHED'
END
#%^
SUBROUTINE PUT (BUFFER,N)
#
	BYTE BUFFER(N)
	INTEGER N
#
WRITE (OUTPUT,10) BUFFER;  10 FORMAT (MAXBUF A1)
RETURN
END
.DISABLE DATA
.CLOSE
.GOTO 13
;%^

.13: .ENABLE SUBSTITUTION
.OPEN X.BLD
.ENABLE DATA
'TASK'=X
/
LIBR=F4PRES:RO
//
.DISABLE DATA
.CLOSE
RAT X=X
F4P X=X
TKB @X.BLD
PIP X.*;*/DE
.GOTO 2000
;%^
.2000: .SETS NUL ""
.LOOP: .ASKS FILE GIVE FILE TO BE PROCESSED
     .IF FILE = NUL .GOTO DONE
     .OPEN X.DAT
     .DATA 'FILE'
     .CLOSE
     RUN 'TASK'
     .2100: .IFNINS 'TASK' .GOTO 2100
     .IFINS 'TASK' .WAIT 'TASK'
     .IFNDF  $NOMRG  .GOTO 2200
          .IFT $NOMRG .GOTO EXIT
     .2200: @X
     PIP '$NAME';*/DE
     PIP '$NAME'='MACFIL',X.RNO
     PIP X.*;*/DE
     @RNO
.GOTO LOOP
.DONE: PIP 'MACFIL';*/DE
.EXIT:
