.GOTO 1
 
	This module returns the contents of $SUBn in the variable
$PROGN, where n is the value of $NSUB.  In effect, it returns an
array element.  It is used by CLG to permit the user to pass a
list of programs to be compiled.  The table must be filled from
the beginning to avoid undefined variables.  The routines are
compiled in reverse order.  $NSUB is decreased by 1 before returning.
 
VARIABLES
 
NAME	TYPE	EXAMPLE			DESCRIPTION
 
$NSUB	NUMERIC	.SETN $NSUB 2.		Number of modules to be compiled.
					-- decreased after each call.
$SUBn	STRING	.SETS $SUB1 "FRED"	Name of module number n.
$PROGN	STRING				Name of module $NSUB
					-- returned by SUBTAB
 
.1: .SETN 1 1
.SETN 2 2.
.SETN 3 3.
.SETN 4 4.
.SETN 5 5.
.SETN 6 6.
.SETN 7 7.
.SETN 8 8.
.SETN 9 9.
.SETN 10 10.
.ENABLE SUBSTITUTION
.GOTO BEGIN
;%^


.BEGIN: .IF $NSUB <> 1 .GOTO 2
     .SETS $PROGN "'$SUB1'"
     .GOTO END
.2: .IF $NSUB <> 2 .GOTO 3
     .SETS $PROGN "'$SUB2'"
     .GOTO END
.3: .IF $NSUB <> 3 .GOTO 4
     .SETS $PROGN "'$SUB3'"
     .GOTO END
.4: .IF $NSUB <> 4 .GOTO 5
     .SETS $PROGN "'$SUB4'"
     .GOTO END
.5: .IF $NSUB <> 5 .GOTO 6
     .SETS $PROGN "'$SUB5'"
     .GOTO END
.6: .IF $NSUB <> 6 .GOTO 7
     .SETS $PROGN "'$SUB6'"
     .GOTO END
.7: .IF $NSUB <> 7 .GOTO 8
     .SETS $PROGN "'$SUB7'"
     .GOTO END
.8: .IF $NSUB <> 8 .GOTO 9
     .SETS $PROGN "'$SUB8'"
     .GOTO END
.9: .IF $NSUB <> 9 .GOTO 10
     .SETS $PROGN "'$SUB9'"
     .GOTO END
.10: .IF $NSUB <> 10 .GOTO ERROR
     .SETS $PROGN "'$SUB10'"
     .GOTO END
.ERROR: ; SUBOUTINE NUMBER INVALID -- MUST BE BETWEEN 1 AND 10
     ; NUMBER SET TO 10
     .SETN $NSUB 10
     .GOTO BEGIN
.END: .DEC $NSUB
