; FILE CLG
.GOTO 1
 
COMPILE-LOAD-GO PROCEDURE
 
	This indirect MCR command file provides a generalized compile,
task-build and run facility for users of the Dynamic Analysis Facility.
It is described in the user's guide A-RCB-xxxx-SP-y.  For the
unfamiliar user, CLG contains extensive descriptive material.  It is controlled
by a number of global variables which may be set by a higher-level
user command file, or by interaction with CLG.  These variables
are tabulated below, in the order in which they are requested by CLG.
 
VARIABLES
 
NAME	TYPE	EXAMPLE			DESCRIPTION
 
$KNOWS	LOGICAL	.SETT $KNOWS		True to turn off help messages.
$TASK	STRING	.SETS $TASK "taskname"	Name of task, including main
					program and BLD file.
$TYPE	STRING	.SETS $TYPE "RAT"	Type of source programs.
$B	STRING	.SETS $B "1"		Disk for OBJ files.
$T	STRING	.SETS $T "1"		Disk for TSK, LST and MAP files.
$NEW	LOGICAL	.SETF $NEW		True to compile main and create
					new BLD file.
$LST	LOGICAL	.SETT $LST		True to LST modules compiled.
$RUN	LOGICAL	.SETT $RUN		True to RUN after building.
;%^

OPTIONAL VARIABLES
 
NAME	TYPE	EXAMPLE			DESCRIPTION
 
$S	STRING	.SETS $S "1"		Disk for source files
					-- defaults to 1
$NSUB	NUMERIC	.SETN $NSUB 2.		Number of modules to compile.
					-- must be <= 10.
$SUBn	STRING	.SETS $SUB1 "FRED"	Name of subroutine to compile
					-- must be defined for n between
					   1 and $NSUB
$NOBLD	LOGICAL	.SETT $NOBLD		True to prevent building.
 
 
.1: .SETN ZERO 0
.SETS HELP "?"
.IFNDF $KNOWS .ASK $KNOWS ARE YOU FAMILIAR WITH THIS FINE PROGRAM
.IFT $KNOWS .GOTO 10
     ;
     ;     This command file will Compile, Load and Go (run) any
     ; RATFOR, FORTRAN or MACRO program or set of programs.
     ;     When CLG asks a question, it indicates the type of
     ; response desired in brackets as follows:
     ;     [Y/N] -- Y for yes; N or <cr> for no.
     ;     [S]   -- String of up to 16 letters.
     ;     [N]   -- Number between 0 and 255.
     ;
     ;     If something goes wrong, don't panic.  Just answer with
     ; <cr> to each question and CLG will exit with no disastrous
     ; consequences.
.10: .IFDF $TASK .GOTO 30
     .IFT $KNOWS .GOTO 20
.15: ;
     ;     First, give the task name.  This is the name used
     ; for the main program, task builder .BLD file, and task
     ; image.
     .20: .ASKS $TASK GIVE TASK NAME
     .IF $TASK = HELP .GOTO 15
.30: @[1,1]GTYPE
.GOTO 41
;%^

.41: .IFNDF $S .SETS $S "1"
.IFDF  $B .GOTO 70
     .IFT $KNOWS .GOTO 50
     ;     If desired, CLG will place all OBJ files on DK2.
     .50: .ASK X OBJ FILES ON DK2
     .IFF X .SETS $B "1"
     .IFT X .SETS $B "2"
.70: .IFDF  $T .GOTO 100
     .IFT $KNOWS .GOTO 80
     ;     If desired, CLG will place TSK, LST and MAP files on DK2.
     .80: .ASK X TSK, LST AND MAP FILES ON DK2
     .IFF X .SETS $T "1"
     .IFT X .SETS $T "2"
.100: .ENABLE SUBSTITUTION
.IFDF $NEW .GOTO 120
     .IFT $KNOWS .GOTO 110
     ;
     ;     If desired, CLG will create a command file for TKB with
     ; the extension ".BLD".  this file will contain '$TASK'
     ; and any subroutines specified later.  It will
     ; also specify "DK'$B'" for OBJ files and "DK'$T'" 
     ; for TSK and MAP files.  The file will
     ; be listed on the terminal before the build.  If special
     ; libraries or subroutines of another type are desired,
     ; the build should be rejected and the .BLD file edited
     ; before proceeding.
     ;     Note that requesting a new .BLD file automatically causes
     ; compilation of '$TASK'.
     .110: .ASK $NEW NEW BLD FILE
.120: .GOTO 121
;%^

.121: .SETS NUL ""
.IFF $NEW .GOTO 150
     .SETS $PROGN "'$TASK'"
     ;
     ; COMPILING '$TASK'
     @[1,1]COMPIL
     PIP DK'$S':'$TASK'.BLD;*/DE
     PIP CLG.TMP;*/DE
     .OPEN CLG.TMP
     .DATA ;
     .DATA DK'$T':'$TASK',DK'$T':'$TASK'/SH/-SP=DK'$B':'$TASK'
     .CLOSE
.150: .GOTO 151
;%^

.151: .IFT $KNOWS .GOTO LOOP
.155: .IFF $NEW .GOTO 160
          ;
          ;     '$TASK' has already been compiled.  The following
          ; prompt asks for a subroutine to be used.  It
          ; will be compiled and added to the .BLD file.
          ; The prompt will be repeated until answered with a
          ; <cr>.
          .GOTO 170
     .160:
          ;     The following prompt asks for any program to be
          ; compiled.  The response may be '$TASK' or a
          ; subroutine.  The prompt will be repeated until the
          ; answer is <cr>.
     .170: .IF $TYPE <> $RATN .GOTO LOOP
          ;     The RATFOR listings will be created with
          ; the names subr.LST and the FORTRAN listings will
          ; be called subr.LXT.
.LOOP: .IFDF $NSUB .GOTO 180
          .ASKS $PROGN GIVE '$TYPE' MODULE
          .IF $PROGN = HELP .GOTO 155
          .IF $PROGN = NUL .GOTO DONE
          .GOTO 190
     .180: .IF $NSUB <= ZERO .GOTO DONE
          @[1,1]SUBTAB
     .190: @[1,1]COMPIL
     .IFF $NEW .GOTO 200
          .OPEN X.TMP
          .DATA DK'$B':'$PROGN'
          .CLOSE
          PIP CLG.TMP=CLG.TMP,X.TMP
.200: .GOTO LOOP
.DONE: .GOTO 211
;%^

.211: .IFF $NEW .GOTO BUILD
     .OPEN X.TMP
     .DATA /
     .DATA LIBR=F4PRES:RO
     .DATA //
     .CLOSE
     PIP DK'$S':'$TASK'.BLD;1=CLG.TMP,X.TMP
     PIP CLG.TMP;*,X.TMP;*/DE
     .IFT $KNOWS .GOTO 300
          ;
          ;     Here is the .BLD file for TKB.
     .300: PIP TI:=DK'$S':'$TASK'.BLD;1
.BUILD: .IFNDF $NOBLD .SETF $NOBLD
.IFT $NOBLD .GOTO END
.IFT $KNOWS .GOTO 400
     ;     If there have been no compilation errors, and the
     ; .BLD file is complete, you should answer Y to the next
     ; question.
.400: .ASK X OK TO BUILD
.IFF X .GOTO END
     PIP DK'$T':'$TASK'.TSK;*,DK'$T':'$TASK'.MAP;*/DE
     PIP DK'$B':*.OBJ/PU
     PIP DK'$T':*.LXT;*/DE
     TKB @DK'$S':'$TASK'.BLD
     .IFNDF $RUN .GOTO 500
          .SETF X
          .IFT $RUN .SETT X
          .GOTO 1000
     .500: .IFT $KNOWS .GOTO 600
          ;
          ;     If you wish, CLG will initiate a run of
          ; '$TASK'.
     .600:.ASK X OK TO RUN
     .1000: .IFT X RUN DK'$T':'$TASK'
.END: ; END OF CLG
