 
(*$C+,T-,D-,L-*)
 (**********************************************
  *                                            *
  *                                            *
  *         PORTABLE PASCAL COMPILER           *
  *         ************************           *
  *                                            *
  *                PASCAL P4                   *
  *                                            *
  *                                            *
  *     AUTHORS:                               *
  *              URS AMMANN                    *
  *              KESAV NORI                    *
  *              CHRISTIAN JACOBI              *
  *                                            *
  *     ADDRESS:                               *
  *                                            *
  *          INSTITUT FUER INFORMATIK          *
  *          EIDG. TECHNISCHE HOCHSCHULE       *
  *          CH-8096 ZUERICH                   *
  *                                            *
  *                                            *
  *     LAST CHANGES COMPLETED IN MAY 76       *
  *                                            *
  *                                            *
  **********************************************)
 
 
PROGRAM PASCALCOMPILER(INPUT,OUTPUT,PRR);
 
 
 
CONST DISPLIMIT = 20; MAXLEVEL = 10;
   INTSIZE          =          1;
   INTAL            =          1;
   REALSIZE         =          2;
   REALAL           =          1;
   CHARSIZE         =          1;
   CHARAL           =          1;
   CHARMAX          =          1;
   BOOLSIZE         =          1;
   BOOLAL           =          1;
   PTRSIZE          =          1;
   ADRAL            =          1;
   SETSIZE          =          4;
   SETAL            =          1;
   STACKAL          =          1;
   STACKELSIZE      =          1;
   STRGLGTH         =         12;
   SETHIGH          =         63;
   SETLOW           =          0;
   ORDMAXCHAR       =        127;
   ORDMINCHAR       =          0;
   MAXINT           =      32767;
   LCAFTERMARKSTACK =          6;
      FILEAL = CHARAL;
   (* STACKELSIZE = MINIMUM SIZE FOR 1 STACKELEMENT
                  = K*STACKAL
      STACKAL     = SCM(ALL OTHER AL-CONSTANTS)
      CHARMAX     = SCM(CHARSIZE,CHARAL)
                    SCM = SMALLEST COMMON MULTIPLE
      LCAFTERMARKSTACK >= 4*PTRSIZE+MAX(X-SIZE)
                       = K1*STACKELSIZE          *)
      MAXSTACK = 1;
      PARMAL = STACKAL;
      PARMSIZE = STACKELSIZE;
      RECAL = STACKAL;
      FILEBUFFER = 4;
      MAXADDR = MAXINT;
 
 
 
TYPE                                                        (*DESCRIBING:*)
                                                            (*************)
 
 
                                                            (*BASIC SYMBOLS*)
                                                            (***************)
 
     SYMBOL = (IDENT,INTCONST,REALCONST,STRINGCONST,NOTSY,MULOP,ADDOP,RELOP,
               LPARENT,RPARENT,LBRACK,RBRACK,COMMA,SEMICOLON,PERIOD,ARROW,
               COLON,BECOMES,LABELSY,CONSTSY,TYPESY,VARSY,FUNCSY,PROGSY,
               PROCSY,SETSY,PACKEDSY,ARRAYSY,RECORDSY,FILESY,FORWARDSY,
               BEGINSY,IFSY,CASESY,REPEATSY,WHILESY,FORSY,WITHSY,
               GOTOSY,ENDSY,ELSESY,UNTILSY,OFSY,DOSY,TOSY,DOWNTOSY,
               THENSY,OTHERSY);
     OPERATOR = (MUL,RDIV,ANDOP,IDIV,IMOD,PLUS,MINUS,OROP,LTOP,LEOP,GEOP,GTOP,
                 NEOP,EQOP,INOP,NOOP);
     SETOFSYS = SET OF SYMBOL;
     CHTP = (LETTER,NUMBER,SPECIAL,ILLEGAL);
 
                                                            (*CONSTANTS*)
                                                            (***********)
 
     CSTCLASS = (REEL,PSET,STRG);
     CSP = ^ CONSTANT;
     CONSTANT = RECORD CASE CCLASS: CSTCLASS OF
                         REEL: (RVAL: PACKED ARRAY [1..STRGLGTH] OF CHAR);
                         PSET: (PVAL: SET OF 0..58);
                         STRG: (SLGTH: 0..STRGLGTH;
                                SVAL: PACKED ARRAY [1..STRGLGTH] OF CHAR)
                       END;
 
     VALU = RECORD CASE INTVAL: BOOLEAN OF  (*INTVAL NEVER SET NORE TESTED*)
                     TRUE:  (IVAL: INTEGER);
                     FALSE: (VALP: CSP)
                   END;
 
                                                           (*DATA STRUCTURES*)
                                                           (*****************)
     LEVRANGE = 0..MAXLEVEL; ADDRRANGE = 0..MAXADDR;
     STRUCTFORM = (SCALAR,SUBRANGE,POINTER,POWER,ARRAYS,RECORDS,FILES,
                   TAGFLD,VARIANT);
     DECLKIND = (STANDARD,DECLARED);
     STP = ^ STRUCTURE; CTP = ^ IDENTIFIER;
 
     STRUCTURE = PACKED RECORD
                   MARKED: BOOLEAN;   (*FOR TEST PHASE ONLY*)
                   SIZE: ADDRRANGE;
                   CASE FORM: STRUCTFORM OF
                     SCALAR:   (CASE SCALKIND: DECLKIND OF
                                  DECLARED: (FCONST: CTP));
                     SUBRANGE: (RANGETYPE: STP; MIN,MAX: VALU);
                     POINTER:  (ELTYPE: STP);
                     POWER:    (ELSET: STP);
                     ARRAYS:   (AELTYPE,INXTYPE: STP);
                     RECORDS:  (FSTFLD: CTP; RECVAR: STP);
                     FILES:    (FILTYPE: STP);
                     TAGFLD:   (TAGFIELDP: CTP; FSTVAR: STP);
                     VARIANT:  (NXTVAR,SUBVAR: STP; VARVAL: VALU)
                   END;
 
                                                            (*NAMES*)
                                                            (*******)
 
     IDCLASS = (TYPES,KONST,VARS,FIELD,PROC,FUNC);
     SETOFIDS = SET OF IDCLASS;
     IDKIND = (ACTUAL,FORMAL);
     ALPHA = PACKED ARRAY [1..8] OF CHAR;
 
     IDENTIFIER = PACKED RECORD
                   NAME: ALPHA; LLINK, RLINK: CTP;
                   IDTYPE: STP; NEXT: CTP;
                   CASE KLASS: IDCLASS OF
                     KONST: (VALUES: VALU);
                     VARS:  (VKIND: IDKIND; VLEV: LEVRANGE; VADDR: ADDRRANGE);
                     FIELD: (FLDADDR: ADDRRANGE);
                     PROC,
                     FUNC:  (CASE PFDECKIND: DECLKIND OF
                              STANDARD: (KEY: 1..15);
                              DECLARED: (PFLEV: LEVRANGE; PFNAME: INTEGER;
                                          CASE PFKIND: IDKIND OF
                                           ACTUAL: (FORWDECL, EXTERN:
                                                    BOOLEAN)))
                   END;
 
 
     DISPRANGE = 0..DISPLIMIT;
     WHERE = (BLCK,CREC,VREC,REC);
 
                                                            (*EXPRESSIONS*)
                                                            (*************)
     ATTRKIND = (CST,VARBL,EXPR);
     VACCESS = (DRCT,INDRCT,INXD);
 
     ATTR = RECORD TYPTR: STP;
              CASE KIND: ATTRKIND OF
                CST:   (CVAL: VALU);
                VARBL: (CASE ACCESS: VACCESS OF
                          DRCT: (VLEVEL: LEVRANGE; DPLMT: ADDRRANGE);
                          INDRCT: (IDPLMT: ADDRRANGE))
              END;
 
     TESTP = ^ TESTPOINTER;
     TESTPOINTER = PACKED RECORD
                     ELT1,ELT2 : STP;
                     LASTTESTP : TESTP
                   END;
 
                                                                 (*LABELS*)
                                                                 (********)
     LBP = ^ LABL;
     LABL = RECORD NEXTLAB: LBP; DEFINED: BOOLEAN;
                   LABVAL, LABNAME: INTEGER
            END;
 
     EXTFILEP = ^FILEREC;
     FILEREC = RECORD FILENAME:ALPHA; NEXTFILE:EXTFILEP END;
 
(*-------------------------------------------------------------------------*)
 
 
VAR
                                    (*RETURNED BY SOURCE PROGRAM SCANNER
                                     INSYMBOL:
                                     **********)
 
    SY: SYMBOL;                     (*LAST SYMBOL*)
    OP: OPERATOR;                   (*CLASSIFICATION OF LAST SYMBOL*)
    VAL: VALU;                      (*VALUE OF LAST CONSTANT*)
    LGTH: INTEGER;                  (*LENGTH OF LAST STRING CONSTANT*)
    ID: ALPHA;                      (*LAST IDENTIFIER (POSSIBLY TRUNCATED)*)
    KK: 1..8;                       (*NR OF CHARS IN LAST IDENTIFIER*)
    CH: CHAR;                       (*LAST CHARACTER*)
    EOL: BOOLEAN;                   (*END OF LINE FLAG*)
 
 
                                    (*COUNTERS:*)
                                    (***********)
 
    CHCNT: INTEGER;                 (*CHARACTER COUNTER*)
    LC,IC: ADDRRANGE;               (*DATA LOCATION AND INSTRUCTION COUNTER*)
    LINECOUNT: INTEGER;
 
 
                                    (*SWITCHES:*)
                                    (***********)
 
    DP,                             (*DECLARATION PART*)
    PRTERR,                     (*TO ALLOW FORWARD REFERENCES IN POINTER TYPE
                                  DECLARATION BY SUPPRESSING ERROR MESSAGE*)
    LIST,PRCODE,PRTABLES: BOOLEAN;  (*OUTPUT OPTIONS FOR
                                        -- SOURCE PROGRAM LISTING
                                        -- PRINTING SYMBOLIC CODE
                                        -- DISPLAYING IDENT AND STRUCT TABLES
                                        --> PROCEDURE OPTION*)
    DEBUG: BOOLEAN;
 
 
                                    (*POINTERS:*)
                                    (***********)
    PARMPTR,
    INTPTR,REALPTR,CHARPTR,
    BOOLPTR,NILPTR,TEXTPTR: STP;    (*POINTERS TO ENTRIES OF STANDARD IDS*)
    UTYPPTR,UCSTPTR,UVARPTR,
    UFLDPTR,UPRCPTR,UFCTPTR,        (*POINTERS TO ENTRIES FOR UNDECLARED IDS*)
    FWPTR: CTP;                     (*HEAD OF CHAIN OF FORW DECL TYPE IDS*)
    FEXTFILEP: EXTFILEP;            (*HEAD OF CHAIN OF EXTERNAL FILES*)
    GLOBTESTP: TESTP;                (*LAST TESTPOINTER*)
 
 
                                    (*BOOKKEEPING OF DECLARATION LEVELS:*)
                                    (************************************)
 
    LEVEL: LEVRANGE;                (*CURRENT STATIC LEVEL*)
    DISX,                           (*LEVEL OF LAST ID SEARCHED BY SEARCHID*)
    TOP: DISPRANGE;                 (*TOP OF DISPLAY*)
 
    DISPLAY:                        (*WHERE:   MEANS:*)
      ARRAY [DISPRANGE] OF
        PACKED RECORD               (*=BLCK:   ID IS VARIABLE ID*)
          FNAME: CTP; FLABEL: LBP;  (*=CREC:   ID IS FIELD ID IN RECORD WITH*)
          CASE OCCUR: WHERE OF      (*         CONSTANT ADDRESS*)
            CREC: (CLEV: LEVRANGE;  (*=VREC:   ID IS FIELD ID IN RECORD WITH*)
                  CDSPL: ADDRRANGE);(*         VARIABLE ADDRESS*)
            VREC: (VDSPL: ADDRRANGE)
          END;                      (* --> PROCEDURE WITHSTATEMENT*)
 
 
                                    (*ERROR MESSAGES:*)
                                    (*****************)
 
    ERRINX: 0..10;                  (*NR OF ERRORS IN CURRENT SOURCE LINE*)
    ERRLIST:
      ARRAY [1..10] OF
        PACKED RECORD POS: INTEGER;
                      NMR: 1..400
               END;
 
 
 
 
                                    (*EXPRESSION COMPILATION:*)
                                    (*************************)
 
    GATTR: ATTR;                    (*DESCRIBES THE EXPR CURRENTLY COMPILED*)
 
 
                                    (*STRUCTURED CONSTANTS:*)
                                    (***********************)
 
    CONSTBEGSYS,SIMPTYPEBEGSYS,TYPEBEGSYS,BLOCKBEGSYS,SELECTSYS,FACBEGSYS,
    STATBEGSYS,TYPEDELS: SETOFSYS;
    CHARTP : ARRAY[CHAR] OF CHTP;
    RW:  ARRAY [1..35(*NR. OF RES. WORDS*)] OF ALPHA;
    FRW: ARRAY [1..9] OF 1..36(*NR. OF RES. WORDS + 1*);
    RSY: ARRAY [1..35(*NR. OF RES. WORDS*)] OF SYMBOL;
   SSY: ARRAY [CHAR] OF SYMBOL;
    ROP: ARRAY [1..35(*NR. OF RES. WORDS*)] OF OPERATOR;
   SOP: ARRAY [CHAR] OF OPERATOR;
    NA:  ARRAY [1..35] OF ALPHA;
    MN:  ARRAY[0..60] OF PACKED ARRAY[1..4] OF CHAR;
    SNA: ARRAY [1..23] OF PACKED ARRAY [1..4] OF CHAR;
    CDX: ARRAY[0..60] OF -4..+4;
    PDX: ARRAY[1..23] OF -7..+7;
    ORDINT: ARRAY[CHAR] OF INTEGER;
 
    INTLABEL,MXINT10,DIGMAX: INTEGER;
 
(*-------------------------------------------------------------------------*)
 
 
PROCEDURE ENDOFLINE;
    VAR LASTPOS,FREEPOS,CURRPOS,CURRNMR,F,K: INTEGER;
  BEGIN
    IF ERRINX > 0 THEN   (*OUTPUT ERROR MESSAGES*)
      BEGIN WRITE(OUTPUT,' ****  ':15);
        LASTPOS := 0; FREEPOS := 1;
        FOR K := 1 TO ERRINX DO
          BEGIN
            WITH ERRLIST[K] DO
              BEGIN CURRPOS := POS; CURRNMR := NMR END;
            IF CURRPOS = LASTPOS THEN WRITE(OUTPUT,',')
            ELSE
              BEGIN
                WHILE FREEPOS < CURRPOS DO
                  BEGIN WRITE(OUTPUT,' '); FREEPOS := FREEPOS + 1 END;
                WRITE(OUTPUT,'^');
                LASTPOS := CURRPOS
              END;
            IF CURRNMR < 10 THEN F := 1
            ELSE IF CURRNMR < 100 THEN F := 2
              ELSE F := 3;
            WRITE(OUTPUT,CURRNMR:F);
            FREEPOS := FREEPOS + F + 1
          END;
        WRITELN(OUTPUT); ERRINX := 0
      END;
    IF LIST AND (NOT EOF(INPUT)) THEN
      BEGIN LINECOUNT := LINECOUNT + 1; WRITE(OUTPUT,LINECOUNT:6,'  ':2);
        IF DP THEN WRITE(OUTPUT,LC:7) ELSE WRITE(OUTPUT,IC:7);
        WRITE(OUTPUT,' ')
      END;
    CHCNT := 0
  END  (*ENDOFLINE*) ;
 
  PROCEDURE ERROR(FERRNR: INTEGER);
  BEGIN
    IF ERRINX >= 9 THEN
      BEGIN ERRLIST[10].NMR := 255; ERRINX := 10 END
    ELSE
      BEGIN ERRINX := ERRINX + 1;
        ERRLIST[ERRINX].NMR := FERRNR
      END;
    ERRLIST[ERRINX].POS := CHCNT
  END (*ERROR*) ;
 
  PROCEDURE INSYMBOL;
    (*READ NEXT BASIC SYMBOL OF SOURCE PROGRAM AND RETURN ITS
    DESCRIPTION IN THE GLOBAL VARIABLES SY, OP, ID, VAL AND LGTH*)
    LABEL 1,2,3;
    VAR I,K: INTEGER;
        DIGIT: PACKED ARRAY [1..STRGLGTH] OF CHAR;
        STRING: PACKED ARRAY [1..STRGLGTH] OF CHAR;
        LVP: CSP;TEST: BOOLEAN;
 
    PROCEDURE NEXTCH;
    BEGIN IF EOL THEN
      BEGIN IF LIST THEN WRITELN(OUTPUT); ENDOFLINE
      END;
      IF NOT EOF(INPUT) THEN
       BEGIN EOL := EOLN(INPUT); READ(INPUT,CH);
        IF LIST THEN WRITE(OUTPUT,CH);
        CHCNT := CHCNT + 1
       END
      ELSE
        BEGIN WRITELN(OUTPUT,'   *** EOF ','ENCOUNTERED');
          TEST := FALSE
        END
    END;
 
    PROCEDURE OPTIONS;
    BEGIN
      REPEAT NEXTCH;
        IF CH <> '*' THEN
          BEGIN
            IF CH = 'T' THEN
              BEGIN NEXTCH; PRTABLES := CH = '+' END
            ELSE
              IF CH = 'L' THEN
                BEGIN NEXTCH; LIST := CH = '+';
                  IF NOT LIST THEN WRITELN(OUTPUT)
                END
              ELSE
             IF CH = 'D' THEN
               BEGIN NEXTCH; DEBUG := CH = '+' END
             ELSE
                IF CH = 'C' THEN
                  BEGIN NEXTCH; PRCODE := CH = '+' END;
            NEXTCH
          END
      UNTIL CH <> ','
    END (*OPTIONS*) ;
 
  BEGIN (*INSYMBOL*)
  1:
    REPEAT WHILE (CH = ' ') AND NOT EOL DO NEXTCH;
      TEST := EOL;
      IF TEST THEN NEXTCH
    UNTIL NOT TEST;
    IF CHARTP[CH] = ILLEGAL THEN
      BEGIN SY := OTHERSY; OP := NOOP;
        ERROR(399); NEXTCH
      END
    ELSE
    CASE CH OF
      'A','B','C','D','E','F','G','H','I',
      'J','K','L','M','N','O','P','Q','R',
      'S','T','U','V','W','X','Y','Z':
        BEGIN K := 0;
          REPEAT
            IF K < 8 THEN
             BEGIN K := K + 1; ID[K] := CH END ;
            NEXTCH
           UNTIL CHARTP[CH] IN [SPECIAL,ILLEGAL];
          IF K >= KK THEN KK := K
          ELSE
            REPEAT ID[KK] := ' '; KK := KK - 1
            UNTIL KK = K;
          FOR I := FRW[K] TO FRW[K+1] - 1 DO
            IF RW[I] = ID THEN
              BEGIN SY := RSY[I]; OP := ROP[I]; GOTO 2 END;
            SY := IDENT; OP := NOOP;
  2:    END;
      '0','1','2','3','4','5','6','7','8','9':
        BEGIN OP := NOOP; I := 0;
          REPEAT I := I+1; IF I<= DIGMAX THEN DIGIT[I] := CH; NEXTCH
          UNTIL CHARTP[CH] <> NUMBER;
          IF (CH = '.') OR (CH = 'E') THEN
            BEGIN
                  K := I;
                  IF CH = '.' THEN
                    BEGIN K := K+1; IF K <= DIGMAX THEN DIGIT[K] := CH;
                      NEXTCH; IF CH = '.' THEN BEGIN CH := ':'; GOTO 3 END;
                      IF CHARTP[CH] <> NUMBER THEN ERROR(201)
                      ELSE
                        REPEAT K := K + 1;
                          IF K <= DIGMAX THEN DIGIT[K] := CH; NEXTCH
                        UNTIL CHARTP[CH] <>  NUMBER
                    END;
                  IF CH = 'E' THEN
                    BEGIN K := K+1; IF K <= DIGMAX THEN DIGIT[K] := CH;
                      NEXTCH;
                      IF (CH = '+') OR (CH ='-') THEN
                        BEGIN K := K+1; IF K <= DIGMAX THEN DIGIT[K] := CH;
                          NEXTCH
                        END;
                      IF CHARTP[CH] <> NUMBER THEN ERROR(201)
                      ELSE
                        REPEAT K := K+1;
                          IF K <= DIGMAX THEN DIGIT[K] := CH; NEXTCH
                        UNTIL CHARTP[CH] <> NUMBER
                     END;
                   NEW(LVP,REEL); SY:= REALCONST; LVP^.CCLASS := REEL;
                   WITH LVP^ DO
                     BEGIN FOR I := 1 TO STRGLGTH DO RVAL[I] := ' ';
                       IF K <= DIGMAX THEN
                         FOR I := 2 TO K + 1 DO RVAL[I] := DIGIT[I-1]
                       ELSE BEGIN ERROR(203); RVAL[2] := '0';
                              RVAL[3] := '.'; RVAL[4] := '0'
                            END
                     END;
                   VAL.VALP := LVP
            END
          ELSE
  3:        BEGIN
              IF I > DIGMAX THEN BEGIN ERROR(203); VAL.IVAL := 0 END
              ELSE
                WITH VAL DO
                  BEGIN IVAL := 0;
                    FOR K := 1 TO I DO
                      BEGIN
                        IF IVAL <= MXINT10 THEN
                          IVAL := IVAL*10+ORDINT[DIGIT[K]]
                        ELSE BEGIN ERROR(203); IVAL := 0 END
                      END;
                    SY := INTCONST
                 END
            END
        END;
      '''':
        BEGIN LGTH := 0; SY := STRINGCONST;  OP := NOOP;
          REPEAT
            REPEAT NEXTCH; LGTH := LGTH + 1;
                   IF LGTH <= STRGLGTH THEN STRING[LGTH] := CH
            UNTIL (EOL) OR (CH = '''');
            IF EOL THEN ERROR(202) ELSE NEXTCH
          UNTIL CH <> '''';
          LGTH := LGTH - 1;   (*NOW LGTH = NR OF CHARS IN STRING*)
          IF LGTH = 1 THEN VAL.IVAL := ORD(STRING[1])
          ELSE
            BEGIN NEW(LVP,STRG); LVP^.CCLASS:=STRG;
              IF LGTH > STRGLGTH THEN
                BEGIN ERROR(399); LGTH := STRGLGTH END;
              WITH LVP^ DO
                BEGIN SLGTH := LGTH;
                  FOR I := 1 TO LGTH DO SVAL[I] := STRING[I]
                END;
              VAL.VALP := LVP
            END
        END;
      ':':
        BEGIN OP := NOOP; NEXTCH;
          IF CH = '=' THEN
            BEGIN SY := BECOMES; NEXTCH END
          ELSE SY := COLON
        END;
      '.':
        BEGIN OP := NOOP; NEXTCH;
          IF CH = '.' THEN
            BEGIN SY := COLON; NEXTCH END
          ELSE SY := PERIOD
        END;
      '<':
        BEGIN NEXTCH; SY := RELOP;
          IF CH = '=' THEN
            BEGIN OP := LEOP; NEXTCH END
          ELSE
            IF CH = '>' THEN
              BEGIN OP := NEOP; NEXTCH END
            ELSE OP := LTOP
        END;
      '>':
        BEGIN NEXTCH; SY := RELOP;
          IF CH = '=' THEN
            BEGIN OP := GEOP; NEXTCH END
          ELSE OP := GTOP
        END;
      '(':
       BEGIN NEXTCH;
         IF CH = '*' THEN
           BEGIN NEXTCH;
             IF CH = '$' THEN OPTIONS;
             REPEAT
               WHILE CH <> '*'  DO NEXTCH;
               NEXTCH
             UNTIL CH = ')';
             NEXTCH; GOTO 1
           END;
         SY := LPARENT; OP := NOOP
       END;
      '*','+','-',
      '=','/',')',
      '[',']',',',';','^','$':
        BEGIN SY := SSY[CH]; OP := SOP[CH];
          NEXTCH
        END;
      ' ': SY := OTHERSY
    END (*CASE*)
  END (*INSYMBOL*) ;
 
  PROCEDURE ENTERID(FCP: CTP);
    (*ENTER ID POINTED AT BY FCP INTO THE NAME-TABLE,
     WHICH ON EACH DECLARATION LEVEL IS ORGANISED AS
     AN UNBALANCED BINARY TREE*)
    VAR NAM: ALPHA; LCP, LCP1: CTP; LLEFT: BOOLEAN;
  BEGIN NAM := FCP^.NAME;
    LCP := DISPLAY[TOP].FNAME;
    IF LCP = NIL THEN
      DISPLAY[TOP].FNAME := FCP
    ELSE
      BEGIN
        REPEAT LCP1 := LCP;
          IF LCP^.NAME = NAM THEN   (*NAME CONFLICT, FOLLOW RIGHT LINK*)
            BEGIN ERROR(101); LCP := LCP^.RLINK; LLEFT := FALSE END
          ELSE
            IF LCP^.NAME < NAM THEN
              BEGIN LCP := LCP^.RLINK; LLEFT := FALSE END
            ELSE BEGIN LCP := LCP^.LLINK; LLEFT := TRUE END
        UNTIL LCP = NIL;
        IF LLEFT THEN LCP1^.LLINK := FCP ELSE LCP1^.RLINK := FCP
      END;
    FCP^.LLINK := NIL; FCP^.RLINK := NIL
  END (*ENTERID*) ;
 
  PROCEDURE SEARCHSECTION(FCP: CTP; VAR FCP1: CTP);
    (*TO FIND RECORD FIELDS AND FORWARD DECLARED PROCEDURE ID'S
     --> PROCEDURE PROCEDUREDECLARATION
     --> PROCEDURE SELECTOR*)
     LABEL 1;
  BEGIN
    WHILE FCP <> NIL DO
      IF FCP^.NAME = ID THEN GOTO 1
      ELSE IF FCP^.NAME < ID THEN FCP := FCP^.RLINK
        ELSE FCP := FCP^.LLINK;
1:  FCP1 := FCP
  END (*SEARCHSECTION*) ;
 
  PROCEDURE SEARCHID(FIDCLS: SETOFIDS; VAR FCP: CTP);
    LABEL 1;
    VAR LCP: CTP;
  BEGIN
    FOR DISX := TOP DOWNTO 0 DO
      BEGIN LCP := DISPLAY[DISX].FNAME;
        WHILE LCP <> NIL DO
          IF LCP^.NAME = ID THEN
            IF LCP^.KLASS IN FIDCLS THEN GOTO 1
            ELSE
              BEGIN IF PRTERR THEN ERROR(103);
                LCP := LCP^.RLINK
              END
          ELSE
            IF LCP^.NAME < ID THEN
              LCP := LCP^.RLINK
            ELSE LCP := LCP^.LLINK
      END;
    (*SEARCH NOT SUCCSESSFUL; SUPPRESS ERROR MESSAGE IN CASE
     OF FORWARD REFERENCED TYPE ID IN POINTER TYPE DEFINITION
     --> PROCEDURE SIMPLETYPE*)
    IF PRTERR THEN
      BEGIN ERROR(104);
        (*TO AVOID RETURNING NIL, REFERENCE AN ENTRY
         FOR AN UNDECLARED ID OF APPROPRIATE CLASS
         --> PROCEDURE ENTERUNDECL*)
        IF TYPES IN FIDCLS THEN LCP := UTYPPTR
        ELSE
          IF VARS IN FIDCLS THEN LCP := UVARPTR
          ELSE
            IF FIELD IN FIDCLS THEN LCP := UFLDPTR
            ELSE
              IF KONST IN FIDCLS THEN LCP := UCSTPTR
              ELSE
                IF PROC IN FIDCLS THEN LCP := UPRCPTR
                ELSE LCP := UFCTPTR;
      END;
1:  FCP := LCP
  END (*SEARCHID*) ;
 
  PROCEDURE GETBOUNDS(FSP: STP; VAR FMIN,FMAX: INTEGER);
    (*GET INTERNAL BOUNDS OF SUBRANGE OR SCALAR TYPE*)
   (*ASSUME FSP<>INTPTR AND FSP<>REALPTR*)
  BEGIN
    FMIN := 0; FMAX := 0;
    IF FSP <> NIL THEN
    WITH FSP^ DO
      IF FORM = SUBRANGE THEN
        BEGIN FMIN := MIN.IVAL; FMAX := MAX.IVAL END
      ELSE
          IF FSP = CHARPTR THEN
            BEGIN FMIN := ORDMINCHAR; FMAX := ORDMAXCHAR
            END
          ELSE
            IF FCONST <> NIL THEN
              FMAX := FCONST^.VALUES.IVAL
  END (*GETBOUNDS*) ;
 
  FUNCTION ALIGNQUOT(FSP: STP): INTEGER;
  BEGIN
    ALIGNQUOT := 1;
    IF FSP <> NIL THEN
      WITH FSP^ DO
        CASE FORM OF
          SCALAR:   IF FSP=INTPTR THEN ALIGNQUOT := INTAL
                    ELSE IF FSP=BOOLPTR THEN ALIGNQUOT := BOOLAL
                    ELSE IF SCALKIND=DECLARED THEN ALIGNQUOT := INTAL
                    ELSE IF FSP=CHARPTR THEN ALIGNQUOT := CHARAL
                    ELSE IF FSP=REALPTR THEN ALIGNQUOT := REALAL
                    ELSE (*PARMPTR*) ALIGNQUOT := PARMAL;
          SUBRANGE: ALIGNQUOT := ALIGNQUOT(RANGETYPE);
          POINTER:  ALIGNQUOT := ADRAL;
          POWER:    ALIGNQUOT := SETAL;
          FILES:    ALIGNQUOT := FILEAL;
          ARRAYS:   ALIGNQUOT := ALIGNQUOT(AELTYPE);
          RECORDS:  ALIGNQUOT := RECAL;
          VARIANT,TAGFLD: ERROR(501)
        END
  END (*ALIGNQUOT*);
 
  PROCEDURE ALIGN(FSP: STP; VAR FLC: INTEGER);
    VAR K,L: INTEGER;
  BEGIN
    K := ALIGNQUOT(FSP);
    L := FLC-1;
    FLC := L+K-(K+L) MOD K
  END (*ALIGN*);
 
  PROCEDURE PRINTTABLES(FB: BOOLEAN);
    (*PRINT DATA STRUCTURE AND NAME TABLE*)
    VAR I, LIM: DISPRANGE;
 
    PROCEDURE MARKER;
      (*MARK DATA STRUCTURE ENTRIES TO AVOID MULTIPLE PRINTOUT*)
      VAR I: INTEGER;
 
      PROCEDURE MARKCTP(FP: CTP); FORWARD;
 
      PROCEDURE MARKSTP(FP: STP);
        (*MARK DATA STRUCTURES, PREVENT CYCLES*)
      BEGIN
        IF FP <> NIL THEN
          WITH FP^ DO
            BEGIN MARKED := TRUE;
              CASE FORM OF
              SCALAR:   ;
              SUBRANGE: MARKSTP(RANGETYPE);
              POINTER:  (*DON'T MARK ELTYPE: CYCLE POSSIBLE; WILL BE MARKED
                        ANYWAY, IF FP = TRUE*) ;
              POWER:    MARKSTP(ELSET) ;
              ARRAYS:   BEGIN MARKSTP(AELTYPE); MARKSTP(INXTYPE) END;
              RECORDS:  BEGIN MARKCTP(FSTFLD); MARKSTP(RECVAR) END;
              FILES:    MARKSTP(FILTYPE);
              TAGFLD:   MARKSTP(FSTVAR);
              VARIANT:  BEGIN MARKSTP(NXTVAR); MARKSTP(SUBVAR) END
              END (*CASE*)
            END (*WITH*)
      END (*MARKSTP*);
 
      PROCEDURE MARKCTP;
      BEGIN
        IF FP <> NIL THEN
          WITH FP^ DO
            BEGIN MARKCTP(LLINK); MARKCTP(RLINK);
              MARKSTP(IDTYPE)
            END
      END (*MARKCTP*);
 
    BEGIN (*MARK*)
      FOR I := TOP DOWNTO LIM DO
        MARKCTP(DISPLAY[I].FNAME)
    END (*MARK*);
 
    PROCEDURE FOLLOWCTP(FP: CTP); FORWARD;
 
    PROCEDURE FOLLOWSTP(FP: STP);
    BEGIN
      IF FP <> NIL THEN
        WITH FP^ DO
          IF MARKED THEN
            BEGIN MARKED := FALSE; WRITE(OUTPUT,' ':4,ORD(FP):6,SIZE:10);
              CASE FORM OF
              SCALAR:   BEGIN WRITE(OUTPUT,'SCALAR':10);
                          IF SCALKIND = STANDARD THEN
                           WRITE(OUTPUT,'STANDARD':10)
                          ELSE WRITE(OUTPUT,'DECLARED':10,' ':4,ORD(FCONST):6);
                          WRITELN(OUTPUT)
                        END;
              SUBRANGE:BEGIN
                        WRITE(OUTPUT,'SUBRANGE':10,' ':4,ORD(RANGETYPE):6);
                            IF RANGETYPE <> REALPTR THEN
                              WRITE(OUTPUT,MIN.IVAL,MAX.IVAL)
                            ELSE
                              IF (MIN.VALP <> NIL) AND (MAX.VALP <> NIL) THEN
                                WRITE(OUTPUT,' ',MIN.VALP^.RVAL:9,
                                      ' ',MAX.VALP^.RVAL:9);
                            WRITELN(OUTPUT); FOLLOWSTP(RANGETYPE);
                          END;
              POINTER:  WRITELN(OUTPUT,'POINTER':10,' ':4,ORD(ELTYPE):6);
              POWER:    BEGIN WRITELN(OUTPUT,'SET':10,' ':4,ORD(ELSET):6);
                            FOLLOWSTP(ELSET)
                          END;
              ARRAYS:   BEGIN
                         WRITELN(OUTPUT,'ARRAY':10,' ':4,ORD(AELTYPE):6,' ':4,
                            ORD(INXTYPE):6);
                            FOLLOWSTP(AELTYPE); FOLLOWSTP(INXTYPE)
                          END;
              RECORDS:  BEGIN
                        WRITELN(OUTPUT,'RECORD':10,' ':4,ORD(FSTFLD):6,' ':4,
                            ORD(RECVAR):6); FOLLOWCTP(FSTFLD);
                            FOLLOWSTP(RECVAR)
                          END;
              FILES:    BEGIN WRITE(OUTPUT,'FILE':10,' ':4,ORD(FILTYPE):6);
                            FOLLOWSTP(FILTYPE)
                          END;
              TAGFLD:   BEGIN WRITELN(OUTPUT,'TAGFLD':10,' ':4,ORD(TAGFIELDP):6,
                            ' ':4,ORD(FSTVAR):6);
                            FOLLOWSTP(FSTVAR)
                          END;
              VARIANT:  BEGIN WRITELN(OUTPUT,'VARIANT':10,' ':4,ORD(NXTVAR):6,
                            ' ':4,ORD(SUBVAR):6,VARVAL.IVAL);
                            FOLLOWSTP(NXTVAR); FOLLOWSTP(SUBVAR)
                          END
              END (*CASE*)
            END (*IF MARKED*)
    END (*FOLLOWSTP*);
 
    PROCEDURE FOLLOWCTP;
      VAR I: INTEGER;
    BEGIN
      IF FP <> NIL THEN
        WITH FP^ DO
          BEGIN WRITE(OUTPUT,' ':4,ORD(FP):6,' ',NAME:9,' ':4,ORD(LLINK):6,
            ' ':4,ORD(RLINK):6,' ':4,ORD(IDTYPE):6);
            CASE KLASS OF
              TYPES: WRITE(OUTPUT,'TYPE':10);
              KONST: BEGIN WRITE(OUTPUT,'CONSTANT':10,' ':4,ORD(NEXT):6);
                     IF IDTYPE <> NIL THEN
                         IF IDTYPE = REALPTR THEN
                           BEGIN
                             IF VALUES.VALP <> NIL THEN
                               WRITE(OUTPUT,' ',VALUES.VALP^.RVAL:9)
                           END
                         ELSE
                           IF IDTYPE^.FORM = ARRAYS THEN  (*STRINGCONST*)
                             BEGIN
                               IF VALUES.VALP <> NIL THEN
                                 BEGIN WRITE(OUTPUT,' ');
                                   WITH VALUES.VALP^ DO
                                     FOR I := 1 TO SLGTH DO
                                      WRITE(OUTPUT,SVAL[I])
                                 END
                             END
                           ELSE WRITE(OUTPUT,VALUES.IVAL)
                       END;
              VARS:  BEGIN WRITE(OUTPUT,'VARIABLE':10);
                        IF VKIND = ACTUAL THEN WRITE(OUTPUT,'ACTUAL':10)
                        ELSE WRITE(OUTPUT,'FORMAL':10);
                        WRITE(OUTPUT,' ':4,ORD(NEXT):6,VLEV,' ':4,VADDR:6 );
                      END;
              FIELD: WRITE(OUTPUT,'FIELD':10,' ':4,ORD(NEXT):6,' ':4,FLDADDR:6);
              PROC,
              FUNC:  BEGIN
                        IF KLASS = PROC THEN WRITE(OUTPUT,'PROCEDURE':10)
                        ELSE WRITE(OUTPUT,'FUNCTION':10);
                        IF PFDECKIND = STANDARD THEN
                         WRITE(OUTPUT,'STANDARD':10,
                          KEY:10)
                        ELSE
                          BEGIN WRITE(OUTPUT,'DECLARED':10,' ':4,ORD(NEXT):6);
                            WRITE(OUTPUT,PFLEV,' ':4,PFNAME:6);
                            IF PFKIND = ACTUAL THEN
                              BEGIN WRITE(OUTPUT,'ACTUAL':10);
                                IF FORWDECL THEN WRITE(OUTPUT,'FORWARD':10)
                                ELSE WRITE(OUTPUT,'NOTFORWARD':10);
                                IF EXTERN THEN WRITE(OUTPUT,'EXTERN':10)
                                ELSE WRITE(OUTPUT,'NOT EXTERN':10);
                              END
                            ELSE WRITE(OUTPUT,'FORMAL':10)
                          END
                     END
            END (*CASE*);
            WRITELN(OUTPUT); FOLLOWCTP(LLINK); FOLLOWCTP(RLINK);
            FOLLOWSTP(IDTYPE)
          END (*WITH*)
    END (*FOLLOWCTP*);
 
  BEGIN (*PRINTTABLES*)
    WRITELN(OUTPUT); WRITELN(OUTPUT); WRITELN(OUTPUT);
    IF FB THEN LIM := 0
    ELSE BEGIN LIM := TOP; WRITE(OUTPUT,' LOCAL') END;
    WRITELN(OUTPUT,' TABLES '); WRITELN(OUTPUT);
    MARKER;
    FOR I := TOP DOWNTO LIM DO
      FOLLOWCTP(DISPLAY[I].FNAME);
      WRITELN(OUTPUT);
      IF NOT EOL THEN WRITE(OUTPUT,' ':CHCNT+16)
  END (*PRINTTABLES*);
 
  PROCEDURE GENLABEL(VAR NXTLAB: INTEGER);
  BEGIN INTLABEL := INTLABEL + 1;
    NXTLAB := INTLABEL
  END (*GENLABEL*);
 
  PROCEDURE BLOCK(FSYS: SETOFSYS; FSY: SYMBOL; FPROCP: CTP);
    VAR LSY: SYMBOL; TEST: BOOLEAN;
 
    PROCEDURE SKIP(FSYS: SETOFSYS);
      (*SKIP INPUT STRING UNTIL RELEVANT SYMBOL FOUND*)
    BEGIN
      IF NOT EOF(INPUT) THEN
        BEGIN WHILE NOT(SY IN FSYS) AND (NOT EOF(INPUT)) DO INSYMBOL;
          IF NOT (SY IN FSYS) THEN INSYMBOL
        END
    END (*SKIP*) ;
 
    PROCEDURE CONSTANT(FSYS: SETOFSYS; VAR FSP: STP; VAR FVALU: VALU);
      VAR LSP: STP; LCP: CTP; SIGN: (NONE,POS,NEG);
          LVP: CSP; I: 2..STRGLGTH;
    BEGIN LSP := NIL; FVALU.IVAL := 0;
      IF NOT(SY IN CONSTBEGSYS) THEN
        BEGIN ERROR(50); SKIP(FSYS+CONSTBEGSYS) END;
      IF SY IN CONSTBEGSYS THEN
        BEGIN
          IF SY = STRINGCONSTSY THEN
            BEGIN
              IF LGTH = 1 THEN LSP := CHARPTR
              ELSE
                BEGIN
                  NEW(LSP,ARRAYS);
                  WITH LSP^ DO
                    BEGIN AELTYPE := CHARPTR; INXTYPE := NIL;
                       SIZE := LGTH*CHARSIZE; FORM := ARRAYS
                    END
                END;
              FVALU := VAL; INSYMBOL
            END
          ELSE
            BEGIN
              SIGN := NONE;
              IF (SY = ADDOP) AND (OP IN [PLUS,MINUS]) THEN
                BEGIN IF OP = PLUS THEN SIGN := POS ELSE SIGN := NEG;
                  INSYMBOL
                END;
              IF SY = IDENT THEN
                BEGIN SEARCHID([KONST],LCP);
                  WITH LCP^ DO
                    BEGIN LSP := IDTYPE; FVALU := VALUES END;
                  IF SIGN <> NONE THEN
                    IF LSP = INTPTR THEN
                      BEGIN IF SIGN = NEG THEN FVALU.IVAL := -FVALU.IVAL END
                    ELSE
                      IF LSP = REALPTR THEN
                        BEGIN
                          IF SIGN = NEG THEN
                            BEGIN NEW(LVP,REEL);
                              IF FVALU.VALP^.RVAL[1] = '-' THEN
                                LVP^.RVAL[1] := '+'
                              ELSE LVP^.RVAL[1] := '-';
                              FOR I := 2 TO STRGLGTH DO
                                LVP^.RVAL[I] := FVALU.VALP^.RVAL[I];
                              FVALU.VALP := LVP;
                            END
                          END
                        ELSE ERROR(105);
                  INSYMBOL;
                END
              ELSE
                IF SY = INTCONST THEN
                  BEGIN IF SIGN = NEG THEN VAL.IVAL := -VAL.IVAL;
                    LSP := INTPTR; FVALU := VAL; INSYMBOL
                  END
                ELSE
                  IF SY = REALCONST THEN
                    BEGIN IF SIGN = NEG THEN VAL.VALP^.RVAL[1] := '-';
                      LSP := REALPTR; FVALU := VAL; INSYMBOL
                    END
                  ELSE
                    BEGIN ERROR(106); SKIP(FSYS) END
            END;
          IF NOT (SY IN FSYS) THEN
            BEGIN ERROR(6); SKIP(FSYS) END
          END;
      FSP := LSP
    END (*CONSTANT*) ;
 
    FUNCTION EQUALBOUNDS(FSP1,FSP2: STP): BOOLEAN;
      VAR LMIN1,LMIN2,LMAX1,LMAX2: INTEGER;
    BEGIN
      IF (FSP1=NIL) OR (FSP2=NIL) THEN EQUALBOUNDS := TRUE
      ELSE
        BEGIN
          GETBOUNDS(FSP1,LMIN1,LMAX1);
          GETBOUNDS(FSP1,LMIN2,LMAX2);
          EQUALBOUNDS := (LMIN1=LMIN2) AND (LMAX1=LMAX2)
        END
    END (*EQUALBOUNDS*) ;
 
    FUNCTION COMPTYPES(FSP1,FSP2: STP) : BOOLEAN;
      (*DECIDE WHETHER STRUCTURES POINTED AT BY FSP1 AND FSP2 ARE COMPATIBLE*)
      VAR NXT1,NXT2: CTP; COMP: BOOLEAN;
        LTESTP1,LTESTP2 : TESTP;
    BEGIN
      IF FSP1 = FSP2 THEN COMPTYPES := TRUE
      ELSE
        IF (FSP1 <> NIL) AND (FSP2 <> NIL) THEN
          IF FSP1^.FORM = FSP2^.FORM THEN
            CASE FSP1^.FORM OF
              SCALAR:
                COMPTYPES := FALSE;
                (* IDENTICAL SCALARS DECLARED ON DIFFERENT LEVELS ARE
                 NOT RECOGNIZED TO BE COMPATIBLE*)
              SUBRANGE:
                COMPTYPES := COMPTYPES(FSP1^.RANGETYPE,FSP2^.RANGETYPE);
              POINTER:
                  BEGIN
                    COMP := FALSE; LTESTP1 := GLOBTESTP;
                    LTESTP2 := GLOBTESTP;
                    WHILE LTESTP1 <> NIL DO
                      WITH LTESTP1^ DO
                        BEGIN
                          IF (ELT1 = FSP1^.ELTYPE) AND
                            (ELT2 = FSP2^.ELTYPE) THEN COMP := TRUE;
                          LTESTP1 := LASTTESTP
                        END;
                    IF NOT COMP THEN
                      BEGIN NEW(LTESTP1);
                        WITH LTESTP1^ DO
                          BEGIN ELT1 := FSP1^.ELTYPE;
                            ELT2 := FSP2^.ELTYPE;
                            LASTTESTP := GLOBTESTP
                          END;
                        GLOBTESTP := LTESTP1;
                        COMP := COMPTYPES(FSP1^.ELTYPE,FSP2^.ELTYPE)
                      END;
                    COMPTYPES := COMP; GLOBTESTP := LTESTP2
                  END;
              POWER:
                COMPTYPES := COMPTYPES(FSP1^.ELSET,FSP2^.ELSET);
              ARRAYS:
                BEGIN
                  COMP := COMPTYPES(FSP1^.AELTYPE,FSP2^.AELTYPE)
                      AND COMPTYPES(FSP1^.INXTYPE,FSP2^.INXTYPE);
                  COMPTYPES := COMP AND
                      EQUALBOUNDS(FSP1^.INXTYPE,FSP2^.INXTYPE)
               END;
              RECORDS:
                BEGIN NXT1 := FSP1^.FSTFLD; NXT2 := FSP2^.FSTFLD; COMP:=TRUE;
                  WHILE (NXT1 <> NIL) AND (NXT2 <> NIL) DO
                    BEGIN COMP:=COMP AND COMPTYPES(NXT1^.IDTYPE,NXT2^.IDTYPE);
                      NXT1 := NXT1^.NEXT; NXT2 := NXT2^.NEXT
                    END;
                  COMPTYPES := COMP AND (NXT1 = NIL) AND (NXT2 = NIL)
                              AND(FSP1^.RECVAR = NIL)AND(FSP2^.RECVAR = NIL)
                END;
                (*IDENTICAL RECORDS ARE RECOGNIZED TO BE COMPATIBLE
                 IFF NO VARIANTS OCCUR*)
              FILES:
                COMPTYPES := COMPTYPES(FSP1^.FILTYPE,FSP2^.FILTYPE)
            END (*CASE*)
          ELSE (*FSP1^.FORM <> FSP2^.FORM*)
            IF FSP1^.FORM = SUBRANGE THEN
              COMPTYPES := COMPTYPES(FSP1^.RANGETYPE,FSP2)
            ELSE
              IF FSP2^.FORM = SUBRANGE THEN
                COMPTYPES := COMPTYPES(FSP1,FSP2^.RANGETYPE)
              ELSE COMPTYPES := FALSE
        ELSE COMPTYPES := TRUE
    END (*COMPTYPES*) ;
 
    FUNCTION STRING(FSP: STP) : BOOLEAN;
    BEGIN STRING := FALSE;
      IF FSP <> NIL THEN
        IF FSP^.FORM = ARRAYS THEN
          IF COMPTYPES(FSP^.AELTYPE,CHARPTR) THEN STRING := TRUE
    END (*STRING*) ;
 
    PROCEDURE TYP(FSYS: SETOFSYS; VAR FSP: STP; VAR FSIZE: ADDRRANGE);
      VAR LSP,LSP1,LSP2: STP; OLDTOP: DISPRANGE; LCP: CTP;
          LSIZE,DISPL: ADDRRANGE; LMIN,LMAX: INTEGER;
 
      PROCEDURE SIMPLETYPE(FSYS:SETOFSYS; VAR FSP:STP; VAR FSIZE:ADDRRANGE);
        VAR LSP,LSP1: STP; LCP,LCP1: CTP; TTOP: DISPRANGE;
            LCNT: INTEGER; LVALU: VALU;
      BEGIN FSIZE := 1;
        IF NOT (SY IN SIMPTYPEBEGSYS) THEN
          BEGIN ERROR(1); SKIP(FSYS + SIMPTYPEBEGSYS) END;
        IF SY IN SIMPTYPEBEGSYS THEN
          BEGIN
            IF SY = LPARENT THEN
              BEGIN TTOP := TOP;   (*DECL. CONSTS LOCAL TO INNERMOST BLOCK*)
                WHILE DISPLAY[TOP].OCCUR <> BLCK DO TOP := TOP - 1;
                NEW(LSP,SCALAR,DECLARED);
                WITH LSP^ DO
                  BEGIN SIZE := INTSIZE; FORM := SCALAR;
                    SCALKIND := DECLARED
                  END;
                LCP1 := NIL; LCNT := 0;
                REPEAT INSYMBOL;
                  IF SY = IDENT THEN
                    BEGIN NEW(LCP,KONST);
                      WITH LCP^ DO
                        BEGIN NAME := ID; IDTYPE := LSP; NEXT := LCP1;
                          VALUES.IVAL := LCNT; KLASS := KONST
                        END;
                      ENTERID(LCP);
                      LCNT := LCNT + 1;
                      LCP1 := LCP; INSYMBOL
                    END
                  ELSE ERROR(2);
                  IF NOT (SY IN FSYS + [COMMA,RPARENT]) THEN
                    BEGIN ERROR(6); SKIP(FSYS + [COMMA,RPARENT]) END
                UNTIL SY <> COMMA;
                LSP^.FCONST := LCP1; TOP := TTOP;
                IF SY = RPARENT THEN INSYMBOL ELSE ERROR(4)
              END
            ELSE
              BEGIN
                IF SY = IDENT THEN
                  BEGIN SEARCHID([TYPES,KONST],LCP);
                    INSYMBOL;
                    IF LCP^.KLASS = KONST THEN
                      BEGIN NEW(LSP,SUBRANGE);
                        WITH LSP^, LCP^ DO
                          BEGIN RANGETYPE := IDTYPE; FORM := SUBRANGE;
                            IF STRING(RANGETYPE) THEN
                              BEGIN ERROR(148); RANGETYPE := NIL END;
                            MIN := VALUES; SIZE := INTSIZE
                          END;
                        IF SY = COLON THEN INSYMBOL ELSE ERROR(5);
                        CONSTANT(FSYS,LSP1,LVALU);
                        LSP^.MAX := LVALU;
                        IF LSP^.RANGETYPE <> LSP1 THEN ERROR(107)
                      END
                    ELSE
                      BEGIN LSP := LCP^.IDTYPE;
                        IF LSP <> NIL THEN FSIZE := LSP^.SIZE
                      END
                  END (*SY = IDENT*)
                ELSE
                  BEGIN NEW(LSP,SUBRANGE); LSP^.FORM := SUBRANGE;
                    CONSTANT(FSYS + [COLON],LSP1,LVALU);
                    IF STRING(LSP1) THEN
                      BEGIN ERROR(148); LSP1 := NIL END;
                    WITH LSP^ DO
                      BEGIN RANGETYPE:=LSP1; MIN:=LVALU; SIZE:=INTSIZE END;
                    IF SY = COLON THEN INSYMBOL ELSE ERROR(5);
                    CONSTANT(FSYS,LSP1,LVALU);
                    LSP^.MAX := LVALU;
                    IF LSP^.RANGETYPE <> LSP1 THEN ERROR(107)
                  END;
                IF LSP <> NIL THEN
                  WITH LSP^ DO
                    IF FORM = SUBRANGE THEN
                      IF RANGETYPE <> NIL THEN
                        IF RANGETYPE = REALPTR THEN ERROR(399)
                        ELSE
                          IF MIN.IVAL > MAX.IVAL THEN ERROR(102)
              END;
            FSP := LSP;
            IF NOT (SY IN FSYS) THEN
              BEGIN ERROR(6); SKIP(FSYS) END
          END
            ELSE FSP := NIL
      END (*SIMPLETYPE*) ;
 
      PROCEDURE FIELDLIST(FSYS: SETOFSYS; VAR FRECVAR: STP);
        VAR LCP,LCP1,NXT,NXT1: CTP; LSP,LSP1,LSP2,LSP3,LSP4: STP;
            MINSIZE,MAXSIZE,LSIZE: ADDRRANGE; LVALU: VALU;
      BEGIN NXT1 := NIL; LSP := NIL;
        IF NOT (SY IN (FSYS+[IDENT,CASESY])) THEN
          BEGIN ERROR(19); SKIP(FSYS + [IDENT,CASESY]) END;
        WHILE SY = IDENT DO
          BEGIN NXT := NXT1;
            REPEAT
              IF SY = IDENT THEN
                BEGIN NEW(LCP,FIELD);
                  WITH LCP^ DO
                    BEGIN NAME := ID; IDTYPE := NIL; NEXT := NXT;
                      KLASS := FIELD
                    END;
                  NXT := LCP;
                  ENTERID(LCP);
                  INSYMBOL
                END
              ELSE ERROR(2);
              IF NOT (SY IN [COMMA,COLON]) THEN
                BEGIN ERROR(6); SKIP(FSYS + [COMMA,COLON,SEMICOLON,CASESY])
                END;
            TEST := SY <> COMMA;
              IF NOT TEST  THEN INSYMBOL
            UNTIL TEST;
            IF SY = COLON THEN INSYMBOL ELSE ERROR(5);
            TYP(FSYS + [CASESY,SEMICOLON],LSP,LSIZE);
            WHILE NXT <> NXT1 DO
              WITH NXT^ DO
                BEGIN ALIGN(LSP,DISPL);
                  IDTYPE := LSP; FLDADDR := DISPL;
                  NXT := NEXT; DISPL := DISPL + LSIZE
                END;
            NXT1 := LCP;
            IF SY = SEMICOLON THEN
              BEGIN INSYMBOL;
                IF NOT (SY IN [IDENT,CASESY]) THEN
                  BEGIN ERROR(19); SKIP(FSYS + [IDENT,CASESY]) END
              END
          END (*WHILE*);
        NXT := NIL;
        WHILE NXT1 <> NIL DO
          WITH NXT1^ DO
            BEGIN LCP := NEXT; NEXT := NXT; NXT := NXT1; NXT1 := LCP END;
        IF SY = CASESY THEN
          BEGIN NEW(LSP,TAGFLD);
            WITH LSP^ DO
              BEGIN TAGFIELDP := NIL; FSTVAR := NIL; FORM:=TAGFLD END;
            FRECVAR := LSP;
            INSYMBOL;
            IF SY = IDENT THEN
              BEGIN NEW(LCP,FIELD);
                WITH LCP^ DO
                  BEGIN NAME := ID; IDTYPE := NIL; KLASS:=FIELD;
                    NEXT := NIL; FLDADDR := DISPL
                  END;
                ENTERID(LCP);
                INSYMBOL;
                IF SY = COLON THEN INSYMBOL ELSE ERROR(5);
                IF SY = IDENT THEN
                  BEGIN SEARCHID([TYPES],LCP1);
                    LSP1 := LCP1^.IDTYPE;
                    IF LSP1 <> NIL THEN
                      BEGIN ALIGN(LSP1,DISPL);
                        LCP^.FLDADDR := DISPL;
                        DISPL := DISPL+LSP1^.SIZE;
                        IF (LSP1^.FORM <= SUBRANGE) OR STRING(LSP1) THEN
                          BEGIN IF COMPTYPES(REALPTR,LSP1) THEN ERROR(109)
                            ELSE IF STRING(LSP1) THEN ERROR(399);
                            LCP^.IDTYPE := LSP1; LSP^.TAGFIELDP := LCP;
                          END
                        ELSE ERROR(110);
                    END;
                    INSYMBOL;
                  END
                ELSE BEGIN ERROR(2); SKIP(FSYS + [OFSY,LPARENT]) END
              END
            ELSE BEGIN ERROR(2); SKIP(FSYS + [OFSY,LPARENT]) END;
            LSP^.SIZE := DISPL;
            IF SY = OFSY THEN INSYMBOL ELSE ERROR(8);
            LSP1 := NIL; MINSIZE := DISPL; MAXSIZE := DISPL;
            REPEAT LSP2 := NIL;
              IF NOT (SY IN [SEMICOLON,ENDSY]) THEN
              BEGIN
              REPEAT CONSTANT(FSYS + [COMMA,COLON,LPARENT],LSP3,LVALU);
                IF LSP^.TAGFIELDP <> NIL THEN
                 IF NOT COMPTYPES(LSP^.TAGFIELDP^.IDTYPE,LSP3)THEN ERROR(111);
                NEW(LSP3,VARIANT);
                WITH LSP3^ DO
                  BEGIN NXTVAR := LSP1; SUBVAR := LSP2; VARVAL := LVALU;
                    FORM := VARIANT
                  END;
                LSP4 := LSP1;
                WHILE LSP4 <> NIL DO
                  WITH LSP4^ DO
                    BEGIN
                      IF VARVAL.IVAL = LVALU.IVAL THEN ERROR(178);
                      LSP4 := NXTVAR
                    END;
                LSP1 := LSP3; LSP2 := LSP3;
                TEST := SY <> COMMA;
                IF NOT TEST THEN INSYMBOL
              UNTIL TEST;
              IF SY = COLON THEN INSYMBOL ELSE ERROR(5);
              IF SY = LPARENT THEN INSYMBOL ELSE ERROR(9);
              FIELDLIST(FSYS + [RPARENT,SEMICOLON],LSP2);
              IF DISPL > MAXSIZE THEN MAXSIZE := DISPL;
              WHILE LSP3 <> NIL DO
                BEGIN LSP4 := LSP3^.SUBVAR; LSP3^.SUBVAR := LSP2;
                  LSP3^.SIZE := DISPL;
                  LSP3 := LSP4
                END;
              IF SY = RPARENT THEN
                BEGIN INSYMBOL;
                  IF NOT (SY IN FSYS + [SEMICOLON]) THEN
                    BEGIN ERROR(6); SKIP(FSYS + [SEMICOLON]) END
                END
              ELSE ERROR(4);
              END;
              TEST := SY <> SEMICOLON;
              IF NOT TEST THEN
                BEGIN DISPL := MINSIZE;
                      INSYMBOL
                END
            UNTIL TEST;
            DISPL := MAXSIZE;
            LSP^.FSTVAR := LSP1;
          END
        ELSE FRECVAR := NIL
      END (*FIELDLIST*) ;
 
    BEGIN (*TYP*)
      IF NOT (SY IN TYPEBEGSYS) THEN
         BEGIN ERROR(10); SKIP(FSYS + TYPEBEGSYS) END;
      IF SY IN TYPEBEGSYS THEN
        BEGIN
          IF SY IN SIMPTYPEBEGSYS THEN SIMPLETYPE(FSYS,FSP,FSIZE)
          ELSE
    (*^*)     IF SY = ARROW THEN
              BEGIN NEW(LSP,POINTER); FSP := LSP;
                WITH LSP^ DO
                  BEGIN ELTYPE := NIL; SIZE := PTRSIZE; FORM:=POINTER END;
                INSYMBOL;
                IF SY = IDENT THEN
                  BEGIN PRTERR := FALSE; (*NO ERROR IF SEARCH NOT SUCCESSFUL*)
                    SEARCHID([TYPES],LCP); PRTERR := TRUE;
                    IF LCP = NIL THEN   (*FORWARD REFERENCED TYPE ID*)
                      BEGIN NEW(LCP,TYPES);
                        WITH LCP^ DO
                          BEGIN NAME := ID; IDTYPE := LSP;
                            NEXT := FWPTR; KLASS := TYPES
                          END;
                        FWPTR := LCP
                      END
                    ELSE
                      BEGIN
                        IF LCP^.IDTYPE <> NIL THEN
                          IF LCP^.IDTYPE^.FORM = FILES THEN ERROR(108)
                          ELSE LSP^.ELTYPE := LCP^.IDTYPE
                      END;
                    INSYMBOL;
                  END
                ELSE ERROR(2);
              END
            ELSE
              BEGIN
                IF SY = PACKEDSY THEN
                  BEGIN INSYMBOL;
                    IF NOT (SY IN TYPEDELS) THEN
                      BEGIN
                        ERROR(10); SKIP(FSYS + TYPEDELS)
                      END
                  END;
    (*ARRAY*)     IF SY = ARRAYSY THEN
                  BEGIN INSYMBOL;
                    IF SY = LBRACK THEN INSYMBOL ELSE ERROR(11);
                    LSP1 := NIL;
                    REPEAT NEW(LSP,ARRAYS);
                      WITH LSP^ DO
                        BEGIN AELTYPE := LSP1; INXTYPE := NIL; FORM:=ARRAYS END;
                      LSP1 := LSP;
                      SIMPLETYPE(FSYS + [COMMA,RBRACK,OFSY],LSP2,LSIZE);
                      LSP1^.SIZE := LSIZE;
                      IF LSP2 <> NIL THEN
                        IF LSP2^.FORM <= SUBRANGE THEN
                          BEGIN
                            IF LSP2 = REALPTR THEN
                              BEGIN ERROR(109); LSP2 := NIL END
                            ELSE
                              IF LSP2 = INTPTR THEN
                                BEGIN ERROR(149); LSP2 := NIL END;
                            LSP^.INXTYPE := LSP2
                          END
                        ELSE BEGIN ERROR(113); LSP2 := NIL END;
                      TEST := SY <> COMMA;
                      IF NOT TEST THEN INSYMBOL
                    UNTIL TEST;
                    IF SY = RBRACK THEN INSYMBOL ELSE ERROR(12);
                    IF SY = OFSY THEN INSYMBOL ELSE ERROR(8);
                    TYP(FSYS,LSP,LSIZE);
                    REPEAT
                      WITH LSP1^ DO
                        BEGIN LSP2 := AELTYPE; AELTYPE := LSP;
                          IF INXTYPE <> NIL THEN
                            BEGIN GETBOUNDS(INXTYPE,LMIN,LMAX);
                              ALIGN(LSP,LSIZE);
                              LSIZE := LSIZE*(LMAX - LMIN + 1);
                              SIZE := LSIZE
                            END
                        END;
                      LSP := LSP1; LSP1 := LSP2
                    UNTIL LSP1 = NIL
                  END
                ELSE
    (*RECORD*)      IF SY = RECORDSY THEN
                    BEGIN INSYMBOL;
                      OLDTOP := TOP;
                      IF TOP < DISPLIMIT THEN
                        BEGIN TOP := TOP + 1;
                          WITH DISPLAY[TOP] DO
                            BEGIN FNAME := NIL;
                              FLABEL := NIL;
                                  OCCUR := REC
                            END
                        END
                      ELSE ERROR(250);
                      DISPL := 0;
                      FIELDLIST(FSYS-[SEMICOLON]+[ENDSY],LSP1);
                      NEW(LSP,RECORDS);
                      WITH LSP^ DO
                        BEGIN FSTFLD := DISPLAY[TOP].FNAME;
                          RECVAR := LSP1; SIZE := DISPL; FORM := RECORDS
                        END;
                      TOP := OLDTOP;
                      IF SY = ENDSY THEN INSYMBOL ELSE ERROR(13)
                    END
                  ELSE
    (*SET*)           IF SY = SETSY THEN
                      BEGIN INSYMBOL;
                        IF SY = OFSY THEN INSYMBOL ELSE ERROR(8);
                        SIMPLETYPE(FSYS,LSP1,LSIZE);
                        IF LSP1 <> NIL THEN
                          IF LSP1^.FORM > SUBRANGE THEN
                            BEGIN ERROR(115); LSP1 := NIL END
                          ELSE
                            IF LSP1 = REALPTR THEN ERROR(114);
                        NEW(LSP,POWER);
                        WITH LSP^ DO
                          BEGIN ELSET:=LSP1; SIZE:=SETSIZE; FORM:=POWER END;
                      END
                    ELSE
    (*FILE*)            IF SY = FILESY THEN
                          BEGIN INSYMBOL;
                            ERROR(399); SKIP(FSYS); LSP := NIL
                          END;
                FSP := LSP
              END;
          IF NOT (SY IN FSYS) THEN
            BEGIN ERROR(6); SKIP(FSYS) END
        END
      ELSE FSP := NIL;
      IF FSP = NIL THEN FSIZE := 1 ELSE FSIZE := FSP^.SIZE
    END (*TYP*) ;
 
    PROCEDURE LABELDECLARATION;
      VAR LLP: LBP; REDEF: BOOLEAN; LBNAME: INTEGER;
    BEGIN
      REPEAT
        IF SY = INTCONST THEN
          WITH DISPLAY[TOP] DO
            BEGIN LLP := FLABEL; REDEF := FALSE;
              WHILE (LLP <> NIL) AND NOT REDEF DO
                IF LLP^.LABVAL <> VAL.IVAL THEN
                  LLP := LLP^.NEXTLAB
                ELSE BEGIN REDEF := TRUE; ERROR(166) END;
              IF NOT REDEF THEN
                BEGIN NEW(LLP);
                  WITH LLP^ DO
                    BEGIN LABVAL := VAL.IVAL; GENLABEL(LBNAME);
                      DEFINED := FALSE; NEXTLAB := FLABEL; LABNAME := LBNAME
                    END;
                  FLABEL := LLP
                END;
              INSYMBOL
            END
        ELSE ERROR(15);
        IF NOT ( SY IN FSYS + [COMMA, SEMICOLON] ) THEN
          BEGIN ERROR(6); SKIP(FSYS+[COMMA,SEMICOLON]) END;
        TEST := SY <> COMMA;
        IF NOT TEST THEN INSYMBOL
      UNTIL TEST;
      IF SY = SEMICOLON THEN INSYMBOL ELSE ERROR(14)
    END (* LABELDECLARATION *) ;
 
    PROCEDURE CONSTDECLARATION;
      VAR LCP: CTP; LSP: STP; LVALU: VALU;
    BEGIN
      IF SY <> IDENT THEN
        BEGIN ERROR(2); SKIP(FSYS + [IDENT]) END;
      WHILE SY = IDENT DO
        BEGIN NEW(LCP,KONST);
          WITH LCP^ DO
            BEGIN NAME := ID; IDTYPE := NIL; NEXT := NIL; KLASS:=KONST END;
          INSYMBOL;
          IF (SY = RELOP) AND (OP = EQOP) THEN INSYMBOL ELSE ERROR(16);
          CONSTANT(FSYS + [SEMICOLON],LSP,LVALU);
          ENTERID(LCP);
          LCP^.IDTYPE := LSP; LCP^.VALUES := LVALU;
          IF SY = SEMICOLON THEN
            BEGIN INSYMBOL;
              IF NOT (SY IN FSYS + [IDENT]) THEN
                BEGIN ERROR(6); SKIP(FSYS + [IDENT]) END
            END
          ELSE ERROR(14)
        END
    END (*CONSTDECLARATION*) ;
 
    PROCEDURE TYPEDECLARATION;
      VAR LCP,LCP1,LCP2: CTP; LSP: STP; LSIZE: ADDRRANGE;
    BEGIN
      IF SY <> IDENT THEN
        BEGIN ERROR(2); SKIP(FSYS + [IDENT]) END;
      WHILE SY = IDENT DO
        BEGIN NEW(LCP,TYPES);
          WITH LCP^ DO
            BEGIN NAME := ID; IDTYPE := NIL; KLASS := TYPES END;
          INSYMBOL;
          IF (SY = RELOP) AND (OP = EQOP) THEN INSYMBOL ELSE ERROR(16);
          TYP(FSYS + [SEMICOLON],LSP,LSIZE);
          ENTERID(LCP);
          LCP^.IDTYPE := LSP;
          (*HAS ANY FORWARD REFERENCE BEEN SATISFIED:*)
          LCP1 := FWPTR;
          WHILE LCP1 <> NIL DO
            BEGIN
              IF LCP1^.NAME = LCP^.NAME THEN
                BEGIN LCP1^.IDTYPE^.ELTYPE := LCP^.IDTYPE;
                  IF LCP1 <> FWPTR THEN
                    LCP2^.NEXT := LCP1^.NEXT
                  ELSE FWPTR := LCP1^.NEXT;
                END;
              LCP2 := LCP1; LCP1 := LCP1^.NEXT
            END;
          IF SY = SEMICOLON THEN
            BEGIN INSYMBOL;
              IF NOT (SY IN FSYS + [IDENT]) THEN
                BEGIN ERROR(6); SKIP(FSYS + [IDENT]) END
            END
          ELSE ERROR(14)
        END;
      IF FWPTR <> NIL THEN
        BEGIN ERROR(117); WRITELN(OUTPUT);
          REPEAT WRITELN(OUTPUT,' TYPE-ID ',FWPTR^.NAME);
            FWPTR := FWPTR^.NEXT
          UNTIL FWPTR = NIL;
          IF NOT EOL THEN WRITE(OUTPUT,' ': CHCNT+16)
        END
    END (*TYPEDECLARATION*) ;
 
    PROCEDURE VARDECLARATION;
      VAR LCP,NXT: CTP; LSP: STP; LSIZE: ADDRRANGE;
    BEGIN NXT := NIL;
      REPEAT
        REPEAT
          IF SY = IDENT THEN
            BEGIN NEW(LCP,VARS);
              WITH LCP^ DO
               BEGIN NAME := ID; NEXT := NXT; KLASS := VARS;
                  IDTYPE := NIL; VKIND := ACTUAL; VLEV := LEVEL
                END;
              ENTERID(LCP);
              NXT := LCP;
              INSYMBOL;
            END
          ELSE ERROR(2);
          IF NOT (SY IN FSYS + [COMMA,COLON] + TYPEDELS) THEN
            BEGIN ERROR(6); SKIP(FSYS+[COMMA,COLON,SEMICOLON]+TYPEDELS) END;
          TEST := SY <> COMMA;
          IF NOT TEST THEN INSYMBOL
        UNTIL TEST;
        IF SY = COLON THEN INSYMBOL ELSE ERROR(5);
        TYP(FSYS + [SEMICOLON] + TYPEDELS,LSP,LSIZE);
        WHILE NXT <> NIL DO
          WITH  NXT^ DO
            BEGIN ALIGN(LSP,LC);
              IDTYPE := LSP; VADDR := LC;
              LC := LC + LSIZE; NXT := NEXT
            END;
        IF SY = SEMICOLON THEN
          BEGIN INSYMBOL;
            IF NOT (SY IN FSYS + [IDENT]) THEN
              BEGIN ERROR(6); SKIP(FSYS + [IDENT]) END
          END
        ELSE ERROR(14)
      UNTIL (SY <> IDENT) AND NOT (SY IN TYPEDELS);
      IF FWPTR <> NIL THEN
        BEGIN ERROR(117); WRITELN(OUTPUT);
          REPEAT WRITELN(OUTPUT,' TYPE-ID ',FWPTR^.NAME);
            FWPTR := FWPTR^.NEXT
          UNTIL FWPTR = NIL;
          IF NOT EOL THEN WRITE(OUTPUT,' ': CHCNT+16)
        END
    END (*VARDECLARATION*) ;
 
    PROCEDURE PROCDECLARATION(FSY: SYMBOL);
      VAR OLDLEV: 0..MAXLEVEL; LSY: SYMBOL; LCP,LCP1: CTP; LSP: STP;
          FORW: BOOLEAN; OLDTOP: DISPRANGE; PARCNT: INTEGER;
          LLC,LCM: ADDRRANGE; LBNAME: INTEGER; MARKP: ^INTEGER;
 
      PROCEDURE PARAMETERLIST(FSY: SETOFSYS; VAR FPAR: CTP);
        VAR LCP,LCP1,LCP2,LCP3: CTP; LSP: STP; LKIND: IDKIND;
          LLC: ADDRRANGE; COUNT,LSIZE: INTEGER;
      BEGIN LCP1 := NIL;
        IF NOT (SY IN FSY + [LPARENT]) THEN
          BEGIN ERROR(7); SKIP(FSYS + FSY + [LPARENT]) END;
        IF SY = LPARENT THEN
          BEGIN IF FORW THEN ERROR(119);
            INSYMBOL;
            IF NOT (SY IN [IDENT,VARSY,PROCSY,FUNCSY]) THEN
              BEGIN ERROR(7); SKIP(FSYS + [IDENT,RPARENT]) END;
            WHILE SY IN [IDENT,VARSY,PROCSY,FUNCSY] DO
              BEGIN
                IF SY = PROCSY THEN
                  BEGIN ERROR(399);
                    REPEAT INSYMBOL;
                      IF SY = IDENT THEN
                      BEGIN NEW(LCP,PROC,DECLARED,FORMAL);
                          WITH LCP^ DO
                            BEGIN NAME := ID; IDTYPE := NIL; NEXT := LCP1;
                              PFLEV := LEVEL (*BEWARE OF PARAMETER PROCEDURES*);
                              KLASS:=PROC;PFDECKIND:=DECLARED;PFKIND:=FORMAL
                            END;
                          ENTERID(LCP);
                          LCP1 := LCP;
                          ALIGN(PARMPTR,LC);
                          (*LC := LC + SOME SIZE *)
                          INSYMBOL
                        END
                      ELSE ERROR(2);
                      IF NOT (SY IN FSYS + [COMMA,SEMICOLON,RPARENT]) THEN
                        BEGIN ERROR(7);SKIP(FSYS+[COMMA,SEMICOLON,RPARENT])END
                    UNTIL SY <> COMMA
                  END
                ELSE
                  BEGIN
                    IF SY = FUNCSY THEN
                      BEGIN ERROR(399); LCP2 := NIL;
                        REPEAT INSYMBOL;
                          IF SY = IDENT THEN
                            BEGIN NEW(LCP,FUNC,DECLARED,FORMAL);
                              WITH LCP^ DO
                                BEGIN NAME := ID; IDTYPE := NIL; NEXT := LCP2;
                                  PFLEV := LEVEL (*BEWARE PARAM FUNCS*);
                                  KLASS:=FUNC;PFDECKIND:=DECLARED;
                                  PFKIND:=FORMAL
                                END;
                              ENTERID(LCP);
                             LCP2 := LCP;
                             ALIGN(PARMPTR,LC);
                             (*LC := LC + SOME SIZE*)
                              INSYMBOL;
                            END;
                          IF NOT (SY IN [COMMA,COLON] + FSYS) THEN
                           BEGIN ERROR(7);SKIP(FSYS+[COMMA,SEMICOLON,RPARENT])
                            END
                        UNTIL SY <> COMMA;
                        IF SY = COLON THEN
                          BEGIN INSYMBOL;
                            IF SY = IDENT THEN
                              BEGIN SEARCHID([TYPES],LCP);
                                LSP := LCP^.IDTYPE;
                                IF LSP <> NIL THEN
                                 IF NOT(LSP^.FORM IN[SCALAR,SUBRANGE,POINTER])
                                    THEN BEGIN ERROR(120); LSP := NIL END;
                                LCP3 := LCP2;
                                WHILE LCP2 <> NIL DO
                                  BEGIN LCP2^.IDTYPE := LSP; LCP := LCP2;
                                    LCP2 := LCP2^.NEXT
                                  END;
                                LCP^.NEXT := LCP1; LCP1 := LCP3;
                                INSYMBOL
                              END
                            ELSE ERROR(2);
                            IF NOT (SY IN FSYS + [SEMICOLON,RPARENT]) THEN
                              BEGIN ERROR(7);SKIP(FSYS+[SEMICOLON,RPARENT])END
                          END
                        ELSE ERROR(5)
                      END
                    ELSE
                      BEGIN
                        IF SY = VARSY THEN
                          BEGIN LKIND := FORMAL; INSYMBOL END
                        ELSE LKIND := ACTUAL;
                        LCP2 := NIL;
                        COUNT := 0;
                        REPEAT
                          IF SY = IDENT THEN
                            BEGIN NEW(LCP,VARS);
                              WITH LCP^ DO
                                BEGIN NAME:=ID; IDTYPE:=NIL; KLASS:=VARS;
                                  VKIND := LKIND; NEXT := LCP2; VLEV := LEVEL;
                                END;
                              ENTERID(LCP);
                              LCP2 := LCP; COUNT := COUNT+1;
                              INSYMBOL;
                            END;
                          IF NOT (SY IN [COMMA,COLON] + FSYS) THEN
                           BEGIN ERROR(7);SKIP(FSYS+[COMMA,SEMICOLON,RPARENT])
                            END;
                          TEST := SY <> COMMA;
                          IF NOT TEST THEN INSYMBOL
                        UNTIL TEST;
                        IF SY = COLON THEN
                          BEGIN INSYMBOL;
                            IF SY = IDENT THEN
                              BEGIN SEARCHID([TYPES],LCP);
                                LSP := LCP^.IDTYPE;
                                LSIZE := PTRSIZE;
                                IF LSP <> NIL THEN
                                  IF LKIND=ACTUAL THEN
                                    IF LSP^.FORM<=POWER THEN LSIZE := LSP^.SIZE
                                    ELSE IF LSP^.FORM=FILES THEN ERROR(121);
                                ALIGN(PARMPTR,LSIZE);
                                LCP3 := LCP2;
                                ALIGN(PARMPTR,LC);
                                LC := LC+COUNT*LSIZE;
                                LLC := LC;
                                WHILE LCP2 <> NIL DO
                                  BEGIN LCP := LCP2;
                                    WITH LCP2^ DO
                                      BEGIN IDTYPE := LSP;
                                        LLC := LLC-LSIZE;
                                        VADDR := LLC;
                                      END;
                                    LCP2 := LCP2^.NEXT
                                  END;
                                LCP^.NEXT := LCP1; LCP1 := LCP3;
                                INSYMBOL
                              END
                            ELSE ERROR(2);
                            IF NOT (SY IN FSYS + [SEMICOLON,RPARENT]) THEN
                              BEGIN ERROR(7);SKIP(FSYS+[SEMICOLON,RPARENT])END
                          END
                        ELSE ERROR(5);
                      END;
                  END;
                IF SY = SEMICOLON THEN
                  BEGIN INSYMBOL;
                    IF NOT (SY IN FSYS + [IDENT,VARSY,PROCSY,FUNCSY]) THEN
                      BEGIN ERROR(7); SKIP(FSYS + [IDENT,RPARENT]) END
                  END
              END (*WHILE*) ;
            IF SY = RPARENT THEN
              BEGIN INSYMBOL;
                IF NOT (SY IN FSY + FSYS) THEN
                  BEGIN ERROR(6); SKIP(FSY + FSYS) END
              END
            ELSE ERROR(4);
            LCP3 := NIL;
            (*REVERSE POINTERS AND RESERVE LOCAL CELLS FOR COPIES OF MULTIPLE
             VALUES*)
            WHILE LCP1 <> NIL DO
              WITH LCP1^ DO
                BEGIN LCP2 := NEXT; NEXT := LCP3;
                  IF KLASS = VARS THEN
                    IF IDTYPE <> NIL THEN
                      IF (VKIND=ACTUAL)AND(IDTYPE^.FORM>POWER) THEN
                        BEGIN ALIGN(IDTYPE,LC);
                          VADDR := LC;
                          LC := LC+IDTYPE^.SIZE;
                        END;
                  LCP3 := LCP1; LCP1 := LCP2
                END;
            FPAR := LCP3
          END
            ELSE FPAR := NIL
    END (*PARAMETERLIST*) ;
 
    BEGIN (*PROCDECLARATION*)
      LLC := LC; LC := LCAFTERMARKSTACK; FORW := FALSE;
      IF SY = IDENT THEN
        BEGIN SEARCHSECTION(DISPLAY[TOP].FNAME,LCP); (*DECIDE WHETHER FORW.*)
          IF LCP <> NIL THEN
          BEGIN
            IF LCP^.KLASS = PROC THEN
              FORW := LCP^.FORWDECL AND(FSY = PROCSY)AND(LCP^.PFKIND = ACTUAL)
            ELSE
              IF LCP^.KLASS = FUNC THEN
                FORW:=LCP^.FORWDECL AND(FSY=FUNCSY)AND(LCP^.PFKIND=ACTUAL)
              ELSE FORW := FALSE;
            IF NOT FORW THEN ERROR(160)
          END;
          IF NOT FORW THEN
            BEGIN
              IF FSY = PROCSY THEN NEW(LCP,PROC,DECLARED,ACTUAL)
              ELSE NEW(LCP,FUNC,DECLARED,ACTUAL);
              WITH LCP^ DO
                BEGIN NAME := ID; IDTYPE := NIL;
                  EXTERN := FALSE; PFLEV := LEVEL; GENLABEL(LBNAME);
                  PFDECKIND := DECLARED; PFKIND := ACTUAL; PFNAME := LBNAME;
                  IF FSY = PROCSY THEN KLASS := PROC
                  ELSE KLASS := FUNC
                END;
              ENTERID(LCP)
            END
          ELSE
            BEGIN LCP1 := LCP^.NEXT;
              WHILE LCP1 <> NIL DO
                BEGIN
                  WITH LCP1^ DO
                    IF KLASS = VARS THEN
                      IF IDTYPE <> NIL THEN
                        BEGIN LCM := VADDR + IDTYPE^.SIZE;
                          IF LCM > LC THEN LC := LCM
                        END;
                  LCP1 := LCP1^.NEXT
                END
              END;
          INSYMBOL
        END
      ELSE
        BEGIN ERROR(2); LCP := UFCTPTR END;
      OLDLEV := LEVEL; OLDTOP := TOP;
      IF LEVEL < MAXLEVEL THEN LEVEL := LEVEL + 1 ELSE ERROR(251);
      IF TOP < DISPLIMIT THEN
        BEGIN TOP := TOP + 1;
          WITH DISPLAY[TOP] DO
            BEGIN
              IF FORW THEN FNAME := LCP^.NEXT
              ELSE FNAME := NIL;
              FLABEL := NIL;
              OCCUR := BLCK
            END
        END
      ELSE ERROR(250);
      IF FSY = PROCSY THEN
        BEGIN PARAMETERLIST([SEMICOLON],LCP1);
          IF NOT FORW THEN LCP^.NEXT := LCP1
        END
      ELSE
        BEGIN PARAMETERLIST([SEMICOLON,COLON],LCP1);
          IF NOT FORW THEN LCP^.NEXT := LCP1;
          IF SY = COLON THEN
            BEGIN INSYMBOL;
              IF SY = IDENT THEN
                BEGIN IF FORW THEN ERROR(122);
                  SEARCHID([TYPES],LCP1);
                  LSP := LCP1^.IDTYPE;
                  LCP^.IDTYPE := LSP;
                  IF LSP <> NIL THEN
                    IF NOT (LSP^.FORM IN [SCALAR,SUBRANGE,POINTER]) THEN
                      BEGIN ERROR(120); LCP^.IDTYPE := NIL END;
                  INSYMBOL
                END
              ELSE BEGIN ERROR(2); SKIP(FSYS + [SEMICOLON]) END
            END
          ELSE
            IF NOT FORW THEN ERROR(123)
        END;
      IF SY = SEMICOLON THEN INSYMBOL ELSE ERROR(14);
      IF SY = FORWARDSY THEN
        BEGIN
          IF FORW THEN ERROR(161)
          ELSE LCP^.FORWDECL := TRUE;
          INSYMBOL;
          IF SY = SEMICOLON THEN INSYMBOL ELSE ERROR(14);
          IF NOT (SY IN FSYS) THEN
            BEGIN ERROR(6); SKIP(FSYS) END
        END
      ELSE
        BEGIN LCP^.FORWDECL := FALSE; MARK(MARKP);
          REPEAT BLOCK(FSYS,SEMICOLON,LCP);
            IF SY = SEMICOLON THEN
              BEGIN IF PRTABLES THEN PRINTTABLES(FALSE); INSYMBOL;
                IF NOT (SY IN [BEGINSY,PROCSY,FUNCSY]) THEN
                  BEGIN ERROR(6); SKIP(FSYS) END
              END
            ELSE ERROR(14)
          UNTIL (SY IN [BEGINSY,PROCSY,FUNCSY]) OR EOF(INPUT);
          RELEASE(MARKP); (* RETURN LOCAL ENTRIES ON RUNTIME HEAP *)
        END;
      LEVEL := OLDLEV; TOP := OLDTOP; LC := LLC;
    END (*PROCDECLARATION*) ;
 
    PROCEDURE BODY(FSYS: SETOFSYS);
      CONST CSTOCCMAX=65; CIXMAX=1000;
      TYPE OPRANGE = 0..63;
      VAR
          LLCP:CTP; SAVEID:ALPHA;
          CSTPTR: ARRAY [1..CSTOCCMAX] OF CSP;
          CSTPTRIX: 0..CSTOCCMAX;
          (*ALLOWS REFERENCING OF NONINTEGER CONSTANTS BY AN INDEX
           (INSTEAD OF A POINTER), WHICH CAN BE STORED IN THE P2-FIELD
           OF THE INSTRUCTION RECORD UNTIL WRITEOUT.
           --> PROCEDURE LOAD, PROCEDURE WRITEOUT*)
          I, ENTNAME, SEGSIZE: INTEGER;
          STACKTOP, TOPNEW, TOPMAX: INTEGER;
          LCMAX,LLC1: ADDRRANGE; LCP: CTP;
          LLP: LBP;
 
 
      PROCEDURE MES(I: INTEGER);
      BEGIN TOPNEW := TOPNEW + CDX[I]*MAXSTACK;
        IF TOPNEW > TOPMAX THEN TOPMAX := TOPNEW
      END;
      PROCEDURE PUTIC;
      BEGIN IF IC MOD 10 = 0 THEN WRITELN(PRR,'I',IC:5) END;
 
 
      PROCEDURE GEN0(FOP: OPRANGE);
      BEGIN
        IF PRCODE THEN BEGIN PUTIC; WRITELN(PRR,MN[FOP]:4) END;
        IC := IC + 1; MES(FOP)
      END (*GEN0*) ;
 
      PROCEDURE GEN1(FOP: OPRANGE; FP2: INTEGER);
        VAR K: INTEGER;
      BEGIN
        IF PRCODE THEN
          BEGIN PUTIC; WRITE(PRR,MN[FOP]:4);
            IF FOP = 30 THEN
              BEGIN WRITELN(PRR,SNA[FP2]:12);
                TOPNEW := TOPNEW + PDX[FP2]*MAXSTACK;
                IF TOPNEW > TOPMAX THEN TOPMAX := TOPNEW
              END
            ELSE
              BEGIN
                IF FOP = 38 THEN
                   BEGIN WRITE(PRR,'''');
                     WITH CSTPTR[FP2]^ DO
                     BEGIN
                       FOR K := 1 TO SLGTH DO WRITE(PRR,SVAL[K]:1);
                      FOR K := SLGTH+1 TO STRGLGTH DO WRITE(PRR,' ');
                     END;
                     WRITELN(PRR,'''')
                   END
                 ELSE IF FOP = 42 THEN WRITELN(PRR,CHR(FP2))
                      ELSE WRITELN(PRR,FP2:12);
                MES(FOP)
              END
          END;
        IC := IC + 1
      END (*GEN1*) ;
 
      PROCEDURE GEN2(FOP: OPRANGE; FP1,FP2: INTEGER);
        VAR K : INTEGER;
      BEGIN
        IF PRCODE THEN
          BEGIN PUTIC; WRITE(PRR,MN[FOP]:4);
            CASE FOP OF
              45,50,54,56:
                WRITELN(PRR,' ',FP1:3,FP2:8);
              47,48,49,52,53,55:
                BEGIN WRITE(PRR,CHR(FP1));
                  IF CHR(FP1) = 'M' THEN WRITE(PRR,FP2:11);
                  WRITELN(PRR)
                END;
              51:
                CASE FP1 OF
                  1: WRITELN(PRR,'I ',FP2);
                  2: BEGIN WRITE(PRR,'R ');
                       WITH CSTPTR[FP2]^ DO
                         FOR K := 1 TO STRGLGTH DO WRITE(PRR,RVAL[K]);
                       WRITELN(PRR)
                     END;
                  3: WRITELN(PRR,'B ',FP2);
                  4: WRITELN(PRR,'N');
                  6: WRITELN(PRR,'C ''':3,CHR(FP2),'''');
                  5: BEGIN WRITE(PRR,'(');
                       WITH CSTPTR[FP2]^ DO
                         FOR K := 0 TO 58 DO
                           IF K IN PVAL THEN WRITE(PRR,K:3);
                       WRITELN(PRR,')')
                     END
                END
            END;
          END;
        IC := IC + 1; MES(FOP)
      END (*GEN2*) ;
 
      PROCEDURE GENTYPINDICATOR(FSP: STP);
      BEGIN
        IF FSP<>NIL THEN
          WITH FSP^ DO
            CASE FORM OF
             SCALAR: IF FSP=INTPTR THEN WRITE(PRR,'I')
                     ELSE
                       IF FSP=BOOLPTR THEN WRITE(PRR,'B')
                       ELSE
                         IF FSP=CHARPTR THEN WRITE(PRR,'C')
                         ELSE
                           IF SCALKIND = DECLARED THEN WRITE(PRR,'I')
                           ELSE WRITE(PRR,'R');
             SUBRANGE: GENTYPINDICATOR(RANGETYPE);
             POINTER:  WRITE(PRR,'A');
             POWER:    WRITE(PRR,'S');
             RECORDS,ARRAYS: WRITE(PRR,'M');
             FILES,TAGFLD,VARIANT: ERROR(500)
            END
      END (*TYPINDICATOR*);
 
      PROCEDURE GEN0T(FOP: OPRANGE; FSP: STP);
      BEGIN
        IF PRCODE THEN
          BEGIN PUTIC;
            WRITE(PRR,MN[FOP]:4);
            GENTYPINDICATOR(FSP);
            WRITELN(PRR);
          END;
        IC := IC + 1; MES(FOP)
      END (*GEN0T*);
 
      PROCEDURE GEN1T(FOP: OPRANGE; FP2: INTEGER; FSP: STP);
      BEGIN
        IF PRCODE THEN
          BEGIN PUTIC;
            WRITE(PRR,MN[FOP]:4);
            GENTYPINDICATOR(FSP);
            WRITELN(PRR,FP2:11)
          END;
        IC := IC + 1; MES(FOP)
      END (*GEN1T*);
 
      PROCEDURE GEN2T(FOP: OPRANGE; FP1,FP2: INTEGER; FSP: STP);
      BEGIN
        IF PRCODE THEN
          BEGIN PUTIC;
            WRITE(PRR,MN[FOP]: 4);
            GENTYPINDICATOR(FSP);
            WRITELN(PRR,FP1:3,FP2:8);
          END;
        IC := IC + 1; MES(FOP)
      END (*GEN2T*);
 
      PROCEDURE LOAD;
      BEGIN
        WITH GATTR DO
          IF TYPTR <> NIL THEN
            BEGIN
              CASE KIND OF
                CST:   IF (TYPTR^.FORM = SCALAR) AND (TYPTR <> REALPTR) THEN
                         IF TYPTR = BOOLPTR THEN GEN2(51(*LDC*),3,CVAL.IVAL)
                         ELSE
                           IF TYPTR=CHARPTR THEN
                             GEN2(51(*LDC*),6,CVAL.IVAL)
                           ELSE GEN2(51(*LDC*),1,CVAL.IVAL)
                       ELSE
                         IF TYPTR = NILPTR THEN GEN2(51(*LDC*),4,0)
                         ELSE
                           IF CSTPTRIX >= CSTOCCMAX THEN ERROR(254)
                           ELSE
                             BEGIN CSTPTRIX := CSTPTRIX + 1;
                               CSTPTR[CSTPTRIX] := CVAL.VALP;
                               IF TYPTR = REALPTR THEN
                                 GEN2(51(*LDC*),2,CSTPTRIX)
                               ELSE
                                  GEN2(51(*LDC*),5,CSTPTRIX)
                             END;
                VARBL: CASE ACCESS OF
                         DRCT:   IF VLEVEL<=1 THEN
                                   GEN1T(39(*LDO*),DPLMT,TYPTR)
                                 ELSE GEN2T(54(*LOD*),LEVEL-VLEVEL,DPLMT,TYPTR);
                         INDRCT: GEN1T(35(*IND*),IDPLMT,TYPTR);
                         INXD:   ERROR(400)
                       END;
                EXPR:
              END;
              KIND := EXPR
            END
      END (*LOAD*) ;
 
      PROCEDURE STORE(VAR FATTR: ATTR);
      BEGIN
        WITH FATTR DO
          IF TYPTR <> NIL THEN
            CASE ACCESS OF
              DRCT:   IF VLEVEL <= 1 THEN GEN1T(43(*SRO*),DPLMT,TYPTR)
                      ELSE GEN2T(56(*STR*),LEVEL-VLEVEL,DPLMT,TYPTR);
              INDRCT: IF IDPLMT <> 0 THEN ERROR(400)
                      ELSE GEN0T(26(*STO*),TYPTR);
              INXD:   ERROR(400)
            END
      END (*STORE*) ;
 
      PROCEDURE LOADADDRESS;
      BEGIN
        WITH GATTR DO
          IF TYPTR <> NIL THEN
            BEGIN
              CASE KIND OF
                CST:   IF STRING(TYPTR) THEN
                         IF CSTPTRIX >= CSTOCCMAX THEN ERROR(254)
                         ELSE
                           BEGIN CSTPTRIX := CSTPTRIX + 1;
                             CSTPTR[CSTPTRIX] := CVAL.VALP;
                             GEN1(38(*LCA*),CSTPTRIX)
                           END
                       ELSE ERROR(400);
                VARBL: CASE ACCESS OF
                         DRCT:   IF VLEVEL <= 1 THEN GEN1(37(*LAO*),DPLMT)
                                 ELSE GEN2(50(*LDA*),LEVEL-VLEVEL,DPLMT);
                         INDRCT: IF IDPLMT <> 0 THEN
                                   GEN1T(34(*INC*),IDPLMT,NILPTR);
                         INXD:   ERROR(400)
                       END;
                EXPR:  ERROR(400)
              END;
              KIND := VARBL; ACCESS := INDRCT; IDPLMT := 0
            END
