;
;	MULTI-WORD ARITHMETIC MACROS.
;
;
;	NOTE: ALL MACROS MAY DESTROY REGISTERS 4 AND 5
;	      EXCEPTIONS ARE NOTED
;
	.MACRO	MOV3 A,B
	MOV	#A,R5
	MOV	#B,R4
	MOV	(R5)+,(R4)+
	MOV	(R5)+,(R4)+
	MOV	(R5),(R4)
	.ENDM
;
	.MACRO	CMP3 A,B,?L1
	MOV	#A+4,R5
	MOV	#B+4,R4
	CMP	(R5),(R4)
	BNE	L1
	CMP	-(R5),-(R4)
	BNE	L1
	CMP	-(R5),-(R4)
L1:
	.ENDM
;
	.MACRO	ADD3 A,B 
	MOV	#A,R5
	MOV	#B,R4
	ADD	(R5)+,(R4)+
	ADC	(R4)+
	ADC	(R4)
	ADD	(R5)+,-2(R4)
	ADC	(R4)
	ADD	(R5),(R4)
	.ENDM
;
	.MACRO	SUB3 A,B
	MOV	#A,R5
	MOV	#B,R4
	SUB	(R5)+,(R4)+
	SBC	(R4)+
	SBC	(R4)
	SUB	(R5)+,-2(R4)
	SBC	(R4)
	SUB	(R5),(R4)
	.ENDM
;
	.MACRO	CLR3 A		;DOES NOT AFFECT R4
	MOV	#A,R5
	CLR	(R5)+
	CLR	(R5)+
	CLR	(R5)
	.ENDM

	.MACRO	NEG3 A			;DOES NOT AFFECT R4
	MOV	#A+4,R5
	COM	(R5)
	COM	-(R5)
	COM	-(R5)
	ADC	(R5)+
	ADC	(R5)+
	ADC	(R5)
	.ENDM
;
	.MACRO	MOV2 A,B		;USES NO REGISTERS
	MOV	A,B
	MOV	A+2,B+2
	.ENDM
;
	.MACRO	CMP2 A,B,?L1		;USES NO REGISTERS
	CMP	A+2,B+2
	BNE	L1
	CMP	A,B
L1:	
	.ENDM
;
	.MACRO	ADD23 A,B		;DOES NOT USE R4
	MOV	#B,R5
	ADD	A,(R5)+
	ADC	(R5)+
	ADC	(R5)
	ADD	A+2,-2(R5)
	ADC	(R5)
	.ENDM
;
	.MACRO	SUB23 A,B		;DOES NOT USE R4
	MOV	#B,R5
	SUB	A,(R5)+
	SBC	(R5)+
	SBC	(R5)
	SUB	A+2,-2(R5)
	SBC	(R5)
	.ENDM
;
	.MACRO	CLR2 A			;USES NO REGISTERS
	CLR	A
	CLR	A+2
	.ENDM

	.MACRO	ADD2 A,B		;USES NO REGISTERS
	ADD	A,B
	ADC	B+2
	ADD	A+2,B+2
	.ENDM
;
	.MACRO	SUB2 A,B		;USES NO REGISTERS
	SUB	A,B
	SBC	B+2
	SUB	A+2,B+2
	.ENDM
;
	.MACRO	NEG2 A			;DOES NOT USE R4
	MOV	#A+2,R5
	COM	(R5)
	COM	-(R5)
	ADC	(R5)+
	ADC	(R5)
	.ENDM
;
	.MACRO	MUL12 A,B,C,?L1		;C MUST BE A REGISTER OTHER THAN R4,R5
	MOV	#B+2,C			;IT IS DESTROYED BY THE MACRO
	MOV	(C)+,R4
	MUL	A,R4
	MOV	R4,(C)
	MOV	R5,-(C)
	MOV	-(C),R4
	MUL	A,R4
	BPL	L1
	ADD	A,2(C)
	ADC	4(C)
	DEC	4(C)
L1:	MOV	R5,(C)+
	ADD	R4,(C)+
	ADC	(C)
	.ENDM
;

