
LM ERICSSON				PASCAL USER MANUAL		1(22)
[L/Ufe Seved Torstendahl		1977-04-22	A
 
 
 
 
 
 
 
 
 
 
			PASCAL FOR PDP 11 UNDER RSX-11M
			===============================
 
 
			Summary
 
			This report is intended as a supplement to the
			book Pascal User Manual and Report by Jensen and
			Wirth (Second Edition, Springer Verlag, 1975).
			It describes a PDP 11 implementation of Pascal
			under the operating system RSX-11M.
 
 
 
 
 
 
			Contents
			--------
 
 
			1	Usage of the PASCAL compiler
			  1.1	  How to compile
			  1.2	  How to link
			  1.3	  How to run a PASCAL program
			2	Extensions
			  2.1	  Character set and special symbols
			  2.2	  The PROGRAM statement
			  2.3	  Standard constants
			  2.4	  Standard files
			  2.5	  The extended CASE statement
			  2.6	  The LOOP statement
			  2.7	  Standard procedures
			  2.8	  Standard functions
			  2.9	  Procedures and functions as parameters
			  2.10	  Separate compilation
			3	Restrictions
			4	Compiler options
			5	Representation
 
 
			Appendices
 
			A	Character set
			B	Special symbols
			C	Reserved words
			D	Standard procedures
			E	Standard functions
			F	Error codes

LM ERICSSON				PASCAL USER MANUAL		2
					1977-04-22	A

 
 
		1	USAGE OF THE PASCAL COMPILER
 
		1.1	How to compile
 
			The compiler is activated in the standard way:
			>PAS  <object>,<list>=<source>
			The file descriptins follow RSX standard,
			i.e. dev:[p,pn]file.ext/sw. Default values are
			dev:	SY0:
			[p,pn]	fetched from user terminal table
			.ext	.OBJ, .LST or .PAS respectively
 
			The only switch allowed is /-SP on the
			list file to prevent spooling, which is
			otherwise automatic.
 
			Ex.   	PAS  EX,EX/-SP=EX
				PAS  T.OBJ,L=DK1:[200,200]EX2.PAS
 
			Object and listfiles are optional. Ex.
				PAS  EX2=EX2
				PAS  ,EX3=EX3
 
 
			Two error signals can be generated at this
			point. Both cause immediate exit from the
			compiler:
			-	FILE NOT FOUND  if there is no file with
				the given name
			-	FILE SPECIFICATION ERROR  if  '=' is not 
				found or if no source filename is given
 
 
		1.2	How to link Pascal programs
 
			Pascal programs are linked by the normal
			linker: TKB. It is used as for all object modules
			>TKB  <task>,<map>,<symtab>=<object>
 
			The file names are given as above,and only
			the object file(s) are mandatory. Dynamic
			memory is reserved according to the compilation
			report. If more storage is needed, the size
			of the PSECTion $HEAP1 can be extended. Ex.
			>TKB
			TKB>EX4,EX4=EX4
			TKB>/
			ENTER OPTIONS:
			TKB>EXTSCT=$HEAP1:1000.	; ADD 1000. BYTES
			TKB>//

 
		1.3	How to execute a Pascal program
 
			The program is activated the ordinary way. Ex.
			>RUN EX4

LM ERICSSON				PASCAL USER MANUAL		3
					1977-04-22	A
 
 
 
		2	EXTENSIONS
 
		2.1	Character set and special symbols
 
			Many installations have character sets with the
			bracket symbols replaced with national characters.
			In order to make it easy to write readable programs
			it was necessary to allow a special symbol
			combination as well. New special symbols are:
			(.	left bracket
			.)	right bracket
			(*	start of comment
			*)	end of comment
			#	<>   (* not equal *)
 
 
		2.2	The PROGRAM statement
 
			A Pascal program must as a first statement have:
			PROGRAM  <name> <program parameter list>;
			The parameter list may be empty, or give oneor
			more of INPUT, OUTPUT and TTY. When a file is mentioned
			it is equivalent with a declaration of textfiles
			with these names. For files not mentioned no space
			will be reserved. The file TTY is treated in a
			special way, and is bound to the user's terminal
			( TI: in RSX-11M ). The initial state ofTTY is
			eoln(TTY) = true and no characters automatically
			input. Examples:
				PROGRAM COPY ( INPUT, OUTPUT );
				PROGRAM DIALOG ( TTY );
				PROGRAMINTROVERT;
 
 
		2.3	Standard constants
 
			The integer constants MAXINT and MININT are defined as
			CONST MAXINT = 077777B (*  32767 *);
			      MININT = 100000B (* -32768 *);
 
			The real constants MAXREAL,  MINREAL and
			SMALLREAL are defined as
			CONST	MAXREAL   = 1.7014111E+38;
				MINREAL   = 1.5224277E-39;
				SMALLREAL = 1.1983428E-7;
			They represent the absolutely greatest and
			smallest reals, and SMALLREAL is the smallest
			value that makes 1.0+SMALLREAL<>1.0 .
 
 
		2.4	Standard files
 
			In addition to the standard textfiles
			INPUT and OUTPUT the standard textfile TTY is
			available. This file is used to communicate
			with the user's terminal ( TI: of RSX-11M). This
			file can be opened only through the program
			statement.

LM ERICSSON				PASCAL USER MANUAL		4
					1977-04-22	A
 
 
 
		2.5	The extended CASE statement
 
			The CASE statement may be extended with the case
			OTHERS. The statement associated with
			OTHERS will be executed if the expression ofthe
			CASE statement does not evaluate to one of the
			explicitly given case labels. Syntax:
 
			<case statement> ::= CASE <expression> OF
			     <case element>  { ;<case element> }  END
			<case element> ::= <case label list> : <statement> !
					   <empty>
			<case label list> ::= <case label> { ,<case label> } !
					      OTHERS
 
			Example:
				VAR X: CHAR;
				  ...
				CASE X OF
				  'A':	P(X);
				  'B':	Q(X);
				  ...
				  OTHERS:	Z(X)
				END;
 
 
		2.6	The LOOP statement
 
			The LOOP statement is an additionalcontrol
			statement which combines the effects of WHILE
			and REPEAT statements. Syntax:
 
			<loop statement> ::= LOOP
					      <statement part>
					     EXIT IF <expression>;
					      <statement part>
					     END
			<statement part> ::= <statement>  { ;<statement> }
 
			The expression must result in a Boolean value.
 
 
		2.7	Standard procedures
 
		2.7.1	DATE and TIME
 
			The procedure DATE( <alfa variable> ) assigns
			the current date in the format '19yy-mm-dd'
			to the parameter which must be of type
			PACKED ARRAY  (.1..10.) OF CHAR.
 
			The procedure TIME( <alfa variable> ) assigns
			the daytime in the format 'hh:mm:ss.t'
			to the parameter which must be of type
			PACKED ARRAY  (.1..10.) OF CHAR.

LM ERICSSON				PASCAL USER MANUAL		5
					1977-04-22	A
 
 
		2.7.2	MARK and RELEASE
 
			There is no procedure DISPOSE but the pair
			MARK and RELEASE takes care of deallocation
			when a nested structure is used. MARK puts
			a mark in the heap and RELEASE releases all
			storage above the topmost mark in the heap.
			They have no parameters, but for compatibility
			with the PASREL compiler on DEC10 they may
			be calledwith one (unused) parameter.
 
 
		2.7.3	HALT
 
			The procedure HALT can be used to help debug
			Pascal programs. A call of HALT gives a dump
			of the stack and heap, and exit from the program.
 
 
		2.7.4	RESET and REWRITE
 
			The standard procedures RESET(f) and REWRITE(f)
			are extended to allow up to 5 parameters:
				RESET(f,filename,dir,dev,iospec)   and
				REWRITE(f,filename,dir,dev,iospec)
			Only as many parameters as necessary need be
			present. They must be declared as:
 
			f:	FILE OF <type>;
 
			filename: ARRAY OF CHAR or string constant to give
				an external file name. Examples:
				'SOURCE.PAS','TEXT.TXT;3' or  a string
				variable containing 'FILE2.EX     '.

			dir:	ARRAY OF CHAR or string constant to give
				a file directory. Example:
				'(40,13)',(200,200)'. The parentheses are
				automaticaly translated to brackets.
 
			dev:	ARRAY OF CHAR or string constant to give
				device name. Example:
				'SY:','LP0:'

LM ERICSSON				PASCAL USER MANUAL		6
					1977-04-22	A
 
 
 
			iospec:	SET OF (RANDOM,UPDATE,APPEND,TEMPORARY,
					INSERT,SHARED,SPOOL,BLOCK);
					The set has to be declared by the
					user. If present, the members
					of the set mean (cf RSX-11M):
			    RANDOM	the records of the file may be fetched
					in random order
			    UPDATE	an existing file shall be changed
			    APPEND	an existing file shall be appended
			    TEMPORARY	a temporary file shall be used
			    INSERT	together with UPDATE thiscondition
					gives that the file shall not be
					truncated if written into
			    SHARED	the file is opened  in such a way that
					other tasks may open it too.
			    SPOOL	this textfile shall, when closed,
					be handed over to the print spooler
					for printing on the line printer.
			    BLOCK	enables blockwise read and write. Only
					one file element is read or written,
					even if more than one can be contained
					in one block.
 
 
			For bothRESET and REWRITE f is the only mandatory
			parameter. The other parameters have default
			values if left out in a call:
 
			filename: the internal nameof the file variable
			dir:	default uic from RSX-11M
			dev:	'SY0:'
			iospec:	(..)   the empty set
			Example: RESET(F) is equivalent to
				 RESET(F,'F',,'SY0:',(..))
 
 
		2.7.5	BREAK and PAGE
 
			The procedure PAGE( <textfile> ) inserts a form
			feed in the given file. It may be called without
			parameter in which case it is assumed to be
			the standard file OUTPUT if present in the PROGRAM
			statement, otherwise TTY if present.
 
			The procedure BREAK has no parameter. It causes
			the buffer to TTY to be written without carriage
			return and line feed added. Thereby a later input
			from TTY can be given on the same line.

LM ERICSSON				PASCAL USER MANUAL		7
					1977-04-22	A
 
 
 
		2.7.6	GET and PUT
 
			The standard procedures GET and PUT can take a
			second parameter of type integer. This parameter
			has effect only if RANDOM or BLOCK was specified
			when opening the file. In case of RANDOM it is
			the number of the record to be input from the
			file (GET) or written to the file (PUT). If the
			file was opened with BLOCK in iospec one file
			element is transferred to or from the block
			with the given number.
 
 
		2.8	Standard functions
 
		2.8.1	RUNTIME
 
			The function RUNTIME returns aninteger giving
			the daytime in seconds modulo 8 hours (RSX-11M
			doesn't measure CPU time ).
 
		2.8.2	TWOPOW and SPLITREAL
 
			The function TWOPOW(<integer expression>):REAL gives
			as result the real  2**<integer expression>.
 
			The function SPLITREAL(<real expression>,
			<integer variable>):REAL returns the binary
			exponent of the real expression in the integer
			variable and gives as result a  real with binary
			exponent zero but the same mantissa as the 
			expression.
 
		2.8.3	IORESULT
 
			The function IORESULT(<file>):INTEGER returns an
			integer value telling the result of the last
			operation on the given file. Result = +1 if
			OK and <0 if error. The error codes are those
			returned from RSX-11M. For further details see
			RSX-11M manuals.

LM ERICSSON				PASCAL USER MANUAL		8
					1977-04-22	A
 
 
 
		2.9	Procedures and functions as parameters
 
			In PDP-11-Pascal it is necessary to declare
			the formal parameters of a formal procedure
			or function. At the declaration of a formal
			procedure or function no identifier is required
			for the formal parameters of it, only the
			type(s) of the argument(s) must be specified.
 
 
			The declaration of  "formal formal parameters" is
			necessary for the compiler to check the actual
			procedure- and function-parameters with respect
			to their parameters and types. This avoids a
			considerable overhead of parameter- and type-checking
			at runtime of a Pascal program.
 
			Example:
			PROGRAM INTEGRATION;
			FUNCTION INTEGRATE ( FUNCTION F (REAL):REAL;
				LOWBOUND, HIGHBOUND, DELTA: REAL ): REAL;
				(* BODY *) ...
			FUNCTION SINUS ( ARG: REAL ): REAL;
			  BEGIN   SINUS := SIN( ARG );
			  END;

			BEGIN
			  WRITELN( INTEGRATE( SINUS, 0, 3.14, 0.01 );
			END.
 
			Note that external procedures and functions not
			written in Pascal and standardprocedures and
			-functions must not be used as actual parameters
			to formal procedures or functions since they
			obey different parameter conventions.

		2.10	Separate compilation
 
			It is possible to compile  one or more procedures
			without a main program. In that case no program
			statement is allowed and the source file must
			begin with an option comment stating M-. For
			further details see paragraph 4.7 below.
 
			Separately compiled procedures and functions
			can be accessed if they are declared with the
			procedure body replaced by EXTERN. Fortran and
			assembler-written routines can also be accessed
			if their parameter transport follows Pascal standard
			or Fortran. In  the latter case the procedure body
			should be replaced by EXTERN( FORTRAN ). If the
			external name contains '$' or '.' it can be given as
			a string constant. Example:
			EXTERN( FORTRAN, '$TEST' )

LM ERICSSON				PASCAL USER MANUAL		9
					1977-04-22	A
 
 
		3	RESTRICTIONS
 
 
		3.1	Reserved words
 
			The folling words are also reserved:
			LOOP	EXIT	OTHERS	EXTERN
 
 
		3.2	Packed structures
 
			Packed data structures are only implemented
			for character arrays ( always packed, two
			char's per word ) and for Booleanarrays
			( packing optional, one Boolean per word ).
			The procedures PACK and UNPACK are not implemented.
 
 
		3.3	GOTO statement
 
			The GOTO statement is restricted to allow
			only local GOTO's.
 
 
		3.4	SET size
 
			The representation of sets is chosen so that
			a set may have at most 64 members.
 
 
		3.5	File declarations
 
			Files may be declared only in the main program.
 
 
		3.6	Parameter transmission
 
			Standard procedures or functions or external
			Fortran routines may not be passed as parameters.
 

LMERICSSON				PASCAL USER MANUAL		10
					1977-04-22	A
 
 
 
		4	COMPILER OPTIONS
 
			When compiling a Pascal program it is possible
			to select some special features called options.
			All option switches have default values. Some
			can be changed dynamically and some may be set
			only before the first statement.
			Option switches are turned on and off  through
			comments beginning with '$' ( =chr(44B)) followed
			by one or more option selectors, separated by
			commas. Each option selector consists of one
			letter followed by '+'or '-'. Example:
			(*$L+,C-,M+*)
 
 
		4.1	Program listing: L
 
			Listing of the source program may be
			switched on and off during compilation.
			Default: L+.
 
 
		4.2	Listing of generated code: C
 
			With the crosscompiler on DEC 10 it is possible
			to get a listing of the generated code. The
			switch can be changed dynamically. The listing
			is done on a separate file with extension .CXP .
			Default: C-.
 
 
		4.3	Extended instruction set, EIS: E
 
			The compiler generates MUL and DIV instructions
			if option E+ is selected, otherwise these
			operations are performed through subroutines.
			Default: E-.
 
 
		4.4	Floating instruction set, FIS: G
 
			The PDP 11/35 and 40 floating point hardware
			can be used if option G is selected.
			Default: G-.
 
 
		4.5	Floting point processor, FPP: F
 
			The floating point hardware for PDP 11 model
			45 and up can be used if option F is selected.
			Default: F-.

LM ERICSSON				PASCAL USER MANUAL		11
					1977-04-22	A
 
 

		4.6	Runtime checks: R and T
 
			The compiler can generate checks of dynamic 
			starage and stack allocation at procedure and
			function entry and calls of NEW. Default: T+.
 
			Checks of assignment to subrange variables and
			of array indices are normally generated, but
			can be suppressed by settingoption R-. Default: R+.
 
 
		4.7	Main program: M
 
			It is possible to compile a set of procedures
			and functions separately. In that case no
			PROGRAM statement and no main program may
			be given, and the source text must begin
			with an option selection of M-. Default: M+.
 
 
		4.8	Conditional compilation: X and Z
 
			It is possible to write test statements which
			generate code only if option X+ is selected.
			Default: X-.
 
			The conditionalparts of the code must be
			enclosed in a special option parenthesis,
			(*$Z+*) <conditionally compiled code> (*$Z-*).
 
 
		5.9	Warning suppression: W
 
			Error messages classified as warnings may be
			suppressed by selecting option W-. Warning
			error numbers are > 900.
			Default: W+.
 
 
		5.10	Object module splitting: Y
 
			The generated object code can be splitted
			into several object modules (in one file)
			through insertion of option Y+ in
			the source  after a procedure declaration
			heading or before a procedure body.
			This option is implemented to allow the
			compiler to be overlaid in PDP 11.
			Default: Y-.

LM ERICSSON				PASCAL USER MANUAL		12
					1977-04-22	A
 
 
 
		5	REPRESENTATION
 
		5.1	Scalars
 
			Integers, booleans andcharacters occupy one
			word each. Reals occupy two words with one
			sign bit, one exponent sign bit, seven exponent 
			bits and a mantissa of 23 bits plus one bit hidden.
			Sets of up to 16 members occupy one word and
			sets of up to 64 members occupy four words.
 
 
		5.2	Files
 
			See also RSX-11M I/O Operations Reference Manual.
			Files are represented as fixlength record files
			except textfiles which have variable length
			records, one line per record. They are used
			in locate mode. File description blocks are
			allocated in the stack and a file declaration
			thus reserves 108 bytes plus the size of one
			record of the file. For textfiles the maximum
			line length is 132 characters for which a
			buffer is reserved.
 
 
		5.3	Stack and heap
 
			The stack and heap are given a contiguous area
			in which the stack grows from one end and the
			heap from the other. This area can be extended
			through a command to the Linker, See 1.2.
 
 
		5.4	Parameter transmission
 
			The Pascal stack is reached through register R5.
			An assembler routine, declared in a Pascal
			program as:
				function A( I,J: integer ): integer;
					extern;
			will receive a stack as follows:
				R5+6:	reserved for result (functions only)
				R5+4:	value I (first parameter)
				R5+2:	value J ( last parameter)
				R5:	link
			At return by RTS PC the stack pointer must point to
			the result word for functions, or above the parameters
			for procedures.
 
			For other parameter types the area reserved
			on the stack will be as large as required to
			hold the desired value. For VAR parameters
			one word containing an address is reserved.

LM ERICSSON				PASCAL USER MANUAL		13
					1977-04-22	A
 
 
 
			APPENDICES
			==========
 
 
 
		A	Character set
 
			The Pascal character set ( type char ) is 
			encircled in the following table. The compiler
			ignores all characters below SP except HT, which
			is transformed to SP. The compiler allowes
			lower case characters, but translates them
			to upper case except in strings.
 
			Characters can be checked to be in the right
			intervall in a user program if the option
			R+ is selected, see 4.6.
 
 
				    0	1   2	3   4	5   6	7
 
				00  NUL SOH STX ETX EOT ENQACK BEL
				01  BS  HT  LF  VT  FF  CR  SO  SI
				02  DLE DC1 DC2 DC3 DC4 NAK SYN ETB
				03  CAN EM  SUB ESC FS  GS  RS  US
			   --------------------------------------------
			   I    04  SP  !   "   #   $   %   &   '     I
			   I    05  (   )   *   +   ,   -   .   /     I
			   I    06  0   1   2   3   4   5   6   7     I
			   I    07  8   9   :   ;   <   =   >   ?     I
			   I    10  @   A   B   C   D   E   F   G     I
			   I    11  H   I   J   K   L   M   N   O     I
			   I    12  P   Q   R   S   T   U   V   W     I
			   I    13  X   Y   Z   [   \   ]   ^   _     I
			   --------------------------------------------
			        14  `   a   b   c   d   e   f   g    
			        15  h   i   j   k   l   m   n   o    
			        16  p   q   r   s   t   u   v   w    
			        17  x   y   z   {   |   }   ~   DEL 
 
 
			Only A..Z are considered as letters by the
			compiler. For pointers the character
			^ is used, which sometimes is printed as uparrow( ).
 
			For historical reasons comments may be enclosed
			in %comment \ (backslash) as well as (* *), but
			not in { } (curly brackets).
 

LM ERICSSON				PASCAL USER MANUAL		14
					1977-04-22	A
 
 
 
		B	Special symbols
 
			Table of special symbols with their meaning.
 
			Stand-	Altern-	Meaning
			ard	ative
 
			:=		assignment
			+		with one operand: identity
			-		with one operand: negation
			+		with two operands: addition
			-		with two operands: subtraction
			*		multiplication
			/		real division
			div		integer division
			mod		remainder
			=		equal
			<>	#	not eqaul
			<		less
			>		greater
			<=		less or eqaul
					set inclusion
			>=		greater or equal
			in		set membership
			not		negation
			or		disjunction
			and		conjunction
			or		set union
			-		set difference
			and		set intersection
			(*	%	start of comment
			*)	\	end of comment
			.		decimal point
					end of program
			..		subrange constructor
			,		comma
			:		colon
			;		statement separator
			'		string delimiter
			(		left parenthesis
			)		right parenthesis
			[	(.	left bracket
					set constructor
			]	.)	right bracket
					set constructor
			^		pointer constructor
			$		option constructor

LM ERICSSON				PASCAL USER MANUAL		15
					1977-04-22	A
 
 
 
		C	Reserved words
 
 
			The following words are reserved:
 
			if	do	of	to	in
			or	end	for	var	div
			mod	set	and	not	then
			else	with	goto	loop	case
			type	file	exit	begin	until
			while	array	label	const	others
			repeat	record	downto	packed	extern
			forward	function	procedure

LM ERICSSON				PASCAL USER MANUAL		16
					1977-04-22	A
 
 
 
		D	Standard procedures
 
			This is only a list of standard procedures,
			with an indication of parameter types.
 
			Input/output:
 
			  RESET(FILE, STRING, STRING, STRING, SET)
			  REWRITE(FILE, STRING, STRING, STRING, SET)
			  GET(FILE)
			  GET(FILE,INTEGER)
			 PUT(FILE)
			  PUT(FILE,INTEGER)
			  PAGE(FILE)
			  READ(FILE,INTEGER or REAL or CHAR or BOOLEAN, ... )
			  READLN(FILE,INTEGER or REAL or CHAR or BOOLEAN, ... )
			  WRITE(FILE,INTEGER or REAL or CHAR or BOOLEAN, ... )
			  WRITELN(FILE,INTEGER or REAL or CHAR or BOOLEAN, ... )
			  BREAK
 
			Execution control:
 
			  HALT
 
			Administration of dynamic storage:
 
			  NEW(POINTER,variant selector, ... )
			  MARK
			  RELEASE
 
			Miscellaneous:
 
			  DATE(STRING)
			  TIME(STRING)

LM ERICSSON				PASCAL USER MANUAL		17
					1977-04-22	A
 
 
 
		E	Standard functions
 
			This is a list of standard functions with an
			indication of parameter types.
 
			Mathematical functions:
 
			  ABS(INTEGER or REAL):INTEGER or REAL
			  COS(INTEGER or REAL):REAL
			  EXP(INTEGER or REAL):REAL
			  LN(INTEGER or REAL):REAL
			  SIN(INTEGER or REAL):REAL
			  SQR(INTEGER or REAL):INTEGER or REAL
			  SQRT(INTEGER or REAL):REAL
 
			Conversion routines:
 
			  ROUND(REAL):INTEGER
			  TRUNC(REAL):INTEGER
			  CHR(INTEGER):CHAR
			  ORD(any scalar except REAL):INTEGER
 
			Miscellaneous:
 
			  ODD(INTEGER):BOOLEAN
			  EOF(FILE):BOOLEAN
			  EOLN(FILE):BOOLEAN
			  PRED(any scalar except REAL):same as argument
			  SUCC(any scalar except REAL):same as argument
			  RUNTIME:INTEGER
			  SPLITREAL(REAL,INTEGER):REAL
			  TWOPOW(INTEGER):REAL

LM ERICSSON				PASCAL USER MANUAL		18
					1977-04-22	A
 
 
 
		F	Error codes
 
 
		F.1	Compiletime errors
			 
			 1	error in simple type
			 2	identifier expected
			 3	error in value part
			 4	')' expected
			 5	':' expected
			 6	illegal symbol
			 7	error in parameterlist
			 8	'of' expected
			 9	'(' expected
			 
			10	error in type
			11	'[' expected
			12	']' expected
			13	'end' expected
			14	';' expected
			15	integer expected
			16	'=' expected
			17	'begin'expected
			18	error in declaration part
			19	error in fieldlist
 
			20	',' expected
			21	constant expected
			22	'program' expected
			23	standard files only 'input', 'output', 'tty'
 
			50	error in constant
			51	':=' expected
			52	'then' expected
			53	'until' expected
			54	'do' expected
			55	'to'/'downto' expected
			56	'if' expected
			57	'exit' expected
			58	error in factor
			59	error in variable
 
			101	identifier declared twice
			102	low bound must not be greater than high round
			103	identifier not declared
			105	sign not allowed
			106	number expected
			107	incompatible subrange type
			108	file not allowed here
			109	type must not be real

LM ERICSSON				PASCAL USER MANUAL		19
					1977-04-22	A
 
 
 
			110	tagfield must be scalaror subrange
			111	incompatible with tagfieldtype
			112	index type must not be real
			113	index type must be scalar or subrange
			114	base type must notbe real
			115	base type must be scalar or subrange
			116	error in type of standard procedure parameter
			117	unsatisfied forward reference
			118	forward referenced type identifier in variable
				declaration
			119	forward declared: repetition of parameterlist
				not allowed
 
			120	function result typemust not be files
			121	file value parameter not allowed
			122	forward declared function:
				repetition of result type not allowed
			123	missing resulttype in function declaration
			124	fixed format for real only
			125	error in type of standard function parameter
			126	number of parameters does not agree with
				declaration
			127	illegal parameter substitution
			128	result type of parameter function does not
				agree with declaration
			129	type conflict of operands
 
			130	expression is not of set type
			131	tests on equality allowed only
			132	strict inclusion not allowed
			133	file comparison notallowed
			134	illegal type of operand(s)
			135	type of operand must be boolean
			136	set element type must be scalar or subrange
			137	set element types not compatible
			138	type of variable is not array
			139	index type is notcompatible with declaration
 
			140	type of variable is not record
			141	type of variable must be file or pointer
			142	illegal parameter substitution
			143	illegal type of loop control variable
			144	illegal type of expression
			145	type conflict
			146	assignment of files not allowed
			147	label typeincompatible with selecting 
				expression
			148	subrange bounds must be scalar
			149	index type must not be integer
 
			150	assignment to standard function not allowed
			151	assignment to formal function is not allowed
			152	no such field in this record
			153	type error in read
			154	actual parametermust be a variable
			155	control variable must not be formal
			156	multidefined case label
			157	too many cases in case statement
			158	missing corresponding variant declaration
			159	real and string tagfields not implemented

LM ERICSSON				PASCAL USER MANUAL		20
					1977-04-22	A
 
 
 
			160	previous declaration was not forward
			161	again forward declared
			162	slice variant separator is colon
			163	missing variant in declaration
			164	missing slice variant in declaration
			165	multidefined label
			166	multideclared label
			167	undeclared label
			168	undefined label
			169	error in tagfield
 
			170	variant must have the same type as tagfield
 
			180	standard file not in program statement
			181	'input', 'output' or 'tty' missing in program
				statement
			183	body not allowed when not main
 
			201	error in real constant: digit expected
			202	string constant contains 'eol'
			203	integer constant exceeds range
			204	8 or 9 in octal number
			205	real constant exceeds range
			206	octal output format for integers only
 
			250	too many nested scopes of identifiers
			251	too many nested procedures and/or functions
			253	too much code produced
			254	too many string/set/real constants in this
				procedure
			255	too many errors in this source line
 
			399	not implemented

			400	compiler error
 
			600	indextype of boundless array must be of scalar
				type (but not of type real)
			601	colon in parameterlist must be followed by
				identifier or arraysymbol
			602	boundless arrays must be var specified
			603	standard functions/procedures are not allowed as
				actual procedure parameters
			604	ordinal numbers of setelements must lie in the
				range0..63, or ' '..'/' for characters
			605	the setvariables in an expression do not have
				the same base type
			606	base types of sets are incompatible
			607	colon is missing in the specification of
				parameters of a formal procedure/function
				(warning only)
			608	error in parameterspecification
			609	fortran routines are not allowed as actual
				procedure parameters

LM ERICSSON				PASCAL USER MANUAL		21
					1977-04-22	A
 
 
 
			610	integer constants required as actual parameters
			612	parameterlist structure of formal and actual
				procedure are not the same
 
 
			900-999	warnings only
 
			900	undeclared label
			901	unused declared label
			902	undefined option switch
 
			920	program statement missing ('input' and 'output'
				assumed)
 
			930	parameters to fortran routines must be declared
				as VAR parameters
			931	too many procedures with the first 6 characters
				in their names eqaul
 
		F.2	Runtime errors
 
			Runtime error messages are written on the terminal,
			and appear in the form
 
				PASRUN -- ERROR  nn lllll vvvvv
 
			where	nn = error number, see list below
				mmmmm = line number where error occured.
					The line number is not correct if
					the error appears in a part of the
					program where the runtime check option
					R is switched off (R-).
		
		vvvvv = offending value ( error 12 only ).
 
			There are two classes of errors:
 
			F:	Fatal errors.
				Continuation of the program is in no way
				possible or useful, and the program is
				therefore terminated. Termination of a 
				program is shown by the string EXIT, which
				is typed out on the terminal.
 
			W:	Warnings.
				After having printed the error message, the
				program will continue execution.
				See the comments.

LM ERICSSON				PASCAL USER MANUAL		22
					1977-04-22	A
 
 
 
				RUNTIME ERROR SUMMARY
				---------------------
 
			Number	Kind of operation	Comments
			------	-----------------	--------
			    Class
			    -----
 
			10  F	Procedure entry or	Stack overruns heap
				dynamic allocation	or heap overruns stack
							Too much code + data,
							or error(s) in program
							(40 words left)
 
			11 F	Same as 10		Hardware stack overflow
							(10 words left)
 
			12  F	Assignment or		Subrange overflow
				indexing in array	Index out of bounds
 
			20  F	Integer division	An attempt was made
				or modulo		to divide by 0
 
			21  F	Integer division	Divisor was -32768
				or modulo		(most negative number)
 
			23  F	Integer multiplication	First operand = -32768
 
			30  W	All real operations	Exponent overflow
							MAXREAL assumed
 
			31  W	All real operations	Exponent overflow
							Floating zero taken
 
			33  F	Trunc or round		Floating number too
							large
 
			34  F	Real division		Attempt to divide by 0
 
			40  F	Read integer or		Error in number:
				real exponent		no digits read
 
			41  F	Same as 40		Integer overflow:
							abs value = 32768
 
			42  F	Same as 40		Too many digits read
 
			66  F	Read or get		Attempt to read beyond
							end of file
 
		F.3	Result codes after I/O operations

			The result codes received by Ioresult are the 
			RSX-11M codes. Two new codes are added:
 
			-101	too many files (RESET/REWRITE)
			-102	file not opened (GET/PUT)
 
