
typedef	struct	{
	short	k_code;			/* Key code			*/
	int	(*k_fp)();		/* Routine to handle it		*/
}	KEYTAB;

extern	int	ctrlg();		/* Abort out of	things		*/
extern	int	quit();			/* Quit				*/
extern	int	ctlxlp();		/* Begin macro			*/
extern	int	ctlxrp();		/* End macro			*/
extern	int	ctlxe();		/* Execute macro		*/
extern	int	fileread();		/* Get a file, read only	*/
extern	int	filevisit();		/* Get a file, read write	*/
extern	int	filewrite();		/* Write a file			*/
extern	int	filesave();		/* Save	current	file		*/
extern	int	filename();		/* Adjust file name		*/
extern	int	getccol();		/* Get current column		*/
extern	int	gotobol();		/* Move	to start of line	*/
extern	int	forwchar();		/* Move	forward	by characters	*/
extern	int	gotoeol();		/* Move	to end of line		*/
extern	int	backchar();		/* Move	backward by characters	*/
extern	int	forwline();		/* Move	forward	by lines	*/
extern	int	backline();		/* Move	backward by lines	*/
extern	int	forwpage();		/* Move	forward	by pages	*/
extern	int	backpage();		/* Move	backward by pages	*/
extern	int	gotobob();		/* Move	to start of buffer	*/
extern	int	gotoeob();		/* Move	to end of buffer	*/
extern	int	setfillcol();		/* Set fill column.		*/
extern	int	setmark();		/* Set mark			*/
extern	int	swapmark();		/* Swap "." and	mark		*/
extern	int	forwsearch();		/* Search forward		*/
extern	int	backsearch();		/* Search backwards		*/
extern	int	showcpos();		/* Show	the cursor position	*/
extern	int	nextwind();		/* Move	to the next window	*/
extern	int	prevwind();		/* Move	to the previous	window	*/
extern	int	onlywind();		/* Make	current	window only one	*/
extern	int	splitwind();		/* Split current window		*/
extern	int	mvdnwind();		/* Move	window down		*/
extern	int	mvupwind();		/* Move	window up		*/
extern	int	enlargewind();		/* Enlarge display window.	*/
extern	int	shrinkwind();		/* Shrink window.		*/
extern	int	listbuffers();		/* Display list	of buffers	*/
extern	int	usebuffer();		/* Switch a window to a	buffer	*/
extern	int	killbuffer();		/* Make	a buffer go away.	*/
extern	int	reposition();		/* Reposition window		*/
extern	int	refresh();		/* Refresh the screen		*/
extern	int	twiddle();		/* Twiddle characters		*/
extern	int	tab();			/* Insert tab			*/
extern	int	newline();		/* Insert CR-LF			*/
extern	int	indent();		/* Insert CR-LF, then indent	*/
extern	int	openline();		/* Open	up a blank line		*/
extern	int	deblank();		/* Delete blank	lines		*/
extern	int	quote();		/* Insert literal		*/
extern	int	backword();		/* Backup by words		*/
extern	int	forwword();		/* Advance by words		*/
extern	int	forwdel();		/* Forward delete		*/
extern	int	backdel();		/* Backward delete		*/
extern	int	kill();			/* Kill	forward			*/
extern	int	yank();			/* Yank	back from killbuffer.	*/
extern	int	upperword();		/* Upper case word.		*/
extern	int	lowerword();		/* Lower case word.		*/
extern	int	upperregion();		/* Upper case region.		*/
extern	int	lowerregion();		/* Lower case region.		*/
extern	int	capword();		/* Initial capitalize word.	*/
extern	int	delfword();		/* Delete forward word.		*/
extern	int	delbword();		/* Delete backward word.	*/
extern	int	killregion();		/* Kill	region.			*/
extern	int	copyregion();		/* Copy	region to kill buffer.	*/
extern	int	spawncli();		/* Run CLI in a	subjob.		*/
extern	int	spawn();		/* Run a command in a subjob.	*/
extern	int	quickexit();		/* low keystroke style exit.	*/
