/*
 * Command table.
 * This	table  is *roughly* in ASCII order, left to right across the
 * characters of the command. This expains the funny location of the
 * control-X commands.
 */
KEYTAB	keytab[] = {
	CTRL|'@',		&setmark,
	CTRL|'A',		&gotobol,
	CTRL|'B',		&backchar,
	CTRL|'D',		&forwdel,
	CTRL|'E',		&gotoeol,
	CTRL|'F',		&forwchar,
	CTRL|'G',		&ctrlg,
	CTRL|'I',		&tab,
	CTRL|'J',		&indent,
	CTRL|'K',		&kill,
	CTRL|'L',		&refresh,
	CTRL|'M',		&newline,
	CTRL|'N',		&forwline,
	CTRL|'O',		&openline,
	CTRL|'P',		&backline,
	CTRL|'Q',		&quote,		/* Often unreachable	*/
	CTRL|'R',		&backsearch,
	CTRL|'S',		&forwsearch,	/* Often unreachable	*/
	CTRL|'T',		&twiddle,
	CTRL|'V',		&forwpage,
	CTRL|'W',		&killregion,
	CTRL|'Y',		&yank,
	CTRL|'Z',		&mvdnwind,
	CTRL|'\\',		&forwsearch,	/* alt... */
	CTRL|']',		&quote,		/* alt... */
	CTLX|CTRL|'B',		&listbuffers,
	CTLX|CTRL|'C',		&quit,		/* Hard	quit.		*/
	CTLX|CTRL|'E',		&spawncli,	/* Run CLI in subjob.	*/
	CTLX|CTRL|'F',		&filename,
	CTLX|CTRL|'L',		&lowerregion,
	CTLX|CTRL|'O',		&deblank,
	CTLX|CTRL|'N',		&mvdnwind,
	CTLX|CTRL|'P',		&mvupwind,
	CTLX|CTRL|'R',		&fileread,
	CTLX|CTRL|'S',		&filesave,	/* Often unreachable	*/
	CTLX|CTRL|'U',		&upperregion,
	CTLX|CTRL|'V',		&filevisit,
	CTLX|CTRL|'W',		&filewrite,
	CTLX|CTRL|'X',		&swapmark,
	CTLX|CTRL|'Z',		&shrinkwind,
	CTLX|CTRL|'\\',		&filesave,	/* alt... */
	CTLX|'!',		&spawn,		/* Run 1 command.	*/
	CTLX|'=',		&showcpos,
	CTLX|'(',		&ctlxlp,
	CTLX|')',		&ctlxrp,
	CTLX|'1',		&onlywind,
	CTLX|'2',		&splitwind,
	CTLX|'B',		&usebuffer,
	CTLX|'E',		&ctlxe,
	CTLX|'F',		&setfillcol,
	CTLX|'K',		&killbuffer,
	CTLX|'N',		&nextwind,
	CTLX|'O',		&nextwind,
	CTLX|'P',		&prevwind,
	CTLX|'Z',		&enlargewind,
	META|'!',		&reposition,
	META|' ',		&setmark,
	META|'>',		&gotoeob,
	META|'<',		&gotobob,
	META|'B',		&backword,
	META|'C',		&capword,
	META|'D',		&delfword,
	META|'F',		&forwword,
	META|'L',		&lowerword,
	META|'U',		&upperword,
	META|'V',		&backpage,
	META|'W',		&copyregion,
	META|'Z',		&mvupwind,
	META|0x7F,		&delbword,
	0x7F,			&backdel
};

#define	NKEYTAB	(sizeof(keytab)/sizeof(keytab[0]))
