C	SETVAXNET.FOR
C
C	THIS SUBROUTINE GETS THE CURRENT CHARACTERISTICS OF THE CHANNEL
C	ASSIGNED TO THE REMOTE VAXNET PORT.  IT THEN CHANGES THE
C	CHARACTERISTICS SO THAT THE PORT WILL WORK PROPERLY FOR VAXNET.
C	ON PROPER VAXNET TERMINATION, THE ENTRY POINT SETNORMAL IS
C	USED TO MAKE THE PORT ACCESSIBLE TO NORMAL DIAL-UP.
C
C	J. THOMPSON  INTERMETRICS  27 JULY 1979
C
	SUBROUTINE setterm(chan_num)
!	channel number is the channel of the terminal we want to set
	implicit integer*4 (a-z)
	include 'include.for'
	LOGICAL*1 B,BE(128),CLASS,TYPE,PAGELENGTH
	INTEGER*2 PAGEWIDTH
	INTEGER*4 TERM_CHAR
	CHARACTER*128 BUFF	!CHARACTERISTICS BUFFER

	COMMON/RTTCHAR/ B(128)

	EQUIVALENCE (BE(1),BUFF(1:1))
	EQUIVALENCE (CLASS,B(5)), (TYPE,B(6))
	EQUIVALENCE (PAGEWIDTH,B(7)), (TERM_CHAR,B(9))
	EQUIVALENCE (PAGELENGTH,B(12))
	EQUIVALENCE (W1,B(1)),(W2,B(5)),(W3,B(9))

	EXTERNAL TT$M_LOWER,TT$M_MECHTAB,TT$M_NOECHO
	EXTERNAL TT$M_WRAP,TT$M_REMOTE,TT$M_PASSALL,TT$M_SCOPE
	external tt$m_holdscreen,tt$m_ttsync,tt$m_halfdup
	external tt$m_hostsync

	call error(120,SYS$GETCHN(%VAL(chan_num),L1,BUFF,,,))
	DO 100 I=1,L1
100	B(I)=BE(I)


	TERM_CHAR = TERM_CHAR .OR. %LOC(TT$M_LOWER)
	TERM_CHAR = TERM_CHAR .OR. %LOC(TT$M_MECHTAB)
	TERM_CHAR = TERM_CHAR .OR. %LOC(TT$M_NOECHO)
	term_char = term_char .or. %loc(tt$m_hostsync)
	TERM_CHAR = TERM_CHAR .OR. %LOC(TT$M_REMOTE)
	TERM_CHAR = TERM_CHAR .OR. %LOC(TT$M_PASSALL)
	TERM_CHAR = TERM_CHAR .OR. %LOC(TT$M_SCOPE)
	term_char = term_char.and..not.%loc(tt$m_holdscreen)
	term_char = term_char.and..not.%loc(tt$m_ttsync)
	term_char = term_char.and..not.%loc(tt$m_halfdup)

	NOWRAP = .NOT. %LOC(TT$M_WRAP)
	TERM_CHAR = TERM_CHAR .AND. NOWRAP

	PAGEWIDTH = 132

	call error(110,SYS$QIOW(,%VAL(chan_num),%VAL(%LOC(IO$_SETMODE)),,,,
     *	B(5),%VAL(8),,,,))

C	THE %VAL(8) IS THE LENGTH OF THE CHARACTERISTICS BUFFER WHICH
C	STARTS AT BYTE 5 OF ARRARY B.  THIS P2 PARAMETER IS NOT DOCUMENTED
C	UP THROUGH RELEASE 1.5 OF VMS.


	RETURN


C	RESET TERMINAL SO IT CAN BE USED AS A DIAL-UP.
C	(DON'T NEED TO RESET ALL CHARACTERISTICS)

	entry unsetterm (chan_num)

	call error (130,SYS$GETCHN(%VAL(chan_num),L1,BUFF,,,))
	DO 200 I = 1,L1
200	B(I) = BE(I)

	ECHO = .NOT. %LOC(TT$M_NOECHO)
	INTERACTIVE = .NOT. %LOC(TT$M_PASSALL)

	TERM_CHAR = TERM_CHAR .AND. ECHO
	TERM_CHAR = TERM_CHAR .AND. INTERACTIVE
	TERM_CHAR = TERM_CHAR .OR. %LOC(TT$M_WRAP)
	term_char = term_char .or. %loc(tt$m_ttsync)

	PAGEWIDTH = 80

	call error (140,SYS$QIOW(,%VAL(chan_num),%VAL(%LOC(IO$_SETMODE)),,,,
     *	B(5),%VAL(8),,,,))

	RETURN
	END
