	SUBROUTINE ONEP1(TITL,NT)
C
C  Plot a set of (fairly) random data points
C
	DIMENSION TITL(1)
	DIMENSION X(8), Y(8)
C
	DATA X / 3.45, 2.67, 1.32, 4.44, 2.34, 8.00, 9.04,11.23/
	DATA Y / 2.33, 4.36, 2.84, 1.23, 4.65, 7.01,11.35,15.24/
C
	CALL ONEPLT(X,Y,8,'X data',6,'Y data',6,TITL,NT)
	END
	SUBROUTINE ONEP2(TITL,NT)
C
C  Plot a continuous diagonal wavy line
C
	DIMENSION TITL(1)
	DIMENSION X(100), Y(100)
C
	DO 100 I = 1, 100
	  X(I) = I / 2.0
	  Y(I) = SIN(X(I)) - X(I)
 100	CONTINUE
C
	CALL ONEPLT(X,Y,100,'X data',6,'Y data',6,TITL,NT)
	END
	SUBROUTINE ATOP1(TITL,NT)
C
C  Plot two sinusoidal lines, one connected, one not.
C
	DIMENSION TITL(1)
	DIMENSION X(200), Y(200), ISYM(200), NOTES(2,4)
C
	DATA (NOTES(1,I),I=1,3)/'Y=Sin(X)    and'/
	DATA (NOTES(2,I),I=1,2)/'Y=Cos(X)'/
C
	DO 100 I = 1,100
	  X(I) = I / 10.0
	  X(I+100) = X(I)
	  Y(I) = SIN(X(I))
	  Y(I+100) = COS(X(I))
	  ISYM(I) = 1
	  ISYM(I+100) = -14
 100	CONTINUE
C
	CALL ATOPLT(X,Y,ISYM,200,'X data',6,'Y data',6,
     *		    TITL,NT,NOTES,2)
	END
	INTEGER	I, N, EGS(12), A9
C
C	Read the number of examples to be plotted and the numbers
C	of the examples which are to be plotted.  Then loop plotting
C	one example each time round.
C
	OPEN(UNIT=10,ACCESS='SEQIN',FILE='APDEX.DAT')
	READ(10,1000) N, EGS
 1000	FORMAT(13I)
	CLOSE(UNIT=10)
C
C
C
	DO 600 I = 1, N
	  GOTO (10,20,30,40,50,60,70,80,90,100,110,120), EGS(I)
C
C	Simple use of ONEPLT
C
 10	  CALL ONEP1('Example 1',9)
	  GOTO 500
C
C	More simple use of ONEPLT
C
 20	  CALL ONEP2('Example 2',9)
	  GOTO 500
C
C	Simple use of ATOPLT
C
 30	  CALL ATOP1('Example 3',9)
	  GOTO 500
C
C	Using ATOPRM to cover a graph with a grid
C
 40	  CALL EX4
	  GOTO 500
C
C	Setting character labels on the X-axis
C
 50	  CALL EX5
	  GOTO 500
C
C	Plotting logarithms of the X-axis data
C
 60	  CALL EX6
	  GOTO 500
C
C	Fitting a linear least squares line to data
C
 70	  CALL ATOLSQ(1,1)
	  CALL ONEP1('Example 7',9)
	  CALL ATOLSQ(-1)
	  GOTO 500
C
C	Plotting INTEGER values as tick labels along the X-axis
C
 80	  CALL ATOGET(1,37,A8)
	  CALL ATOPRM(1,37,1.0)
	  CALL ATOP1('Example 8',9)
	  CALL ATOPRM(1,37,A8)
	  GOTO 500
C
C	Fixing the increment in values at ticks along the X-axis
C	to 0.5
C
 90	  CALL ATOGET(1,33,A9)
	  CALL ATOPRM(1,33,0.5)
	  CALL ONEP1('Example 9',9)
	  CALL ATOPRM(1,33,A9)
	  GOTO 500
C
C	Fixing the value at some tick on the X-axis to 5.0
C
 100	  CALL EX10
	  GOTO 500
C
C	Fixing the tick value at the origin of the X-axis to 3.0
C	and causing windowing of the data
C
 110	  CALL EX11
	  GOTO 500
C
C	Use of simple plotting method
C
 120	  CALL EX12
C
C
C
 500	  WRITE(6,1010) EGS(I)
 1010	  FORMAT(' Example ',I2,' plotted')
 600	CONTINUE
C
C
	END
	SUBROUTINE EX4
C
C	Cause a grid to be drawn over the graph
C
	DIMENSION I4(4), X4(4), A4(4), J4(2)
C
	DATA I4 /   7  ,  26  ,   8  ,  27  /
	DATA X4 / 220.0, 280.0,   0.0,  -2.0/
	DATA J4 /   4  ,   3/
C
	CALL ATOGET(4,I4,A4)
	CALL ATOGET(2,J4,X4)
	X4(1) = X4(1) * 0.5
	X4(2) = X4(2) * 0.5
	CALL ATOPRM(4,I4,X4)
	CALL ATOP1('Example 4',9)
	CALL ATOPRM(4,I4,A4)
	END
	SUBROUTINE EX5
C
C	Writing the tick labels as character values instead
C	of numbers
C
	DIMENSION DAYS(7), I5(3), A5(3)
	DATA DAYS/' Sun  Mon  Tue  Wed  Thu  Fri  Sat '/
	DATA I5/31, 33, 35/
C
	CALL ATOGET(3,I5,A5)
	CALL ATOCHL(1,7,DAYS,0.5,0.0)
	CALL ONEP1('Example 5',9)
	CALL ATOCHL(-1)
	CALL ATOPRM(3,I5,A5)
	END
	SUBROUTINE EX6
C
C	Plotting logarithms of data
C
	DIMENSION I6(2), X6(2), A6(2)
	DATA I6, X6 /31, 35, 2.0, 1.0/
C
	CALL ATOGET(2,I6,A6)
	CALL ATOLOG(1)
	CALL ATOPRM(2,I6,X6)
	CALL ONEP1('Example 6',9)
	CALL ATOLOG(-1)
	CALL ATOPRM(2,I6,A6)
	END
	SUBROUTINE EX10
C
C	Fixing one tick value along the X-axis
C
	DIMENSION I10(2), X10(2), A10(2)
	DATA I10, X10 /31, 35, 1.0, 5.0/
C
	CALL ATOGET(2,I10,A10)
	CALL ATOPRM(2,I10,X10)
	CALL ONEP1('Example 10',10)
	CALL ATOPRM(2,I10,A10)
	END
	SUBROUTINE EX11
C
C	Fixing the X-axis origin and windowing
C
	DIMENSION I11(2), X11(2), A11(2)
	DATA I11, X11/ 31, 35, 2.0, 3.0/
C
	CALL ATOGET(2,I11,A11)
	CALL ATOPRM(2,I11,X11)
	CALL ONEP1('Example 11',10)
	CALL ATOPRM(2,I11,A11)
	END
	SUBROUTINE EX12
C
C	Really simple stuff
C
	DIMENSION X(8), Y(8)
C
	DATA X / 1.32, 2.34, 2.67, 3.45, 4.44, 8.00, 9.04,11.23/
	DATA Y / 2.84, 4.65, 4.36, 2.33, 1.23, 7.01,11.35,15.24/
C
	CALL SIMPLT(X,Y,8)
	END
