	SUBROUTINE TEXT(N, FILE, STRING, COUNT)
C************************************************************
C
C  THIS ROUTINE IS USED TO ADD TEXT TO THE DISPLAY
C  FILE CURRENTLY BEING BUILT. TEXT IS ADDED TO THE
C  CURRENT POSITION OF THE DISPLAY BEAM. ITALICS MAY
C  BE ENABLED OR DISABLED THROUGH A CALL TO "SETA".
C
C  STRING IS AN ASCII ARRAY PACKED 5 BYTES TO A WORD,
C  LEFT JUSTIFIED. (I.E. A5 FORMAT, HOLLERITH CONSTANTS
C  MAY BE USED)
C
C  POSSIBLE ERRORS:
C	NONE
C
C  WARNINGS:
C	FULL SHIFT-IN, SHIFT-OUT CHARACTERS ARE ALLOWED.
C	IF IN SHIFT-IN, AND A NON-PRINTING CHARACTER IS DETECTED
C	IT WILL BE REPLACED BY A "?". IF IN SHIFT-OUT AND
C	AN ILLEGAL CHARACTER IS DETECTED IT WILL BE REPLACED
C	BY A SHIFT-IN FOLLOWED BY THE CHARACTER.
C
C  ROUTINES CALLED:
C	SETSTA - RETURNS A STATUS-A INSTRUCTION
C	ADWORD - ADDS A WORD TO THE DISPLAY FILE
C	SETGM  - RETURNS AN S.G.M. INSTRUCTION
C	GFIELD - BYTE RETRIEVAL ROUTINE
C	ADBYTE - ADDS A BYTE TO THE DISPLAY FILE
C
C************************************************************
	IMPLICIT INTEGER (A - W, Z)
	INTEGER STRING(15), FILE(N)
	LOGICAL LP, BLINK, SHIFT
	COMMON /SCLBLK/ XMIN, YMIN, XMAX, YMAX, BEAMX, BEAMY
	COMMON /MODBLK/ MODE, INT, LP, BLINK, LINE, OLDSGM
	COMMON /STABLK/ ITALA, LPA, OLDSTA
	COMMON /MSCBLK/ SHIFT, CHECK
	DATA SO, SI /"16, "17/

	BEAMX = FILE(2)
	BEAMY = FILE(3)
	OLDSGM = FILE(4)
	OLDSTA = FILE(5)
	NEWSTA = SETSTA(ITALA, LPA)
	IF(NEWSTA .EQ. OLDSTA) GO TO 100
	OLDSTA = NEWSTA
	CALL ADWORD(N, FILE, OLDSTA)
100	MODE = "0
	SHIFT = .FALSE.
	NEWSGM = SETGM(MODE, INT, LP, BLINK, LINE)
	IF(NEWSGM .EQ. OLDSGM) GO TO 200
	OLDSGM = NEWSGM
	CALL ADWORD(N, FILE, OLDSGM)
	WIDTH = 14

200	DO 700 I = 1, COUNT
	  WPOS = I / 5
	  IF(MOD(I,5) .NE. 0) WPOS = WPOS + 1
	  BPOS = MOD(I,5)
	  IF(BPOS .EQ. 0) BPOS = 5
	  CHAR = GFIELD(STRING(WPOS), (BPOS - 1) * 7, 7)
	  IF(.NOT. SHIFT) GO TO 400

C  SHIFTED - OUT PROCESSING
	  IF(CHAR .GE. "40) GO TO 300
	  IF(CHAR .NE. SI) GO TO 600
	  CALL ADBYTE(N, FILE, SI)
	  SHIFT = .FALSE.
	  GO TO 700
300	  CALL ADBYTE(N, FILE, SI)
	  SHIFT = .FALSE.
	  GO TO 600

C  SHIFTED - IN PROCESSING
400	  IF(CHAR .GE. "40) GO TO 600
	  IF(CHAR .NE. SO) GO TO 500
	  SHIFT = .TRUE.
	  CALL ADBYTE(N, FILE, CHAR)
	  GO TO 700
500	  CHAR = "77
600	  CALL ADBYTE(N, FILE, CHAR)
	  BEAMX = BEAMX + WIDTH
700	CONTINUE

	FILE(2) = BEAMX
	FILE(3) = BEAMY
	FILE(4) = OLDSGM
	FILE(5) = OLDSTA
	RETURN
	END
