	SUBROUTINE POINT(N, FILE, X, Y)
C************************************************************
C
C  THIS ROUTINE INSERTS AN ABSOLUTE (INVISIBLE)
C  POINT AT USER (X, Y).
C
C  POSSIBLE ERRORS:
C	NONE
C
C  WARNING:
C	IF ANY DISPLAY FILE CONTAINS A CALL TO POINT, THEN
C	THE DISPLAY FILE IS NOT STRICTLY RELOCATABLE. THE
C	FILE MAY BE MOVED, BUT ONLY THAT PORTION OF THE
C	DISPLAY PRIOR TO THE POINT WILL CHANGE POSITION.
C
C	HOWEVER, CALLS TO POINT DO HAVE THEIR ADVANTAGES.
C	WHEN BUILDING RELOCATABLE DISPLAY FILES, ERRORS IN
C	POSITION (DUE TO ROUNDOFF, AND INTEGER APPROXIMATION)
C	TEND TO PROPAGATE. IF IT IS NOT ESSENTIAL TO HAVE
C	A RELOCATABLE DISPLAY, AN OCCASSIONAL CALL TO POINT
C	WILL RESULT IN A MORE ACCURATE DISPLAY FILE.
C
C  ROUTINES CALLED:
C	SETSTA - RETURNS A STATUS-A INSTRUCTION
C	ADWORD - ADDS A WORD TO THE DISPLAY FILE
C	SETGM  - RETURNS A S.G.M. INSTRUCTION
C	IPHYSX - RETURNS RASTER IX OF USER X
C	IPHYSY - RETURNS RASTER IY OF USER Y
C
C************************************************************
	IMPLICIT INTEGER (A - W, Z)
	INTEGER FILE(N)
	LOGICAL LP, BLINK, ITALA, LPA
	COMMON /MODBLK/ MODE, INT, LP, BLINK, LINE, OLDSGM
	COMMON /STABLK/ ITALA, LPA, OLDSTA
	COMMON /SCLBLK/ XMIN, YMIN, XMAX, YMAX, BEAMX, BEAMY

	BEAMX = FILE(2)
	BEAMY = FILE(3)
	OLDSGM = FILE(4)
	OLDSTA = FILE(5)
	NEWSTA = SETSTA(ITALA, LPA)
	IF(NEWSTA .EQ. OLDSTA) GO TO 100
	OLDSTA = NEWSTA
	CALL ADWORD(N, FILE, OLDSTA)

100	MODE = "3
	NEWSGM = SETGM(MODE, INT, LP, BLINK, LINE)
	IF(NEWSGM .EQ. OLDSGM) GO TO 200
	OLDSGM = NEWSGM
	CALL ADWORD(N, FILE, OLDSGM)


200	BEAMX = IPHYSX(X)
	IF(BEAMX .GT. "1777) BEAMX = "1777
	BEAMY = IPHYSY(Y)
	IF(BEAMY .GT. "1377) BEAMY = "1377
	CALL ADWORD(N, FILE, BEAMX)
	CALL ADWORD(N, FILE, BEAMY)
	FILE(2) = BEAMX
	FILE(3) = BEAMY
	FILE(4) = OLDSGM
	FILE(5) = OLDSTA
	RETURN
	END
