	SUBROUTINE ADWORD(N, FILE, WORD)
C************************************************************
C
C  THIS ROUTINE IS USED TO ADD A WORD TO THE DISPLAY
C  FILE CURRENTLY BEING BUILT. IN ADDITION, OPTIONAL
C  BOUNDS CHECKING WILL BE DONE.
C
C  POSSIBLE ERRORS:
C	?DISPLAY FILE NOT INITIALIZED
C	?EXCEEDING DIMENSION OF ACTIVE DISPLAY FILE
C
C  ROUTINES CALLED:
C	SFIELD - BYTE STORAGE ROUTINE
C	ERROR  - ERROR LOGGING ROUTINE
C	FINI   - PROGRAM EXIT ROUTINE
C
C************************************************************
	IMPLICIT INTEGER (A - Z)
	LOGICAL SHIFT
	INTEGER FILE(N)
	COMMON /MSCBLK/ SHIFT, CHECK

	IF(N .LT. 13) CALL ERROR('?DISPLAY FILE NOT INITIALIZED', 0)
	IF(N .LT. 13) RETURN
	WPOS = N / 4
	IF(MOD(N,4) .NE. 0) WPOS = WPOS + 1
	IF(WPOS .LE. FILE(1) - 1) GO TO 100
	CALL ERROR('?EXCEEDING DIMENSION OF DISPLAY FILE, SUB. =',WPOS)
	CALL FINI

100	BPOS = MOD(N,4)
	IF(BPOS .EQ. 0) BPOS = 4
	GO TO (200, 300, 400, 500), BPOS
200	CALL SFIELD(FILE(WPOS), 2, 16, WORD)
	N = N + 2
	RETURN

300	CALL SFIELD(FILE(WPOS), 2, 8, 0)
	CALL SFIELD(FILE(WPOS), 20, 16, WORD)
	N = N + 3
	RETURN

400	CALL SFIELD(FILE(WPOS), 20, 16, WORD)
	N = N + 2
	RETURN

500	CALL SFIELD(FILE(WPOS), 20, 8, 0)
	CALL SFIELD(FILE(WPOS + 1), 2, 16, WORD)
	N = N + 3
	RETURN
	END
