	SUBROUTINE ADBYTE(N, FILE, BYTE)
C************************************************************
C
C  THIS ROUTINE IS USED TO ADD A BYTE TO DISPLAY FILE "FILE"
C  THE ROUTINE WILL ALSO DO OPTIONAL BOUNDS CHECKING. THE ONLY
C  SYSTEM ROUTINE TO USE ADBYTE IS "TEXT.F4".
C
C  POSSIBLE ERRORS:
C	?DISPLAY FILE NOT INITIALIZED
C	?EXCEEDING DIMENSION OF CURRENT DISPLAY FILE
C
C  ROUTINES CALLED:
C	SFIELD - BYTE STORAGE ROUTINE
C	ERROR  - ERROR LOGGING ROUTINE
C	FINI   - ERROR WRAP-UP ROUTINE
C
C************************************************************
	IMPLICIT INTEGER (A - Z)
	INTEGER FILE(N)
	LOGICAL SHIFT
	COMMON /MSCBLK/ SHIFT, CHECK

	IF(N .LT. 13) CALL ERROR('?DISPLAY FILE NOT INITIALIZED', 0)
	IF(N .LT. 13) CALL FINI
	WPOS = N / 4
	IF(MOD(N,4) .NE. 0) WPOS = WPOS + 1
	IF(WPOS .LT. FILE(1)) GO TO 100
	CALL ERROR('?EXCEEDING DIMENSION (ADBYTE), SUB. =',WPOS)
	CALL FINI

100	BPOS = MOD(N,4)
	IF(BPOS .EQ. 0) CALL SFIELD(FILE(WPOS), 20, 8, BYTE)
	IF(BPOS .EQ. 1) CALL SFIELD(FILE(WPOS), 10, 8, BYTE)
	IF(BPOS .EQ. 2) CALL SFIELD(FILE(WPOS), 2, 8, BYTE)
	IF(BPOS .EQ. 3) CALL SFIELD(FILE(WPOS), 28, 8, BYTE)
	N = N + 1
	RETURN
	END
