C     [DEM32]
C     DEMONSTRATION FOR THE INCLINED VIEW PROGRAM PLTIV.  THE SURFACE
C     REPRESENTED IS THE SAME ONE USED IN DEM30 AND DEM31, WHICH IS THE
C     ABSOLUTE VALUE OF A FUNCTION OF A COMPLEX VARIABLE WITH FIVE POLES
C     LOCATED AT THE VERTICES OF A REGULAR HEXAGON. TWO OPTIONS SHOW
C     SHOW DIFFERENT STAGES OR ROTATION ABOUT A VERTICAL AXIS (L=1) OR
C     DIFFERENT DEGREES OF TILT ABOUT A HORIZONTAL AXIS (L=2).
C     [30-MAY-75]

      EXTERNAL    PLTCA,PLTQ1,PLTQ2,PLTQ3,PLTQ4
      COMPLEX     P,U,V,Z
      DIMENSION   O(3,3),W(121,121)

      P(Z)=1.0+Z*(1.0+Z*(1.0+Z*(1.0+Z*(1.0+Z))))

      L=2
      NX=121
      NY=121
      X1=-1.5
      X2= 1.5
      Y1=-1.5
      Y2= 1.5
      DX=(X2-X1)/FLOAT(NX-1)
      DY=(Y2-Y1)/FLOAT(NY-1)
      Y=Y1
      DO 20 I=1,NY
      X=X1
      DO 10 J=1,NX
      Z=CMPLX(X,Y)
      U=1.0/P(Z)-Z
      AM=CABS(U)
      W(J,I)=TANH(0.25*AM)
   10 X=X+DX
      W( 1,I)=0.0
      W(NX,I)=0.0
   20 Y=Y+DY
      DO 30 J=1,NY
      W(J, 1)=0.0
   30 W(J,NY)=0.0

      CALL PLT00
      CALL PLTFR
      CALL PLTLA ('DEM32')
      IF (L.EQ.1) CALL PLTIV (0.0,W,1.0,NX,NY,-45.0,47.1,PLTQ1)
      IF (L.EQ.1) CALL PLTIV (0.0,W,1.0,NX,NY,-135.0,47.1,PLTQ2)
      IF (L.EQ.1) CALL PLTIV (0.0,W,1.0,NX,NY,135.0,47.1,PLTQ3)
      IF (L.EQ.1) CALL PLTIV (0.0,W,1.0,NX,NY,45.0,47.1,PLTQ4)
      IF (L.EQ.2) CALL PLTIV (0.0,W,1.0,NX,NY,60.0,15.0,PLTQ1)
      IF (L.EQ.2) CALL PLTIV (0.0,W,1.0,NX,NY,60.0,30.0,PLTQ2)
      IF (L.EQ.2) CALL PLTIV (0.0,W,1.0,NX,NY,60.0,60.0,PLTQ3)
      IF (L.EQ.2) CALL PLTIV (0.0,W,1.0,NX,NY,60.0,88.0,PLTQ4)
      CALL PLTEJ
      CALL EXIT
      END

