      FUNCTION IPLHIT(KONTRL,IWIDE,IHIGH,IX,IY,JX,JY,
     1IPENX,IPENY)
C
C     DONALD BARTH, CHEMISTRY DEPT., HARVARD UNIVERISTY
C
C     FUNCTION TO TEST IF TABLET STYLUS POINTS TO POINT
C     OR LINE
C
C     IPLHIT = 0 RETURNED IF STYLUS DOESN'T POINT TO LINE
C            = 1 RETURNED IF STYLUS POINTS TO LINE
C
C     KONTRL = 0, DOES NOT OUTLINE ACTIVE AREA
C            = 1, OUTLINES ACTIVE AREA IF TEST SUCCESSFUL
C     IWIDE  = HALF-WIDTH OF ACTIVE AREA AROUND POINT
C              OR LINE
C     IHIGH  = -1, TEST IF STYLUS POINTS TO LINE
C              (ACITIVE AREA EXTENDS BEYOND ENDS OF LINE)
C            = 0, TEST IF STYLUS POINTS TO MIDDLE OF LINE
C              (ACTIVE AREA EXTENDS ONLY TO ENDS OF LINE)
C            = POSITIVE, HALF-HEIGHT OF ACTIVE AREA
C              AROUND POINT (JX AND JY ARE NOT USED)
C     IX     = HORIZONTAL COORDINATE OF POINT OR
C              OF END 1 OF LINE
C     IY     = VERTICAL COORDINATE OF POINT OR
C              OF END 1 OF LINE
C     JX     = HORIZONTAL COORDINATE OF END 2 OF LINE
C     JY     = VERTICAL COORDINATE OF END 2 OF LINE
C     IPENX  = HORIZONTAL POSITION OF STYLUS
C     IPENY  = VERTICAL POSITION OF STYLUS
C
C     TEST IF LINE OR POINT TEST TO BE MADE
      IF(IHIGH)7,7,111
C
C     TEST IF STYLUS POINTS TO POINT
C
  111 MOVEX=IHIGH
    1 IF(IX-IWIDE-IPENX)2,2,31
    2 IF(IX+IWIDE-IPENX)31,3,3
    3 IF(IY-MOVEX-IPENY)4,4,31
    4 IF(IY+MOVEX-IPENY)31,5,5
    5 IF(KONTRL)30,30,6
    6 MOVEY=0
      KX=IX+IWIDE
      KY=IY
      LX=IX-IWIDE
      LY=IY
      GO TO 29
   91 IF(IHIGH)92,31,31
   92 MOVEX=IWIDE
      GO TO 1
C
C     TEST IF STYLUS POINTS TO LINE
C
C     DETERMINE OCTANT CONTAINING LINE
    7 IDSTX=JX-IX
      IDSTY=JY-IY
      IF(IDSTX-IDSTY)8,9,10
    8 IF(IDSTX+IDSTY)14,11,11
    9 IF(IDSTX+IDSTY)14,91,12
   10 IF(IDSTX+IDSTY)13,12,12
   11 MOVEY=IWIDE
      MOVEX=(IDSTX*MOVEY)/IDSTY
      IF(IDSTX)15,16,16
   12 MOVEX=IWIDE
      MOVEY=(IDSTY*MOVEX)/IDSTX
      IF(IDSTY)17,18,18
   13 MOVEY=-IWIDE
      MOVEX=(IDSTX*MOVEY)/IDSTY
      IF(IDSTX)15,16,16
   14 MOVEX=-IWIDE
      MOVEY=(IDSTY*MOVEX)/IDSTX
      IF(IDSTY)17,18,18
C
C     CORRECT WIDTH OF STRIP FOR ANGLE OF LINE
   15 KX=IWIDE+(MOVEX/4)
      GO TO 19
   16 KX=IWIDE-(MOVEX/4)
      GO TO 19
   17 KX=IWIDE+(MOVEY/4)
      GO TO 19
   18 KX=IWIDE-(MOVEY/4)
   19 MOVEX=(KX*MOVEX)/IWIDE
      MOVEY=(KX*MOVEY)/IWIDE
C
C     TEST IF STYLUS IS WITHIN STRIP ALONG LINE
      IF((IDSTX*(IPENY-IY-MOVEX))-
     1   (IDSTY*(IPENX-IX+MOVEY)))20,20,31
   20 IF((IDSTX*(IPENY-JY+MOVEX))-
     1   (IDSTY*(IPENX-JX-MOVEY)))31,22,22
   22 IF(IHIGH)23,24,24
C
C     DEFINE ACTIVE AREA EXTENDING BEYOND LINE ENDS
   23 KX=IX-MOVEX
      KY=IY-MOVEY
      LX=JX+MOVEX
      LY=JY+MOVEY
      GO TO 25
C
C     DEFINE ACTIVE AREA TOUCHING LINE ENDS
   24 KX=IX
      KY=IY
      LX=JX
      LY=JY
C
C     TEST IF STYLUS IS BETWEEN ENDS OF ACTIVE AREA
   25 IF((IDSTX*(IPENX-KX))+(IDSTY*(IPENY-KY)))31,31,27
   27 IF((IDSTX*(IPENX-LX))+(IDSTY*(IPENY-LY)))28,28,31
   28 IF(KONTRL)30,30,29
C
C     OUTLINE ACTIVE AREA AROUND LINE
   29 CALL CRTOFF(KX+MOVEY,KY-MOVEX)
      CALL CRTON (LX+MOVEY,LY-MOVEX)
      CALL CRTON (LX-MOVEY,LY+MOVEX)
      CALL CRTON (KX-MOVEY,KY+MOVEX)
      CALL CRTON (KX+MOVEY,KY-MOVEX)
C
C     SET VALUE OF FUNCTION AND RETURN
   30 IPLHIT=1
      GO TO 32
   31 IPLHIT=0
   32 RETURN
      END
